import{s as Nn,n as Fn,o as In}from"../chunks/scheduler.85c25b89.js";import{S as Rn,i as Hn,g as n,s as a,r as p,A as En,h as o,f as i,c as r,j as u,u as d,x as m,k as v,y as t,a as l,v as c,d as g,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.288498f9.js";import{H as xa}from"../chunks/Heading.3097d2ed.js";function Sn(Mr){let S,Et,Rt,St,te,Gt,ae,Pr="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",Ot,re,Bt,ne,Vt,G,oe,$a,Ge,Nr=`Legacy optimizer factory for backwards compatibility.
NOTE: Use create_optimizer_v2 for new code.`,qt,z,ie,wa,Oe,Fr="Create an optimizer.",Aa,Be,Ir=`TODO currently the model is passed in and all parameters are selected for optimization.
For more general use an interface that allows selection of parameters to optimize and lr groups, one of:`,La,Ve,Rr="<li>a filter fn interface that further breaks params into groups in a weight_decay compatible fashion</li> <li>expose the parameters interface and leave it up to caller</li>",Wt,me,kt,x,se,Ca,qe,Hr="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Ta,We,Er="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Da,ke,Sr=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,za,je,Gr='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Ma,O,le,Pa,Ue,Or="Performs a single optimization step.",jt,L,pe,Na,Ze,Br=`Implements Adafactor algorithm.
This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,Fa,Qe,Vr=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,Ia,Xe,qr=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,Ra,B,de,Ha,Je,Wr="Performs a single optimization step.",Ut,$,ce,Ea,Ke,kr="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",Sa,V,ge,Ga,Ye,jr="Gets all parameters in all param_groups with gradients",Oa,q,fe,Ba,et,Ur="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",Va,W,he,qa,tt,Zr="Performs a single optimization step.",Wa,k,ue,ka,at,Qr="Zeros out the accumalated hessian traces.",Zt,ve,be,Qt,C,_e,ja,rt,Xr="Implements AdamW algorithm.",Ua,nt,Jr=`The original Adam algorithm was proposed in <code>Adam: A Method for Stochastic Optimization</code><em>.
The AdamW variant was proposed in <code>Decoupled Weight Decay Regularization</code></em>.`,Za,ot,Kr=`.. _Adam\\: A Method for Stochastic Optimization:
<a href="https://arxiv.org/abs/1412.6980" rel="nofollow">https://arxiv.org/abs/1412.6980</a>
.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,Qa,j,ye,Xa,it,Yr="Performs a single optimization step.",Xt,T,xe,Ja,mt,en=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Ka,st,tn="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",Ya,lt,an=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,er,U,$e,tr,pt,rn="Performs a single optimization step.",Jt,M,we,ar,dt,nn="LARS for PyTorch",rr,ct,on='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',nr,Z,Ae,or,gt,mn="Performs a single optimization step.",Kt,Le,Ce,Yt,y,Te,ir,ft,sn=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,mr,ht,ln='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',sr,ut,pn=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,lr,vt,dn=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,pr,bt,cn="On sparse problems both weight_decay and momentum should be set to 0.",dr,Q,De,cr,_t,gn="Performs a single optimization step.",ea,w,ze,gr,yt,fn="Implements Nadam algorithm (a variant of Adam based on Nesterov momentum).",fr,xt,hn="It has been proposed in <code>Incorporating Nesterov Momentum into Adam</code>__.",hr,$t,un='<strong><a href="http://cs229.stanford.edu/proj2015/054_report.pdf" rel="nofollow">http://cs229.stanford.edu/proj2015/054_report.pdf</a></strong> <a href="http://www.cs.toronto.edu/~fritz/absps/momentum.pdf" rel="nofollow">http://www.cs.toronto.edu/~fritz/absps/momentum.pdf</a>',ur,wt,vn=`Originally taken from: <a href="https://github.com/pytorch/pytorch/pull/1408" rel="nofollow">https://github.com/pytorch/pytorch/pull/1408</a>
NOTE: Has potential issues but does work well on some problems.`,vr,X,Me,br,At,bn="Performs a single optimization step.",ta,I,Pe,_r,Lt,_n="Implements Novograd algorithm.",yr,J,Ne,xr,Ct,yn="Performs a single optimization step.",aa,Fe,Ie,ra,_,Re,$r,Tt,xn="Implements RMSprop algorithm (TensorFlow style epsilon)",wr,Dt,$n=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,Ar,zt,wn="Noteworthy changes include:",Lr,Mt,An="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",Cr,Pt,Ln=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,Tr,Nt,Cn=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,Dr,K,He,zr,Ft,Tn="Performs a single optimization step.",na,Ee,Se,oa,Ht,ia;return te=new xa({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),re=new xa({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),ne=new xa({props:{title:"Factory functions",local:"timm.optim.create_optimizer",headingTag:"h3"}}),oe=new b({props:{name:"timm.optim.create_optimizer",anchor:"timm.optim.create_optimizer",parameters:[{name:"args",val:""},{name:"model",val:""},{name:"filter_bias_and_bn",val:" = True"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/optim_factory.py#L182"}}),ie=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:""},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": typing.Optional[float] = None"},{name:"param_group_fn",val:": typing.Optional[typing.Callable] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> (nn.Module) &#x2014; model containing parameters to optimize
opt &#x2014; name of optimizer to create
lr &#x2014; initial learning rate
weight_decay &#x2014; weight decay to apply in optimizer
momentum &#x2014;  momentum for momentum based optimizers (others may use betas via kwargs)
foreach &#x2014; Enable / disable foreach (multi-tensor) operation if True / False. Choose safe default if None
filter_bias_and_bn &#x2014;  filter out bias, bn and other 1d params from weight decay
**kwargs &#x2014; extra optimizer specific kwargs to pass through`,name:"model_or_params"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/optim_factory.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Optimizer</p>
`}}),me=new xa({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),se=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L6"}}),le=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L89"}}),pe=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L16"}}),de=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L79"}}),ce=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L9"}}),ge=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L58"}}),fe=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L74"}}),he=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L102"}}),ue=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L65"}}),be=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamp.py#L43"}}),_e=new b({props:{name:"class timm.optim.AdamW",anchor:"timm.optim.AdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.AdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.AdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"},{anchor:"timm.optim.AdamW.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L12"}}),ye=new b({props:{name:"step",anchor:"timm.optim.AdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L58"}}),xe=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L60"}}),$e=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L96"}}),we=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L17"}}),Ae=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L75"}}),Ce=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lookahead.py#L15"}}),Te=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": typing.Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L24"}}),De=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": typing.Union[typing.Callable[[], float], NoneType] = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L85"}}),ze=new b({props:{name:"class timm.optim.Nadam",anchor:"timm.optim.Nadam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.002"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"schedule_decay",val:" = 0.004"}],parametersDescription:[{anchor:"timm.optim.Nadam.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.Nadam.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 2e-3)",name:"lr"},{anchor:"timm.optim.Nadam.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square`,name:"betas"},{anchor:"timm.optim.Nadam.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Nadam.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Nadam.schedule_decay",description:"<strong>schedule_decay</strong> (float, optional) &#x2014; momentum schedule decay (default: 4e-3)",name:"schedule_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L7"}}),Me=new b({props:{name:"step",anchor:"timm.optim.Nadam.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Nadam.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L43"}}),Pe=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:`<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)
grad_averaging &#x2014; gradient averaging`,name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L13"}}),Ne=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L54"}}),Ie=new b({props:{name:"class timm.optim.RAdam",anchor:"timm.optim.RAdam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/radam.py#L10"}}),Re=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L14"}}),He=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L72"}}),Se=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdp.py#L19"}}),{c(){S=n("meta"),Et=a(),Rt=n("p"),St=a(),p(te.$$.fragment),Gt=a(),ae=n("p"),ae.innerHTML=Pr,Ot=a(),p(re.$$.fragment),Bt=a(),p(ne.$$.fragment),Vt=a(),G=n("div"),p(oe.$$.fragment),$a=a(),Ge=n("p"),Ge.textContent=Nr,qt=a(),z=n("div"),p(ie.$$.fragment),wa=a(),Oe=n("p"),Oe.textContent=Fr,Aa=a(),Be=n("p"),Be.textContent=Ir,La=a(),Ve=n("ul"),Ve.innerHTML=Rr,Wt=a(),p(me.$$.fragment),kt=a(),x=n("div"),p(se.$$.fragment),Ca=a(),qe=n("p"),qe.textContent=Hr,Ta=a(),We=n("p"),We.textContent=Er,Da=a(),ke=n("p"),ke.innerHTML=Sr,za=a(),je=n("ul"),je.innerHTML=Gr,Ma=a(),O=n("div"),p(le.$$.fragment),Pa=a(),Ue=n("p"),Ue.textContent=Or,jt=a(),L=n("div"),p(pe.$$.fragment),Na=a(),Ze=n("p"),Ze.innerHTML=Br,Fa=a(),Qe=n("p"),Qe.innerHTML=Vr,Ia=a(),Xe=n("p"),Xe.innerHTML=qr,Ra=a(),B=n("div"),p(de.$$.fragment),Ha=a(),Je=n("p"),Je.textContent=Wr,Ut=a(),$=n("div"),p(ce.$$.fragment),Ea=a(),Ke=n("p"),Ke.textContent=kr,Sa=a(),V=n("div"),p(ge.$$.fragment),Ga=a(),Ye=n("p"),Ye.textContent=jr,Oa=a(),q=n("div"),p(fe.$$.fragment),Ba=a(),et=n("p"),et.textContent=Ur,Va=a(),W=n("div"),p(he.$$.fragment),qa=a(),tt=n("p"),tt.textContent=Zr,Wa=a(),k=n("div"),p(ue.$$.fragment),ka=a(),at=n("p"),at.textContent=Qr,Zt=a(),ve=n("div"),p(be.$$.fragment),Qt=a(),C=n("div"),p(_e.$$.fragment),ja=a(),rt=n("p"),rt.textContent=Xr,Ua=a(),nt=n("p"),nt.innerHTML=Jr,Za=a(),ot=n("p"),ot.innerHTML=Kr,Qa=a(),j=n("div"),p(ye.$$.fragment),Xa=a(),it=n("p"),it.textContent=Yr,Xt=a(),T=n("div"),p(xe.$$.fragment),Ja=a(),mt=n("p"),mt.innerHTML=en,Ka=a(),st=n("p"),st.innerHTML=tn,Ya=a(),lt=n("p"),lt.innerHTML=an,er=a(),U=n("div"),p($e.$$.fragment),tr=a(),pt=n("p"),pt.textContent=rn,Jt=a(),M=n("div"),p(we.$$.fragment),ar=a(),dt=n("p"),dt.textContent=nn,rr=a(),ct=n("p"),ct.innerHTML=on,nr=a(),Z=n("div"),p(Ae.$$.fragment),or=a(),gt=n("p"),gt.textContent=mn,Kt=a(),Le=n("div"),p(Ce.$$.fragment),Yt=a(),y=n("div"),p(Te.$$.fragment),ir=a(),ft=n("p"),ft.textContent=sn,mr=a(),ht=n("p"),ht.innerHTML=ln,sr=a(),ut=n("p"),ut.textContent=pn,lr=a(),vt=n("p"),vt.textContent=dn,pr=a(),bt=n("p"),bt.textContent=cn,dr=a(),Q=n("div"),p(De.$$.fragment),cr=a(),_t=n("p"),_t.textContent=gn,ea=a(),w=n("div"),p(ze.$$.fragment),gr=a(),yt=n("p"),yt.textContent=fn,fr=a(),xt=n("p"),xt.innerHTML=hn,hr=a(),$t=n("p"),$t.innerHTML=un,ur=a(),wt=n("p"),wt.innerHTML=vn,vr=a(),X=n("div"),p(Me.$$.fragment),br=a(),At=n("p"),At.textContent=bn,ta=a(),I=n("div"),p(Pe.$$.fragment),_r=a(),Lt=n("p"),Lt.textContent=_n,yr=a(),J=n("div"),p(Ne.$$.fragment),xr=a(),Ct=n("p"),Ct.textContent=yn,aa=a(),Fe=n("div"),p(Ie.$$.fragment),ra=a(),_=n("div"),p(Re.$$.fragment),$r=a(),Tt=n("p"),Tt.textContent=xn,wr=a(),Dt=n("p"),Dt.textContent=$n,Ar=a(),zt=n("p"),zt.textContent=wn,Lr=a(),Mt=n("ol"),Mt.innerHTML=An,Cr=a(),Pt=n("p"),Pt.innerHTML=Ln,Tr=a(),Nt=n("p"),Nt.innerHTML=Cn,Dr=a(),K=n("div"),p(He.$$.fragment),zr=a(),Ft=n("p"),Ft.textContent=Tn,na=a(),Ee=n("div"),p(Se.$$.fragment),oa=a(),Ht=n("p"),this.h()},l(e){const s=En("svelte-u9bgzb",document.head);S=o(s,"META",{name:!0,content:!0}),s.forEach(i),Et=r(e),Rt=o(e,"P",{}),u(Rt).forEach(i),St=r(e),d(te.$$.fragment,e),Gt=r(e),ae=o(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1c6qm22"&&(ae.innerHTML=Pr),Ot=r(e),d(re.$$.fragment,e),Bt=r(e),d(ne.$$.fragment,e),Vt=r(e),G=o(e,"DIV",{class:!0});var ma=u(G);d(oe.$$.fragment,ma),$a=r(ma),Ge=o(ma,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1dlcrvh"&&(Ge.textContent=Nr),ma.forEach(i),qt=r(e),z=o(e,"DIV",{class:!0});var Y=u(z);d(ie.$$.fragment,Y),wa=r(Y),Oe=o(Y,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-12lpmmq"&&(Oe.textContent=Fr),Aa=r(Y),Be=o(Y,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-ocfv4n"&&(Be.textContent=Ir),La=r(Y),Ve=o(Y,"UL",{"data-svelte-h":!0}),m(Ve)!=="svelte-qarx5u"&&(Ve.innerHTML=Rr),Y.forEach(i),Wt=r(e),d(me.$$.fragment,e),kt=r(e),x=o(e,"DIV",{class:!0});var P=u(x);d(se.$$.fragment,P),Ca=r(P),qe=o(P,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1hnunr4"&&(qe.textContent=Hr),Ta=r(P),We=o(P,"P",{"data-svelte-h":!0}),m(We)!=="svelte-1cjb7xo"&&(We.textContent=Er),Da=r(P),ke=o(P,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1347q2l"&&(ke.innerHTML=Sr),za=r(P),je=o(P,"UL",{"data-svelte-h":!0}),m(je)!=="svelte-12x3l9q"&&(je.innerHTML=Gr),Ma=r(P),O=o(P,"DIV",{class:!0});var sa=u(O);d(le.$$.fragment,sa),Pa=r(sa),Ue=o(sa,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1gr03w4"&&(Ue.textContent=Or),sa.forEach(i),P.forEach(i),jt=r(e),L=o(e,"DIV",{class:!0});var R=u(L);d(pe.$$.fragment,R),Na=r(R),Ze=o(R,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1pwmpx3"&&(Ze.innerHTML=Br),Fa=r(R),Qe=o(R,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1i7ubkr"&&(Qe.innerHTML=Vr),Ia=r(R),Xe=o(R,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-96f97i"&&(Xe.innerHTML=qr),Ra=r(R),B=o(R,"DIV",{class:!0});var la=u(B);d(de.$$.fragment,la),Ha=r(la),Je=o(la,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1gr03w4"&&(Je.textContent=Wr),la.forEach(i),R.forEach(i),Ut=r(e),$=o(e,"DIV",{class:!0});var N=u($);d(ce.$$.fragment,N),Ea=r(N),Ke=o(N,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1cuo0rh"&&(Ke.textContent=kr),Sa=r(N),V=o(N,"DIV",{class:!0});var pa=u(V);d(ge.$$.fragment,pa),Ga=r(pa),Ye=o(pa,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1jz1hl7"&&(Ye.textContent=jr),pa.forEach(i),Oa=r(N),q=o(N,"DIV",{class:!0});var da=u(q);d(fe.$$.fragment,da),Ba=r(da),et=o(da,"P",{"data-svelte-h":!0}),m(et)!=="svelte-1y1oyzd"&&(et.textContent=Ur),da.forEach(i),Va=r(N),W=o(N,"DIV",{class:!0});var ca=u(W);d(he.$$.fragment,ca),qa=r(ca),tt=o(ca,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-1gr03w4"&&(tt.textContent=Zr),ca.forEach(i),Wa=r(N),k=o(N,"DIV",{class:!0});var ga=u(k);d(ue.$$.fragment,ga),ka=r(ga),at=o(ga,"P",{"data-svelte-h":!0}),m(at)!=="svelte-4lvf5h"&&(at.textContent=Qr),ga.forEach(i),N.forEach(i),Zt=r(e),ve=o(e,"DIV",{class:!0});var Dn=u(ve);d(be.$$.fragment,Dn),Dn.forEach(i),Qt=r(e),C=o(e,"DIV",{class:!0});var H=u(C);d(_e.$$.fragment,H),ja=r(H),rt=o(H,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-c51pd7"&&(rt.textContent=Xr),Ua=r(H),nt=o(H,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-1cgyzi6"&&(nt.innerHTML=Jr),Za=r(H),ot=o(H,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-1pe3ewc"&&(ot.innerHTML=Kr),Qa=r(H),j=o(H,"DIV",{class:!0});var fa=u(j);d(ye.$$.fragment,fa),Xa=r(fa),it=o(fa,"P",{"data-svelte-h":!0}),m(it)!=="svelte-1gr03w4"&&(it.textContent=Yr),fa.forEach(i),H.forEach(i),Xt=r(e),T=o(e,"DIV",{class:!0});var E=u(T);d(xe.$$.fragment,E),Ja=r(E),mt=o(E,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-d5zqgn"&&(mt.innerHTML=en),Ka=r(E),st=o(E,"P",{"data-svelte-h":!0}),m(st)!=="svelte-1wamkfv"&&(st.innerHTML=tn),Ya=r(E),lt=o(E,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-dty621"&&(lt.innerHTML=an),er=r(E),U=o(E,"DIV",{class:!0});var ha=u(U);d($e.$$.fragment,ha),tr=r(ha),pt=o(ha,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-1gr03w4"&&(pt.textContent=rn),ha.forEach(i),E.forEach(i),Jt=r(e),M=o(e,"DIV",{class:!0});var ee=u(M);d(we.$$.fragment,ee),ar=r(ee),dt=o(ee,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-vzcsb8"&&(dt.textContent=nn),rr=r(ee),ct=o(ee,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-euart9"&&(ct.innerHTML=on),nr=r(ee),Z=o(ee,"DIV",{class:!0});var ua=u(Z);d(Ae.$$.fragment,ua),or=r(ua),gt=o(ua,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-1gr03w4"&&(gt.textContent=mn),ua.forEach(i),ee.forEach(i),Kt=r(e),Le=o(e,"DIV",{class:!0});var zn=u(Le);d(Ce.$$.fragment,zn),zn.forEach(i),Yt=r(e),y=o(e,"DIV",{class:!0});var D=u(y);d(Te.$$.fragment,D),ir=r(D),ft=o(D,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-wmmdpx"&&(ft.textContent=sn),mr=r(D),ht=o(D,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-12dyngi"&&(ht.innerHTML=ln),sr=r(D),ut=o(D,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-qjjdis"&&(ut.textContent=pn),lr=r(D),vt=o(D,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-rosfou"&&(vt.textContent=dn),pr=r(D),bt=o(D,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-hlwvkn"&&(bt.textContent=cn),dr=r(D),Q=o(D,"DIV",{class:!0});var va=u(Q);d(De.$$.fragment,va),cr=r(va),_t=o(va,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1gr03w4"&&(_t.textContent=gn),va.forEach(i),D.forEach(i),ea=r(e),w=o(e,"DIV",{class:!0});var F=u(w);d(ze.$$.fragment,F),gr=r(F),yt=o(F,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1ss2c23"&&(yt.textContent=fn),fr=r(F),xt=o(F,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-ewqetr"&&(xt.innerHTML=hn),hr=r(F),$t=o(F,"P",{"data-svelte-h":!0}),m($t)!=="svelte-1q705lb"&&($t.innerHTML=un),ur=r(F),wt=o(F,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-14ul3re"&&(wt.innerHTML=vn),vr=r(F),X=o(F,"DIV",{class:!0});var ba=u(X);d(Me.$$.fragment,ba),br=r(ba),At=o(ba,"P",{"data-svelte-h":!0}),m(At)!=="svelte-1gr03w4"&&(At.textContent=bn),ba.forEach(i),F.forEach(i),ta=r(e),I=o(e,"DIV",{class:!0});var It=u(I);d(Pe.$$.fragment,It),_r=r(It),Lt=o(It,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-5vv99d"&&(Lt.textContent=_n),yr=r(It),J=o(It,"DIV",{class:!0});var _a=u(J);d(Ne.$$.fragment,_a),xr=r(_a),Ct=o(_a,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-1gr03w4"&&(Ct.textContent=yn),_a.forEach(i),It.forEach(i),aa=r(e),Fe=o(e,"DIV",{class:!0});var Mn=u(Fe);d(Ie.$$.fragment,Mn),Mn.forEach(i),ra=r(e),_=o(e,"DIV",{class:!0});var A=u(_);d(Re.$$.fragment,A),$r=r(A),Tt=o(A,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1tqv0s5"&&(Tt.textContent=xn),wr=r(A),Dt=o(A,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-g10xv4"&&(Dt.textContent=$n),Ar=r(A),zt=o(A,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-1acg3vg"&&(zt.textContent=wn),Lr=r(A),Mt=o(A,"OL",{"data-svelte-h":!0}),m(Mt)!=="svelte-15y6o6y"&&(Mt.innerHTML=An),Cr=r(A),Pt=o(A,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1yvkj2h"&&(Pt.innerHTML=Ln),Tr=r(A),Nt=o(A,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-53x1ow"&&(Nt.innerHTML=Cn),Dr=r(A),K=o(A,"DIV",{class:!0});var ya=u(K);d(He.$$.fragment,ya),zr=r(ya),Ft=o(ya,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1gr03w4"&&(Ft.textContent=Tn),ya.forEach(i),A.forEach(i),na=r(e),Ee=o(e,"DIV",{class:!0});var Pn=u(Ee);d(Se.$$.fragment,Pn),Pn.forEach(i),oa=r(e),Ht=o(e,"P",{}),u(Ht).forEach(i),this.h()},h(){v(S,"name","hf:doc:metadata"),v(S,"content",Gn),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,S),l(e,Et,s),l(e,Rt,s),l(e,St,s),c(te,e,s),l(e,Gt,s),l(e,ae,s),l(e,Ot,s),c(re,e,s),l(e,Bt,s),c(ne,e,s),l(e,Vt,s),l(e,G,s),c(oe,G,null),t(G,$a),t(G,Ge),l(e,qt,s),l(e,z,s),c(ie,z,null),t(z,wa),t(z,Oe),t(z,Aa),t(z,Be),t(z,La),t(z,Ve),l(e,Wt,s),c(me,e,s),l(e,kt,s),l(e,x,s),c(se,x,null),t(x,Ca),t(x,qe),t(x,Ta),t(x,We),t(x,Da),t(x,ke),t(x,za),t(x,je),t(x,Ma),t(x,O),c(le,O,null),t(O,Pa),t(O,Ue),l(e,jt,s),l(e,L,s),c(pe,L,null),t(L,Na),t(L,Ze),t(L,Fa),t(L,Qe),t(L,Ia),t(L,Xe),t(L,Ra),t(L,B),c(de,B,null),t(B,Ha),t(B,Je),l(e,Ut,s),l(e,$,s),c(ce,$,null),t($,Ea),t($,Ke),t($,Sa),t($,V),c(ge,V,null),t(V,Ga),t(V,Ye),t($,Oa),t($,q),c(fe,q,null),t(q,Ba),t(q,et),t($,Va),t($,W),c(he,W,null),t(W,qa),t(W,tt),t($,Wa),t($,k),c(ue,k,null),t(k,ka),t(k,at),l(e,Zt,s),l(e,ve,s),c(be,ve,null),l(e,Qt,s),l(e,C,s),c(_e,C,null),t(C,ja),t(C,rt),t(C,Ua),t(C,nt),t(C,Za),t(C,ot),t(C,Qa),t(C,j),c(ye,j,null),t(j,Xa),t(j,it),l(e,Xt,s),l(e,T,s),c(xe,T,null),t(T,Ja),t(T,mt),t(T,Ka),t(T,st),t(T,Ya),t(T,lt),t(T,er),t(T,U),c($e,U,null),t(U,tr),t(U,pt),l(e,Jt,s),l(e,M,s),c(we,M,null),t(M,ar),t(M,dt),t(M,rr),t(M,ct),t(M,nr),t(M,Z),c(Ae,Z,null),t(Z,or),t(Z,gt),l(e,Kt,s),l(e,Le,s),c(Ce,Le,null),l(e,Yt,s),l(e,y,s),c(Te,y,null),t(y,ir),t(y,ft),t(y,mr),t(y,ht),t(y,sr),t(y,ut),t(y,lr),t(y,vt),t(y,pr),t(y,bt),t(y,dr),t(y,Q),c(De,Q,null),t(Q,cr),t(Q,_t),l(e,ea,s),l(e,w,s),c(ze,w,null),t(w,gr),t(w,yt),t(w,fr),t(w,xt),t(w,hr),t(w,$t),t(w,ur),t(w,wt),t(w,vr),t(w,X),c(Me,X,null),t(X,br),t(X,At),l(e,ta,s),l(e,I,s),c(Pe,I,null),t(I,_r),t(I,Lt),t(I,yr),t(I,J),c(Ne,J,null),t(J,xr),t(J,Ct),l(e,aa,s),l(e,Fe,s),c(Ie,Fe,null),l(e,ra,s),l(e,_,s),c(Re,_,null),t(_,$r),t(_,Tt),t(_,wr),t(_,Dt),t(_,Ar),t(_,zt),t(_,Lr),t(_,Mt),t(_,Cr),t(_,Pt),t(_,Tr),t(_,Nt),t(_,Dr),t(_,K),c(He,K,null),t(K,zr),t(K,Ft),l(e,na,s),l(e,Ee,s),c(Se,Ee,null),l(e,oa,s),l(e,Ht,s),ia=!0},p:Fn,i(e){ia||(g(te.$$.fragment,e),g(re.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(ie.$$.fragment,e),g(me.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(be.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(we.$$.fragment,e),g(Ae.$$.fragment,e),g(Ce.$$.fragment,e),g(Te.$$.fragment,e),g(De.$$.fragment,e),g(ze.$$.fragment,e),g(Me.$$.fragment,e),g(Pe.$$.fragment,e),g(Ne.$$.fragment,e),g(Ie.$$.fragment,e),g(Re.$$.fragment,e),g(He.$$.fragment,e),g(Se.$$.fragment,e),ia=!0)},o(e){f(te.$$.fragment,e),f(re.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(ie.$$.fragment,e),f(me.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(be.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Ae.$$.fragment,e),f(Ce.$$.fragment,e),f(Te.$$.fragment,e),f(De.$$.fragment,e),f(ze.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ie.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Se.$$.fragment,e),ia=!1},d(e){e&&(i(Et),i(Rt),i(St),i(Gt),i(ae),i(Ot),i(Bt),i(Vt),i(G),i(qt),i(z),i(Wt),i(kt),i(x),i(jt),i(L),i(Ut),i($),i(Zt),i(ve),i(Qt),i(C),i(Xt),i(T),i(Jt),i(M),i(Kt),i(Le),i(Yt),i(y),i(ea),i(w),i(ta),i(I),i(aa),i(Fe),i(ra),i(_),i(na),i(Ee),i(oa),i(Ht)),i(S),h(te,e),h(re,e),h(ne,e),h(oe),h(ie),h(me,e),h(se),h(le),h(pe),h(de),h(ce),h(ge),h(fe),h(he),h(ue),h(be),h(_e),h(ye),h(xe),h($e),h(we),h(Ae),h(Ce),h(Te),h(De),h(ze),h(Me),h(Pe),h(Ne),h(Ie),h(Re),h(He),h(Se)}}}const Gn='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer","sections":[],"depth":3},{"title":"Optimizer Classes","local":"timm.optim.AdaBelief","sections":[],"depth":3}],"depth":2}],"depth":1}';function On(Mr){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kn extends Rn{constructor(S){super(),Hn(this,S,On,Sn,Nn,{})}}export{kn as component};
