import{s as Lt,n as Pt,o as qt}from"../chunks/scheduler.85c25b89.js";import{S as Kt,i as Ot,g as p,s as l,r,m as z,H as ts,A as ss,h as i,f as a,c as n,j as At,u as c,n as H,x as o,B as as,k as F,y as h,a as e,v as y,d as j,t as g,w as J}from"../chunks/index.c9837788.js";import{C as D}from"../chunks/CodeBlock.52fa569e.js";import{H as q}from"../chunks/Heading.3097d2ed.js";function es(Zt){let d,K,L,O,U,tt,m,xt,V,Bt="ResNeXt",It,w,$t="building block",Nt,T,Wt="ResNet",vt,S,Gt="cardinality",kt,st,Dt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>C</mi></mrow><annotation encoding="application/x-tex"> C </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">C</span></span></span></span>',at,et,u,Rt="The models in this collection utilise semi-weakly supervised learning to improve the performance of the model. The approach brings important gains to standard architectures for image, video and fine-grained classification.",lt,b,Et="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",nt,f,pt,C,Qt="To load a pretrained model:",it,x,mt,I,_t="To load and preprocess the image:",ot,N,Mt,v,Yt="To get the model predictions:",rt,k,ct,A,Xt="To get the top-5 predictions class names:",ht,Z,yt,B,Vt="Replace the model name with the variant you want to use, e.g. <code>swsl_resnext101_32x16d</code>. You can find the IDs in the model summaries at the top of this page.",jt,$,St='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',gt,W,Jt,G,zt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",dt,R,wt,E,Ht=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Tt,Q,Ut,_,Ft='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ut,Y,bt,X,ft,P,Ct;return U=new q({props:{title:"SWSL ResNeXt",local:"swsl-resnext",headingTag:"h1"}}),f=new q({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),x=new D({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3N3c2xfcmVzbmV4dDEwMV8zMngxNmQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnext101_32x16d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),N=new D({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),k=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new D({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new q({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),R=new D({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3dzbF9yZXNuZXh0MTAxXzMyeDE2ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnext101_32x16d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),Q=new q({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Y=new q({props:{title:"Citation",local:"citation",headingTag:"h2"}}),X=new D({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNS0wMDU0NiUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkkuJTIwWmVraSUyMFlhbG5peiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEhlcnYlN0IlNUMnJTdCZSU3RCU3RCUyMEolN0IlNUMnJTdCZSU3RCU3RGdvdSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEthbiUyMENoZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNYW5vaGFyJTIwUGFsdXJpJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGhydXYlMjBNYWhhamFuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JCaWxsaW9uLXNjYWxlJTIwc2VtaS1zdXBlcnZpc2VkJTIwbGVhcm5pbmclMjBmb3IlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA1LjAwNTQ2JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNS4wMDU0NiU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDUuMDA1NDYlN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAyOCUyMFNlcCUyMDIwMjAlMjAwOCUzQTE5JTNBMzclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA1LTAwNTQ2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/abs-1905-00546,
  author    = {I. Zeki Yalniz and
               Herv{\\&#x27;{e}</span><span class="language-xml">} J</span><span class="hljs-template-variable">{\\&#x27;{e}</span><span class="language-xml">}gou and
               Kan Chen and
               Manohar Paluri and
               Dhruv Mahajan},
  title     = </span><span class="hljs-template-variable">{Billion-scale semi-supervised learning for image classification}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1905.00546}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1905.00546}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1905.00546}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 28 <span class="hljs-keyword">Sep</span> 2020 08:19:37 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/abs-1905-00546.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){d=p("meta"),K=l(),L=p("p"),O=l(),r(U.$$.fragment),tt=l(),m=p("p"),xt=z("A "),V=p("strong"),V.textContent=Bt,It=z(" repeats a "),w=p("a"),w.textContent=$t,Nt=z(" that aggregates a set of transformations with the same topology. Compared to a "),T=p("a"),T.textContent=Wt,vt=z(", it exposes a new dimension,  "),S=p("em"),S.textContent=Gt,kt=z(" (the size of the set of transformations)"),st=new ts(!1),at=z(", as an essential factor in addition to the dimensions of depth and width."),et=l(),u=p("p"),u.textContent=Rt,lt=l(),b=p("p"),b.textContent=Et,nt=l(),r(f.$$.fragment),pt=l(),C=p("p"),C.textContent=Qt,it=l(),r(x.$$.fragment),mt=l(),I=p("p"),I.textContent=_t,ot=l(),r(N.$$.fragment),Mt=l(),v=p("p"),v.textContent=Yt,rt=l(),r(k.$$.fragment),ct=l(),A=p("p"),A.textContent=Xt,ht=l(),r(Z.$$.fragment),yt=l(),B=p("p"),B.innerHTML=Vt,jt=l(),$=p("p"),$.innerHTML=St,gt=l(),r(W.$$.fragment),Jt=l(),G=p("p"),G.textContent=zt,dt=l(),r(R.$$.fragment),wt=l(),E=p("p"),E.innerHTML=Ht,Tt=l(),r(Q.$$.fragment),Ut=l(),_=p("p"),_.innerHTML=Ft,ut=l(),r(Y.$$.fragment),bt=l(),r(X.$$.fragment),ft=l(),P=p("p"),this.h()},l(t){const s=ss("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(a),K=n(t),L=i(t,"P",{}),At(L).forEach(a),O=n(t),c(U.$$.fragment,t),tt=n(t),m=i(t,"P",{});var M=At(m);xt=H(M,"A "),V=i(M,"STRONG",{"data-svelte-h":!0}),o(V)!=="svelte-ixiuf7"&&(V.textContent=Bt),It=H(M," repeats a "),w=i(M,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(w)!=="svelte-60xv13"&&(w.textContent=$t),Nt=H(M," that aggregates a set of transformations with the same topology. Compared to a "),T=i(M,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(T)!=="svelte-1fowv03"&&(T.textContent=Wt),vt=H(M,", it exposes a new dimension,  "),S=i(M,"EM",{"data-svelte-h":!0}),o(S)!=="svelte-47b3di"&&(S.textContent=Gt),kt=H(M," (the size of the set of transformations)"),st=as(M,!1),at=H(M,", as an essential factor in addition to the dimensions of depth and width."),M.forEach(a),et=n(t),u=i(t,"P",{"data-svelte-h":!0}),o(u)!=="svelte-1tlji93"&&(u.textContent=Rt),lt=n(t),b=i(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-ye38bd"&&(b.textContent=Et),nt=n(t),c(f.$$.fragment,t),pt=n(t),C=i(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-18ywhxh"&&(C.textContent=Qt),it=n(t),c(x.$$.fragment,t),mt=n(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1c2ipa8"&&(I.textContent=_t),ot=n(t),c(N.$$.fragment,t),Mt=n(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1n9qsq1"&&(v.textContent=Yt),rt=n(t),c(k.$$.fragment,t),ct=n(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-19cnvx1"&&(A.textContent=Xt),ht=n(t),c(Z.$$.fragment,t),yt=n(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-q7859c"&&(B.innerHTML=Vt),jt=n(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1wmi3ea"&&($.innerHTML=St),gt=n(t),c(W.$$.fragment,t),Jt=n(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-9sr7nh"&&(G.textContent=zt),dt=n(t),c(R.$$.fragment,t),wt=n(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1kguc51"&&(E.innerHTML=Ht),Tt=n(t),c(Q.$$.fragment,t),Ut=n(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1n0coha"&&(_.innerHTML=Ft),ut=n(t),c(Y.$$.fragment,t),bt=n(t),c(X.$$.fragment,t),ft=n(t),P=i(t,"P",{}),At(P).forEach(a),this.h()},h(){F(d,"name","hf:doc:metadata"),F(d,"content",ls),F(w,"href","https://paperswithcode.com/method/resnext-block"),F(w,"rel","nofollow"),F(T,"href","https://paperswithcode.com/method/resnet"),F(T,"rel","nofollow"),st.a=at},m(t,s){h(document.head,d),e(t,K,s),e(t,L,s),e(t,O,s),y(U,t,s),e(t,tt,s),e(t,m,s),h(m,xt),h(m,V),h(m,It),h(m,w),h(m,Nt),h(m,T),h(m,vt),h(m,S),h(m,kt),st.m(Dt,m),h(m,at),e(t,et,s),e(t,u,s),e(t,lt,s),e(t,b,s),e(t,nt,s),y(f,t,s),e(t,pt,s),e(t,C,s),e(t,it,s),y(x,t,s),e(t,mt,s),e(t,I,s),e(t,ot,s),y(N,t,s),e(t,Mt,s),e(t,v,s),e(t,rt,s),y(k,t,s),e(t,ct,s),e(t,A,s),e(t,ht,s),y(Z,t,s),e(t,yt,s),e(t,B,s),e(t,jt,s),e(t,$,s),e(t,gt,s),y(W,t,s),e(t,Jt,s),e(t,G,s),e(t,dt,s),y(R,t,s),e(t,wt,s),e(t,E,s),e(t,Tt,s),y(Q,t,s),e(t,Ut,s),e(t,_,s),e(t,ut,s),y(Y,t,s),e(t,bt,s),y(X,t,s),e(t,ft,s),e(t,P,s),Ct=!0},p:Pt,i(t){Ct||(j(U.$$.fragment,t),j(f.$$.fragment,t),j(x.$$.fragment,t),j(N.$$.fragment,t),j(k.$$.fragment,t),j(Z.$$.fragment,t),j(W.$$.fragment,t),j(R.$$.fragment,t),j(Q.$$.fragment,t),j(Y.$$.fragment,t),j(X.$$.fragment,t),Ct=!0)},o(t){g(U.$$.fragment,t),g(f.$$.fragment,t),g(x.$$.fragment,t),g(N.$$.fragment,t),g(k.$$.fragment,t),g(Z.$$.fragment,t),g(W.$$.fragment,t),g(R.$$.fragment,t),g(Q.$$.fragment,t),g(Y.$$.fragment,t),g(X.$$.fragment,t),Ct=!1},d(t){t&&(a(K),a(L),a(O),a(tt),a(m),a(et),a(u),a(lt),a(b),a(nt),a(pt),a(C),a(it),a(mt),a(I),a(ot),a(Mt),a(v),a(rt),a(ct),a(A),a(ht),a(yt),a(B),a(jt),a($),a(gt),a(Jt),a(G),a(dt),a(wt),a(E),a(Tt),a(Ut),a(_),a(ut),a(bt),a(ft),a(P)),a(d),J(U,t),J(f,t),J(x,t),J(N,t),J(k,t),J(Z,t),J(W,t),J(R,t),J(Q,t),J(Y,t),J(X,t)}}}const ls='{"title":"SWSL ResNeXt","local":"swsl-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function ns(Zt){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends Kt{constructor(d){super(),Ot(this,d,ns,es,Lt,{})}}export{Ms as component};
