import{s as be,n as Te,o as ve}from"../chunks/scheduler.85c25b89.js";import{S as ke,i as xe,g as l,s as i,u as c,A as $e,h as n,f as e,c as o,j as m,v as d,y as h,k as p,o as r,a,w as u,d as f,t as g,x as M}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as at}from"../chunks/CodeBlock.00597c71.js";function Ie(Pt){let w,ct,lt,dt,j,v,nt,U,St,K,Lt="EfficientNet",ut,C,qt="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",ft,N,Dt="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",gt,E,Kt='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a>.',Mt,y,k,it,Z,zt,O,Ot="How do I use this model on an image?",wt,_,te="To load a pretrained model:",jt,B,yt,W,ee="To load and preprocess the image:",Jt,G,bt,A,se="To get the model predictions:",Tt,Q,vt,V,ae="To get the top-5 predictions class names:",kt,R,xt,X,le="Replace the model name with the variant you want to use, e.g. <code>efficientnet_b0</code>. You can find the IDs in the model summaries at the top of this page.",$t,S,ne='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',It,J,x,ot,z,Yt,tt,ie="How do I finetune this model?",Ut,Y,oe="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,H,Nt,F,pe=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Et,b,$,pt,P,Ht,et,re="How do I train this model?",Zt,L,me='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',_t,T,I,rt,q,Ft,st,he="Citation",Bt,D,Wt,mt,Gt;return U=new ht({}),Z=new ht({}),B=new at({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VmZmljaWVudG5ldF9iMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),G=new at({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),Q=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),R=new at({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),z=new ht({}),H=new at({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWZmaWNpZW50bmV0X2IwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),P=new ht({}),q=new ht({}),D=new at({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`}}),{c(){w=l("meta"),ct=i(),lt=l("p"),dt=i(),j=l("h1"),v=l("a"),nt=l("span"),c(U.$$.fragment),St=i(),K=l("span"),K.textContent=Lt,ut=i(),C=l("p"),C.innerHTML=qt,ft=i(),N=l("p"),N.textContent=Dt,gt=i(),E=l("p"),E.innerHTML=Kt,Mt=i(),y=l("h2"),k=l("a"),it=l("span"),c(Z.$$.fragment),zt=i(),O=l("span"),O.textContent=Ot,wt=i(),_=l("p"),_.textContent=te,jt=i(),c(B.$$.fragment),yt=i(),W=l("p"),W.textContent=ee,Jt=i(),c(G.$$.fragment),bt=i(),A=l("p"),A.textContent=se,Tt=i(),c(Q.$$.fragment),vt=i(),V=l("p"),V.textContent=ae,kt=i(),c(R.$$.fragment),xt=i(),X=l("p"),X.innerHTML=le,$t=i(),S=l("p"),S.innerHTML=ne,It=i(),J=l("h2"),x=l("a"),ot=l("span"),c(z.$$.fragment),Yt=i(),tt=l("span"),tt.textContent=ie,Ut=i(),Y=l("p"),Y.textContent=oe,Ct=i(),c(H.$$.fragment),Nt=i(),F=l("p"),F.innerHTML=pe,Et=i(),b=l("h2"),$=l("a"),pt=l("span"),c(P.$$.fragment),Ht=i(),et=l("span"),et.textContent=re,Zt=i(),L=l("p"),L.innerHTML=me,_t=i(),T=l("h2"),I=l("a"),rt=l("span"),c(q.$$.fragment),Ft=i(),st=l("span"),st.textContent=he,Bt=i(),c(D.$$.fragment),Wt=i(),mt=l("p"),this.h()},l(t){const s=$e("svelte-1phssyn",document.head);w=n(s,"META",{name:!0,content:!0}),s.forEach(e),ct=o(t),lt=n(t,"P",{}),m(lt).forEach(e),dt=o(t),j=n(t,"H1",{class:!0});var At=m(j);v=n(At,"A",{id:!0,class:!0,href:!0});var ce=m(v);nt=n(ce,"SPAN",{});var de=m(nt);d(U.$$.fragment,de),de.forEach(e),ce.forEach(e),St=o(At),K=n(At,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-100w5rr"&&(K.textContent=Lt),At.forEach(e),ut=o(t),C=n(t,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1bwkfja"&&(C.innerHTML=qt),ft=o(t),N=n(t,"P",{"data-svelte-h":!0}),h(N)!=="svelte-5z334a"&&(N.textContent=Dt),gt=o(t),E=n(t,"P",{"data-svelte-h":!0}),h(E)!=="svelte-1j8z7ka"&&(E.innerHTML=Kt),Mt=o(t),y=n(t,"H2",{class:!0});var Qt=m(y);k=n(Qt,"A",{id:!0,class:!0,href:!0});var ue=m(k);it=n(ue,"SPAN",{});var fe=m(it);d(Z.$$.fragment,fe),fe.forEach(e),ue.forEach(e),zt=o(Qt),O=n(Qt,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-1c1hspn"&&(O.textContent=Ot),Qt.forEach(e),wt=o(t),_=n(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-18ywhxh"&&(_.textContent=te),jt=o(t),d(B.$$.fragment,t),yt=o(t),W=n(t,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1c2ipa8"&&(W.textContent=ee),Jt=o(t),d(G.$$.fragment,t),bt=o(t),A=n(t,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1n9qsq1"&&(A.textContent=se),Tt=o(t),d(Q.$$.fragment,t),vt=o(t),V=n(t,"P",{"data-svelte-h":!0}),h(V)!=="svelte-19cnvx1"&&(V.textContent=ae),kt=o(t),d(R.$$.fragment,t),xt=o(t),X=n(t,"P",{"data-svelte-h":!0}),h(X)!=="svelte-1vzaktz"&&(X.innerHTML=le),$t=o(t),S=n(t,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1wmi3ea"&&(S.innerHTML=ne),It=o(t),J=n(t,"H2",{class:!0});var Vt=m(J);x=n(Vt,"A",{id:!0,class:!0,href:!0});var ge=m(x);ot=n(ge,"SPAN",{});var Me=m(ot);d(z.$$.fragment,Me),Me.forEach(e),ge.forEach(e),Yt=o(Vt),tt=n(Vt,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-1viv4qv"&&(tt.textContent=ie),Vt.forEach(e),Ut=o(t),Y=n(t,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-9sr7nh"&&(Y.textContent=oe),Ct=o(t),d(H.$$.fragment,t),Nt=o(t),F=n(t,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1kguc51"&&(F.innerHTML=pe),Et=o(t),b=n(t,"H2",{class:!0});var Rt=m(b);$=n(Rt,"A",{id:!0,class:!0,href:!0});var we=m($);pt=n(we,"SPAN",{});var je=m(pt);d(P.$$.fragment,je),je.forEach(e),we.forEach(e),Ht=o(Rt),et=n(Rt,"SPAN",{"data-svelte-h":!0}),h(et)!=="svelte-1ce591d"&&(et.textContent=re),Rt.forEach(e),Zt=o(t),L=n(t,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1n0coha"&&(L.innerHTML=me),_t=o(t),T=n(t,"H2",{class:!0});var Xt=m(T);I=n(Xt,"A",{id:!0,class:!0,href:!0});var ye=m(I);rt=n(ye,"SPAN",{});var Je=m(rt);d(q.$$.fragment,Je),Je.forEach(e),ye.forEach(e),Ft=o(Xt),st=n(Xt,"SPAN",{"data-svelte-h":!0}),h(st)!=="svelte-15mb3gy"&&(st.textContent=he),Xt.forEach(e),Bt=o(t),d(D.$$.fragment,t),Wt=o(t),mt=n(t,"P",{}),m(mt).forEach(e),this.h()},h(){p(w,"name","hf:doc:metadata"),p(w,"content",JSON.stringify(Ue)),p(v,"id","efficientnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#efficientnet"),p(j,"class","relative group"),p(k,"id","how-do-i-use-this-model-on-an-image"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#how-do-i-use-this-model-on-an-image"),p(y,"class","relative group"),p(x,"id","how-do-i-finetune-this-model"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#how-do-i-finetune-this-model"),p(J,"class","relative group"),p($,"id","how-do-i-train-this-model"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#how-do-i-train-this-model"),p(b,"class","relative group"),p(I,"id","citation"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#citation"),p(T,"class","relative group")},m(t,s){r(document.head,w),a(t,ct,s),a(t,lt,s),a(t,dt,s),a(t,j,s),r(j,v),r(v,nt),u(U,nt,null),r(j,St),r(j,K),a(t,ut,s),a(t,C,s),a(t,ft,s),a(t,N,s),a(t,gt,s),a(t,E,s),a(t,Mt,s),a(t,y,s),r(y,k),r(k,it),u(Z,it,null),r(y,zt),r(y,O),a(t,wt,s),a(t,_,s),a(t,jt,s),u(B,t,s),a(t,yt,s),a(t,W,s),a(t,Jt,s),u(G,t,s),a(t,bt,s),a(t,A,s),a(t,Tt,s),u(Q,t,s),a(t,vt,s),a(t,V,s),a(t,kt,s),u(R,t,s),a(t,xt,s),a(t,X,s),a(t,$t,s),a(t,S,s),a(t,It,s),a(t,J,s),r(J,x),r(x,ot),u(z,ot,null),r(J,Yt),r(J,tt),a(t,Ut,s),a(t,Y,s),a(t,Ct,s),u(H,t,s),a(t,Nt,s),a(t,F,s),a(t,Et,s),a(t,b,s),r(b,$),r($,pt),u(P,pt,null),r(b,Ht),r(b,et),a(t,Zt,s),a(t,L,s),a(t,_t,s),a(t,T,s),r(T,I),r(I,rt),u(q,rt,null),r(T,Ft),r(T,st),a(t,Bt,s),u(D,t,s),a(t,Wt,s),a(t,mt,s),Gt=!0},p:Te,i(t){Gt||(f(U.$$.fragment,t),f(Z.$$.fragment,t),f(B.$$.fragment,t),f(G.$$.fragment,t),f(Q.$$.fragment,t),f(R.$$.fragment,t),f(z.$$.fragment,t),f(H.$$.fragment,t),f(P.$$.fragment,t),f(q.$$.fragment,t),f(D.$$.fragment,t),Gt=!0)},o(t){g(U.$$.fragment,t),g(Z.$$.fragment,t),g(B.$$.fragment,t),g(G.$$.fragment,t),g(Q.$$.fragment,t),g(R.$$.fragment,t),g(z.$$.fragment,t),g(H.$$.fragment,t),g(P.$$.fragment,t),g(q.$$.fragment,t),g(D.$$.fragment,t),Gt=!1},d(t){t&&(e(ct),e(lt),e(dt),e(j),e(ut),e(C),e(ft),e(N),e(gt),e(E),e(Mt),e(y),e(wt),e(_),e(jt),e(yt),e(W),e(Jt),e(bt),e(A),e(Tt),e(vt),e(V),e(kt),e(xt),e(X),e($t),e(S),e(It),e(J),e(Ut),e(Y),e(Ct),e(Nt),e(F),e(Et),e(b),e(Zt),e(L),e(_t),e(T),e(Bt),e(Wt),e(mt)),e(w),M(U),M(Z),M(B,t),M(G,t),M(Q,t),M(R,t),M(z),M(H,t),M(P),M(q),M(D,t)}}}const Ue={local:"efficientnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"EfficientNet"};function Ce(Pt){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends ke{constructor(w){super(),xe(this,w,Ce,Ie,be,{})}}export{Be as component};
