import{s as ua,o as ga,n as Zt}from"../chunks/scheduler.6062bdaf.js";import{S as ma,i as wa,g as o,s as l,r as h,A as ba,h as i,f as a,c as s,j as pa,u as f,x as d,k as ca,y as _a,a as n,v as p,d as c,t as u,w as g}from"../chunks/index.4bca734e.js";import{T as Lt}from"../chunks/Tip.b9ac1f03.js";import{C as $}from"../chunks/CodeBlock.cbbddafc.js";import{H as b,E as $a}from"../chunks/getInferenceSnippets.ead76dbf.js";function ya(y){let r,w=`The returned filepath is a pointer to the HF local cache. Therefore, it is important to not modify the file to avoid
having a corrupted cache. If you are interested in getting to know more about how files are cached, please refer to our
<a href="./manage-cache">caching guide</a>.`;return{c(){r=o("p"),r.innerHTML=w},l(m){r=i(m,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1jtqj65"&&(r.innerHTML=w)},m(m,_){n(m,r,_)},p:Zt,d(m){m&&a(r)}}}function Ma(y){let r,w='Don’t worry about the <code>.cache/huggingface/</code> folder when committing changes to the Hub! This folder is automatically ignored by both <code>git</code> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>.';return{c(){r=o("p"),r.innerHTML=w},l(m){r=i(m,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1vi59oc"&&(r.innerHTML=w)},m(m,_){n(m,r,_)},p:Zt,d(m){m&&a(r)}}}function va(y){let r,w=`<code>hf_transfer</code> is a power user tool!
It is tested and production-ready,
but it lacks user-friendly features like advanced error handling or proxies.
For more details, please take a look at this <a href="https://huggingface.co/docs/huggingface_hub/hf_transfer" rel="nofollow">section</a>.`;return{c(){r=o("p"),r.innerHTML=w},l(m){r=i(m,"P",{"data-svelte-h":!0}),d(r)!=="svelte-ac3n7l"&&(r.innerHTML=w)},m(m,_){n(m,r,_)},p:Zt,d(m){m&&a(r)}}}function Ta(y){let r,w,m,_,j,xe,x,qt=`The <code>huggingface_hub</code> library provides functions to download files from the repositories
stored on the Hub. You can use these functions independently or integrate them into your
own library, making it more convenient for your users to interact with the Hub. This
guide will show you how to:`,He,H,Ct="<li>Download and cache a single file.</li> <li>Download and cache an entire repository.</li> <li>Download files to a local folder.</li>",Je,J,ke,k,Ut=`The <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> function is the main function for downloading files from the Hub.
It downloads the remote file, caches it on disk (in a version-aware way), and returns its local file path.`,Le,M,Ze,L,qe,Z,Gt=`Select the file to download using the <code>repo_id</code>, <code>repo_type</code> and <code>filename</code> parameters. By default, the file will
be considered as being part of a <code>model</code> repo.`,Ce,q,Ue,C,Ge,U,It=`By default, the latest version from the <code>main</code> branch is downloaded. However, in some cases you want to download a file
at a particular version (e.g. from a specific branch, a PR, a tag or a commit hash).
To do so, use the <code>revision</code> parameter:`,Ie,G,Ye,I,Yt="<strong>Note:</strong> When using the commit hash, it must be the full-length hash instead of a 7-character commit hash.",Xe,Y,Re,X,Xt=`In case you want to construct the URL used to download a file from a repo, you can use <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a> which returns a URL.
Note that it is used internally by <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a>.`,Be,R,Ne,B,Rt=`<a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads an entire repository at a given revision. It uses internally <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> which
means all downloaded files are also cached on your local disk. Downloads are made concurrently to speed-up the process.`,We,N,Bt="To download a whole repository, just pass the <code>repo_id</code> and <code>repo_type</code>:",Pe,W,ze,P,Nt=`<a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads the latest revision by default. If you want a specific repository revision, use the
<code>revision</code> parameter:`,Fe,z,Qe,F,Se,Q,Wt=`<a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> provides an easy way to download a repository. However, you don’t always want to download the
entire content of a repository. For example, you might want to prevent downloading all <code>.bin</code> files if you know you’ll
only use the <code>.safetensors</code> weights. You can do that using <code>allow_patterns</code> and <code>ignore_patterns</code> parameters.`,De,S,Pt=`These parameters accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing
patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. The pattern matching is
based on <a href="https://docs.python.org/3/library/fnmatch.html" rel="nofollow"><code>fnmatch</code></a>.`,Ve,D,zt="For example, you can use <code>allow_patterns</code> to only download JSON configuration files:",Ee,V,Ae,E,Ft=`On the other hand, <code>ignore_patterns</code> can exclude certain files from being downloaded. The
following example ignores the <code>.msgpack</code> and <code>.h5</code> file extensions:`,Ke,A,Oe,K,Qt=`Finally, you can combine both to precisely filter your download. Here is an example to download all json and markdown
files except <code>vocab.json</code>.`,et,O,tt,ee,at,te,St='By default, we recommend using the <a href="./manage-cache">cache system</a> to download files from the Hub. You can specify a custom cache location using the <code>cache_dir</code> parameter in <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a>, or by setting the <a href="../package_reference/environment_variables#hf_home"><code>HF_HOME</code></a> environment variable.',nt,ae,Dt="However, if you need to download files to a specific folder, you can pass a <code>local_dir</code> parameter to the download function. This is useful to get a workflow closer to what the <code>git</code> command offers. The downloaded files will maintain their original file structure within the specified folder. For example, if <code>filename=&quot;data/train.csv&quot;</code> and <code>local_dir=&quot;path/to/folder&quot;</code>, the resulting filepath will be <code>&quot;path/to/folder/data/train.csv&quot;</code>.",lt,ne,Vt="A <code>.cache/huggingface/</code> folder is created at the root of your local directory containing metadata about the downloaded files. This prevents re-downloading files if they’re already up-to-date. If the metadata has changed, then the new file version is downloaded. This makes the <code>local_dir</code> optimized for pulling only the latest changes.",st,le,Et="After completing the download, you can safely remove the <code>.cache/huggingface/</code> folder if you no longer need it. However, be aware that re-running your script without this folder may result in longer recovery times, as metadata will be lost. Rest assured that your local data will remain intact and unaffected.",ot,v,it,se,dt,oe,At=`You can use the <code>huggingface-cli download</code> command from the terminal to directly download files from the Hub.
Internally, it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described above and prints the
returned path to the terminal.`,rt,ie,ht,de,Kt=`You can download multiple files at once which displays a progress bar and returns the snapshot path in which the files
are located:`,ft,re,pt,he,Ot='For more details about the CLI download command, please refer to the <a href="./cli#huggingface-cli-download">CLI guide</a>.',ct,fe,ut,pe,ea="There are two options to speed up downloads. Both involve installing a Python package written in Rust.",gt,ce,ta='<li><code>hf_xet</code> is newer and uses the Xet storage backend for upload/download. It is available in production, but is in the process of being rolled out to all users, so join the <a href="https://huggingface.co/join/xet" rel="nofollow">waitlist</a> to get onboarded soon!</li> <li><code>hf_transfer</code> is a power-tool to download and upload to our LFS storage backend (note: this is less future-proof than Xet). It is thoroughly tested and has been in production for a long time, but it has some limitations.</li>',mt,ue,wt,ge,aa=`Take advantage of faster downloads through <code>hf_xet</code>, the Python binding to the <a href="https://github.com/huggingface/xet-core" rel="nofollow"><code>xet-core</code></a> library that enables
chunk-based deduplication for faster downloads and uploads. <code>hf_xet</code> integrates seamlessly with <code>huggingface_hub</code>, but uses the Rust <code>xet-core</code> library and Xet storage instead of LFS.`,bt,me,na='<code>hf_xet</code> uses the Xet storage system, which breaks files down into immutable chunks, storing collections of these chunks (called blocks or xorbs) remotely and retrieving them to reassemble the file when requested. When downloading, after confirming the user is authorized to access the files, <code>hf_xet</code> will query the Xet content-addressable service (CAS) with the LFS SHA256 hash for this file to receive the reconstruction metadata (ranges within xorbs) to assemble these files, along with presigned URLs to download the xorbs directly. Then <code>hf_xet</code> will efficiently download the xorb ranges necessary and will write out the files on disk. <code>hf_xet</code> uses a local disk cache to only download chunks once, learn more in the <a href="./manage-cache#chunk-based-caching-xet">Chunk-based caching(Xet)</a> section.',_t,we,la="To enable it, specify the <code>hf_xet</code> package when installing <code>huggingface_hub</code>:",$t,be,yt,_e,sa="Note: <code>hf_xet</code> will only be utilized when the files being downloaded are being stored with Xet Storage.",Mt,$e,oa='All other <code>huggingface_hub</code> APIs will continue to work without any modification. To learn more about the benefits of Xet storage and <code>hf_xet</code>, refer to this <a href="https://huggingface.co/docs/hub/storage-backends" rel="nofollow">section</a>.',vt,ye,Tt,Me,ia=`If you are running on a machine with high bandwidth,
you can increase your download speed with <a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a>,
a Rust-based library developed to speed up file transfers with the Hub.
To enable it:`,jt,ve,da=`<li>Specify the <code>hf_transfer</code> extra when installing <code>huggingface_hub</code>
(e.g. <code>pip install huggingface_hub[hf_transfer]</code>).</li> <li>Set <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable.</li>`,xt,T,Ht,Te,Jt,je,kt;return j=new b({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h1"}}),J=new b({props:{title:"Download a single file",local:"download-a-single-file",headingTag:"h2"}}),M=new Lt({props:{$$slots:{default:[ya]},$$scope:{ctx:y}}}),L=new b({props:{title:"From latest version",local:"from-latest-version",headingTag:"h3"}}),q=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIyZ29vZ2xlJTJGZmxldXJzJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJmbGV1cnMucHklMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>

<span class="hljs-comment"># Download from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, filename=<span class="hljs-string">&quot;fleurs.py&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34/fleurs.py&#x27;</span>`,wrap:!1}}),C=new b({props:{title:"From specific version",local:"from-specific-version",headingTag:"h3"}}),G=new $({props:{code:"aGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnYxLjAlMjIpJTBBJTBBaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnRlc3QtYnJhbmNoJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYzJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-comment"># Download from the \`v1.0\` tag</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;v1.0&quot;</span>)

<span class="hljs-comment"># Download from the \`test-branch\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;test-branch&quot;</span>)

<span class="hljs-comment"># Download from Pull Request #3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/3&quot;</span>)

<span class="hljs-comment"># Download from a specific commit hash</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),Y=new b({props:{title:"Construct a download URL",local:"construct-a-download-url",headingTag:"h3"}}),R=new b({props:{title:"Download an entire repository",local:"download-an-entire-repository",headingTag:"h2"}}),W=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKSUwQSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJnb29nbGUlMkZmbGV1cnMlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>

<span class="hljs-comment"># Or from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34&#x27;</span>`,wrap:!1}}),z=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/1&quot;</span>)`,wrap:!1}}),F=new b({props:{title:"Filter files to download",local:"filter-files-to-download",headingTag:"h3"}}),V=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, allow_patterns=<span class="hljs-string">&quot;*.json&quot;</span>)`,wrap:!1}}),A=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwaWdub3JlX3BhdHRlcm5zJTNEJTVCJTIyKi5tc2dwYWNrJTIyJTJDJTIwJTIyKi5oNSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, ignore_patterns=[<span class="hljs-string">&quot;*.msgpack&quot;</span>, <span class="hljs-string">&quot;*.h5&quot;</span>])`,wrap:!1}}),O=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmdwdDIlMjIlMkMlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMioubWQlMjIlMkMlMjAlMjIqLmpzb24lMjIlNUQlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjJ2b2NhYi5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;gpt2&quot;</span>, allow_patterns=[<span class="hljs-string">&quot;*.md&quot;</span>, <span class="hljs-string">&quot;*.json&quot;</span>], ignore_patterns=<span class="hljs-string">&quot;vocab.json&quot;</span>)`,wrap:!1}}),ee=new b({props:{title:"Download file(s) to a local folder",local:"download-files-to-a-local-folder",headingTag:"h2"}}),v=new Lt({props:{$$slots:{default:[Ma]},$$scope:{ctx:y}}}),se=new b({props:{title:"Download from the CLI",local:"download-from-the-cli",headingTag:"h2"}}),ie=new $({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24=",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),re=new $({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjBtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json model.safetensors
Fetching 2 files: 100%|████████████████████████████████████████████| 2/2 [00:00&lt;00:00, 23831.27it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),fe=new b({props:{title:"Faster downloads",local:"faster-downloads",headingTag:"h2"}}),ue=new b({props:{title:"hf_xet",local:"hfxet",headingTag:"h3"}}),be=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwJTIyaHVnZ2luZ2ZhY2VfaHViJTVCaGZfeGV0JTVEJTIy",highlighted:'pip install -U <span class="hljs-string">&quot;huggingface_hub[hf_xet]&quot;</span>',wrap:!1}}),ye=new b({props:{title:"hf_transfer",local:"hftransfer",headingTag:"h3"}}),T=new Lt({props:{warning:!0,$$slots:{default:[va]},$$scope:{ctx:y}}}),Te=new $a({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/download.md"}}),{c(){r=o("meta"),w=l(),m=o("p"),_=l(),h(j.$$.fragment),xe=l(),x=o("p"),x.innerHTML=qt,He=l(),H=o("ul"),H.innerHTML=Ct,Je=l(),h(J.$$.fragment),ke=l(),k=o("p"),k.innerHTML=Ut,Le=l(),h(M.$$.fragment),Ze=l(),h(L.$$.fragment),qe=l(),Z=o("p"),Z.innerHTML=Gt,Ce=l(),h(q.$$.fragment),Ue=l(),h(C.$$.fragment),Ge=l(),U=o("p"),U.innerHTML=It,Ie=l(),h(G.$$.fragment),Ye=l(),I=o("p"),I.innerHTML=Yt,Xe=l(),h(Y.$$.fragment),Re=l(),X=o("p"),X.innerHTML=Xt,Be=l(),h(R.$$.fragment),Ne=l(),B=o("p"),B.innerHTML=Rt,We=l(),N=o("p"),N.innerHTML=Bt,Pe=l(),h(W.$$.fragment),ze=l(),P=o("p"),P.innerHTML=Nt,Fe=l(),h(z.$$.fragment),Qe=l(),h(F.$$.fragment),Se=l(),Q=o("p"),Q.innerHTML=Wt,De=l(),S=o("p"),S.innerHTML=Pt,Ve=l(),D=o("p"),D.innerHTML=zt,Ee=l(),h(V.$$.fragment),Ae=l(),E=o("p"),E.innerHTML=Ft,Ke=l(),h(A.$$.fragment),Oe=l(),K=o("p"),K.innerHTML=Qt,et=l(),h(O.$$.fragment),tt=l(),h(ee.$$.fragment),at=l(),te=o("p"),te.innerHTML=St,nt=l(),ae=o("p"),ae.innerHTML=Dt,lt=l(),ne=o("p"),ne.innerHTML=Vt,st=l(),le=o("p"),le.innerHTML=Et,ot=l(),h(v.$$.fragment),it=l(),h(se.$$.fragment),dt=l(),oe=o("p"),oe.innerHTML=At,rt=l(),h(ie.$$.fragment),ht=l(),de=o("p"),de.textContent=Kt,ft=l(),h(re.$$.fragment),pt=l(),he=o("p"),he.innerHTML=Ot,ct=l(),h(fe.$$.fragment),ut=l(),pe=o("p"),pe.textContent=ea,gt=l(),ce=o("ul"),ce.innerHTML=ta,mt=l(),h(ue.$$.fragment),wt=l(),ge=o("p"),ge.innerHTML=aa,bt=l(),me=o("p"),me.innerHTML=na,_t=l(),we=o("p"),we.innerHTML=la,$t=l(),h(be.$$.fragment),yt=l(),_e=o("p"),_e.innerHTML=sa,Mt=l(),$e=o("p"),$e.innerHTML=oa,vt=l(),h(ye.$$.fragment),Tt=l(),Me=o("p"),Me.innerHTML=ia,jt=l(),ve=o("ol"),ve.innerHTML=da,xt=l(),h(T.$$.fragment),Ht=l(),h(Te.$$.fragment),Jt=l(),je=o("p"),this.h()},l(e){const t=ba("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(a),w=s(e),m=i(e,"P",{}),pa(m).forEach(a),_=s(e),f(j.$$.fragment,e),xe=s(e),x=i(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-10amgpw"&&(x.innerHTML=qt),He=s(e),H=i(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-1jcodts"&&(H.innerHTML=Ct),Je=s(e),f(J.$$.fragment,e),ke=s(e),k=i(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1h7nepg"&&(k.innerHTML=Ut),Le=s(e),f(M.$$.fragment,e),Ze=s(e),f(L.$$.fragment,e),qe=s(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-18kdxej"&&(Z.innerHTML=Gt),Ce=s(e),f(q.$$.fragment,e),Ue=s(e),f(C.$$.fragment,e),Ge=s(e),U=i(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-16duplw"&&(U.innerHTML=It),Ie=s(e),f(G.$$.fragment,e),Ye=s(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1inqh8h"&&(I.innerHTML=Yt),Xe=s(e),f(Y.$$.fragment,e),Re=s(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1g8f65c"&&(X.innerHTML=Xt),Be=s(e),f(R.$$.fragment,e),Ne=s(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1xrc0oj"&&(B.innerHTML=Rt),We=s(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-18b676r"&&(N.innerHTML=Bt),Pe=s(e),f(W.$$.fragment,e),ze=s(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1omhhlo"&&(P.innerHTML=Nt),Fe=s(e),f(z.$$.fragment,e),Qe=s(e),f(F.$$.fragment,e),Se=s(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1ddox2e"&&(Q.innerHTML=Wt),De=s(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-u3vbhu"&&(S.innerHTML=Pt),Ve=s(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1dn885x"&&(D.innerHTML=zt),Ee=s(e),f(V.$$.fragment,e),Ae=s(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-uzetax"&&(E.innerHTML=Ft),Ke=s(e),f(A.$$.fragment,e),Oe=s(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-ndvph"&&(K.innerHTML=Qt),et=s(e),f(O.$$.fragment,e),tt=s(e),f(ee.$$.fragment,e),at=s(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1mbgx4u"&&(te.innerHTML=St),nt=s(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-7dqi55"&&(ae.innerHTML=Dt),lt=s(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-xmbqlw"&&(ne.innerHTML=Vt),st=s(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-9mgyuw"&&(le.innerHTML=Et),ot=s(e),f(v.$$.fragment,e),it=s(e),f(se.$$.fragment,e),dt=s(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1enzk1r"&&(oe.innerHTML=At),rt=s(e),f(ie.$$.fragment,e),ht=s(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-c19wqr"&&(de.textContent=Kt),ft=s(e),f(re.$$.fragment,e),pt=s(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-n4le8a"&&(he.innerHTML=Ot),ct=s(e),f(fe.$$.fragment,e),ut=s(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-k4ctg0"&&(pe.textContent=ea),gt=s(e),ce=i(e,"UL",{"data-svelte-h":!0}),d(ce)!=="svelte-1h6up4v"&&(ce.innerHTML=ta),mt=s(e),f(ue.$$.fragment,e),wt=s(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-dgqlzs"&&(ge.innerHTML=aa),bt=s(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-16zgl6t"&&(me.innerHTML=na),_t=s(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-pllcje"&&(we.innerHTML=la),$t=s(e),f(be.$$.fragment,e),yt=s(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-5lcqv2"&&(_e.innerHTML=sa),Mt=s(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-n2tblp"&&($e.innerHTML=oa),vt=s(e),f(ye.$$.fragment,e),Tt=s(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-7tg4bb"&&(Me.innerHTML=ia),jt=s(e),ve=i(e,"OL",{"data-svelte-h":!0}),d(ve)!=="svelte-qiartd"&&(ve.innerHTML=da),xt=s(e),f(T.$$.fragment,e),Ht=s(e),f(Te.$$.fragment,e),Jt=s(e),je=i(e,"P",{}),pa(je).forEach(a),this.h()},h(){ca(r,"name","hf:doc:metadata"),ca(r,"content",ja)},m(e,t){_a(document.head,r),n(e,w,t),n(e,m,t),n(e,_,t),p(j,e,t),n(e,xe,t),n(e,x,t),n(e,He,t),n(e,H,t),n(e,Je,t),p(J,e,t),n(e,ke,t),n(e,k,t),n(e,Le,t),p(M,e,t),n(e,Ze,t),p(L,e,t),n(e,qe,t),n(e,Z,t),n(e,Ce,t),p(q,e,t),n(e,Ue,t),p(C,e,t),n(e,Ge,t),n(e,U,t),n(e,Ie,t),p(G,e,t),n(e,Ye,t),n(e,I,t),n(e,Xe,t),p(Y,e,t),n(e,Re,t),n(e,X,t),n(e,Be,t),p(R,e,t),n(e,Ne,t),n(e,B,t),n(e,We,t),n(e,N,t),n(e,Pe,t),p(W,e,t),n(e,ze,t),n(e,P,t),n(e,Fe,t),p(z,e,t),n(e,Qe,t),p(F,e,t),n(e,Se,t),n(e,Q,t),n(e,De,t),n(e,S,t),n(e,Ve,t),n(e,D,t),n(e,Ee,t),p(V,e,t),n(e,Ae,t),n(e,E,t),n(e,Ke,t),p(A,e,t),n(e,Oe,t),n(e,K,t),n(e,et,t),p(O,e,t),n(e,tt,t),p(ee,e,t),n(e,at,t),n(e,te,t),n(e,nt,t),n(e,ae,t),n(e,lt,t),n(e,ne,t),n(e,st,t),n(e,le,t),n(e,ot,t),p(v,e,t),n(e,it,t),p(se,e,t),n(e,dt,t),n(e,oe,t),n(e,rt,t),p(ie,e,t),n(e,ht,t),n(e,de,t),n(e,ft,t),p(re,e,t),n(e,pt,t),n(e,he,t),n(e,ct,t),p(fe,e,t),n(e,ut,t),n(e,pe,t),n(e,gt,t),n(e,ce,t),n(e,mt,t),p(ue,e,t),n(e,wt,t),n(e,ge,t),n(e,bt,t),n(e,me,t),n(e,_t,t),n(e,we,t),n(e,$t,t),p(be,e,t),n(e,yt,t),n(e,_e,t),n(e,Mt,t),n(e,$e,t),n(e,vt,t),p(ye,e,t),n(e,Tt,t),n(e,Me,t),n(e,jt,t),n(e,ve,t),n(e,xt,t),p(T,e,t),n(e,Ht,t),p(Te,e,t),n(e,Jt,t),n(e,je,t),kt=!0},p(e,[t]){const ra={};t&2&&(ra.$$scope={dirty:t,ctx:e}),M.$set(ra);const ha={};t&2&&(ha.$$scope={dirty:t,ctx:e}),v.$set(ha);const fa={};t&2&&(fa.$$scope={dirty:t,ctx:e}),T.$set(fa)},i(e){kt||(c(j.$$.fragment,e),c(J.$$.fragment,e),c(M.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(C.$$.fragment,e),c(G.$$.fragment,e),c(Y.$$.fragment,e),c(R.$$.fragment,e),c(W.$$.fragment,e),c(z.$$.fragment,e),c(F.$$.fragment,e),c(V.$$.fragment,e),c(A.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(v.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(fe.$$.fragment,e),c(ue.$$.fragment,e),c(be.$$.fragment,e),c(ye.$$.fragment,e),c(T.$$.fragment,e),c(Te.$$.fragment,e),kt=!0)},o(e){u(j.$$.fragment,e),u(J.$$.fragment,e),u(M.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(C.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(R.$$.fragment,e),u(W.$$.fragment,e),u(z.$$.fragment,e),u(F.$$.fragment,e),u(V.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(v.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(T.$$.fragment,e),u(Te.$$.fragment,e),kt=!1},d(e){e&&(a(w),a(m),a(_),a(xe),a(x),a(He),a(H),a(Je),a(ke),a(k),a(Le),a(Ze),a(qe),a(Z),a(Ce),a(Ue),a(Ge),a(U),a(Ie),a(Ye),a(I),a(Xe),a(Re),a(X),a(Be),a(Ne),a(B),a(We),a(N),a(Pe),a(ze),a(P),a(Fe),a(Qe),a(Se),a(Q),a(De),a(S),a(Ve),a(D),a(Ee),a(Ae),a(E),a(Ke),a(Oe),a(K),a(et),a(tt),a(at),a(te),a(nt),a(ae),a(lt),a(ne),a(st),a(le),a(ot),a(it),a(dt),a(oe),a(rt),a(ht),a(de),a(ft),a(pt),a(he),a(ct),a(ut),a(pe),a(gt),a(ce),a(mt),a(wt),a(ge),a(bt),a(me),a(_t),a(we),a($t),a(yt),a(_e),a(Mt),a($e),a(vt),a(Tt),a(Me),a(jt),a(ve),a(xt),a(Ht),a(Jt),a(je)),a(r),g(j,e),g(J,e),g(M,e),g(L,e),g(q,e),g(C,e),g(G,e),g(Y,e),g(R,e),g(W,e),g(z,e),g(F,e),g(V,e),g(A,e),g(O,e),g(ee,e),g(v,e),g(se,e),g(ie,e),g(re,e),g(fe,e),g(ue,e),g(be,e),g(ye,e),g(T,e),g(Te,e)}}}const ja='{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Download a single file","local":"download-a-single-file","sections":[{"title":"From latest version","local":"from-latest-version","sections":[],"depth":3},{"title":"From specific version","local":"from-specific-version","sections":[],"depth":3},{"title":"Construct a download URL","local":"construct-a-download-url","sections":[],"depth":3}],"depth":2},{"title":"Download an entire repository","local":"download-an-entire-repository","sections":[{"title":"Filter files to download","local":"filter-files-to-download","sections":[],"depth":3}],"depth":2},{"title":"Download file(s) to a local folder","local":"download-files-to-a-local-folder","sections":[],"depth":2},{"title":"Download from the CLI","local":"download-from-the-cli","sections":[],"depth":2},{"title":"Faster downloads","local":"faster-downloads","sections":[{"title":"hf_xet","local":"hfxet","sections":[],"depth":3},{"title":"hf_transfer","local":"hftransfer","sections":[],"depth":3}],"depth":2}],"depth":1}';function xa(y){return ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qa extends ma{constructor(r){super(),wa(this,r,xa,Ta,ua,{})}}export{qa as component};
