import{s as zs,n as $s,o as Qs}from"../chunks/scheduler.c59d9fbb.js";import{S as Fs,i as Ys,g as M,s as a,r as i,A as Ss,h as p,f as e,c as n,j as vs,u as j,x as m,k as Ns,y as Hs,a as t,v as J,d as c,t as y,w as o}from"../chunks/index.a47918e3.js";import{C as w}from"../chunks/CodeBlock.936db8cd.js";import{H as ol}from"../chunks/Heading.604bc707.js";function qs(ys){let r,wl,cl,rl,T,Tl,d,os='<a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit</a> is a technique for few-shot text classification that uses contrastive learning to fine-tune Sentence Transformers in domains where little to no labeled data is available. It achieves comparable performance to existing state-of-the-art methods based on large language models, yet requires no prompts and is efficient to train (typically a few seconds on a GPU to minutes on a CPU).',dl,U,ws="In this notebook you’ll learn how to further compress SetFit models for faster inference & deployment on GPU using Optimum Onnx.",Ul,h,hl,u,rs="Our first step is to install SetFit. Running the following cell will install all the required packages for us.",ul,I,Il,b,bl,f,Ts="Before we train and optimize any models, let’s define a performance benchmark that we can use to compare our models. In general, deploying ML models in production environments involves a tradeoff among several constraints:",fl,C,ds="<li>Model performance: how well does the model perform on a well crafted test set?</li> <li>Latency: how fast can our model deliver predictions?</li> <li>Memory: on what cloud instance or device can we store and load our model?</li>",Cl,A,Us="The class below defines a simple benchmark that measure each quantity for a given SetFit model and test dataset:",Al,Z,Zl,B,hs="Beyond that, we’ll create a simple function to plot the performances reported by this benchmark.",Bl,W,Wl,G,Gl,X,us='Before we optimize any models, let’s train a few baselines as a point of reference. We’ll use the <a href="https://huggingface.co/datasets/SetFit/sst2" rel="nofollow">sst-2</a> dataset, which is a collection of sentiment text catagorized into 2 classes: positive, negative',Xl,_,Is="Let’s start by loading the dataset from the Hub:",_l,k,kl,R,Rl,g,bs="We train a SetFit model with the full dataset. Recall that SetFit excels with few-shot scenario, but this time we are interested to achieve maximum accuracy.",gl,E,El,x,fs='Use the following line code to download the <a href="https://huggingface.co/moshew/bge-small-en-v1.5_setfit-sst2-english" rel="nofollow">already finetuned model</a> and evaluate. Alternatively, uncomment the code below it to fine-tune the base model from scratch.',xl,V,Cs="Note that we perform the evaluations on Google Colab using the free T4 GPU.",Vl,v,vl,N,Nl,z,zl,$,As="Let’s plot the results to visualise the performance:",$l,Q,Ql,F,Zs='<img src="https://github.com/huggingface/setfit/assets/37621491/4786eee6-88c8-46ca-95be-801514697a9d" alt="setfit_torch"/>',Fl,Y,Yl,S,Bs='We’ll be using Optimum’s ONNX Runtime support with <code>CUDAExecutionProvider</code> <a href="https://github.com/huggingface/optimum-benchmark/tree/main/examples/fast-mteb#notes" rel="nofollow">because it’s fast while also supporting dynamic shapes</a>.',Sl,H,Hl,q,Ws='<a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/optimization#optimizing-a-model-during-the-onnx-export" rel="nofollow"><code>optimum-cli</code></a> makes it extremely easy to export a model to ONNX and apply SOTA graph optimizations / kernel fusions.',ql,L,Ll,K,Gs="We may see some warnings, but these are not ones to be concerned about. We’ll see later that it does not affect the model performance.",Kl,P,Xs="First of all, we’ll create a subclass of our performance benchmark to also allow benchmarking ONNX models.",Pl,D,Dl,O,_s="Then, we can load the converted SentenceTransformer model with the <code>&quot;CUDAExecutionProvider&quot;</code> provider. Feel free to also experiment with other providers, such as <code>&quot;TensorrtExecutionProvider&quot;</code> and <code>&quot;CPUExecutionProvider&quot;</code>. The former may be even faster than <code>&quot;CUDAExecutionProvider&quot;</code>, but requires more installation.",Ol,ll,ls,sl,ks="And let’s make a class that uses the tokenizer, ONNX Runtime (ORT) model and a SetFit model head.",ss,el,es,tl,Rs="We can initialize this model like so:",ts,al,as,nl,ns,Ml,gs="Time to benchmark this ONNX model.",Ms,pl,ps,ml,ms,il,Es='<img src="https://github.com/huggingface/setfit/assets/37621491/9907ec1d-d4c6-431d-8695-1adc4247a576" alt="setfit_onnx"/>',is,jl,xs="By applying ONNX, we were able to improve the latency from 13.43ms per sample to 2.19ms per sample, for a speedup of 6.13x!",js,Jl,Vs="For further improvements, we recommend increasing the inference batch size, as this may also heavily improve the throughput. For example, setting the batch size to 128 reduces the latency further down to 0.3ms, and down to 0.2ms at a batch size of 2048.",Js,yl,cs;return T=new ol({props:{title:"Efficiently run SetFit Models with Optimum",local:"efficiently-run-setfit-models-with-optimum",headingTag:"h1"}}),h=new ol({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),I=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzZXRmaXQlMjBhY2NlbGVyYXRlJTIwLXFxcQ==",highlighted:'!pip <span class="hljs-keyword">install</span> setfit accelerate -qqq',wrap:!1}}),b=new ol({props:{title:"2. Create a performance benchmark",local:"2-create-a-performance-benchmark",headingTag:"h2"}}),Z=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> perf_counter

<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PerformanceBenchmark</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model, dataset, optim_type</span>):
        self.model = model
        self.dataset = dataset
        self.optim_type = optim_type

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_accuracy</span>(<span class="hljs-params">self</span>):
        preds = self.model.predict(self.dataset[<span class="hljs-string">&quot;text&quot;</span>])
        labels = self.dataset[<span class="hljs-string">&quot;label&quot;</span>]
        accuracy = metric.compute(predictions=preds, references=labels)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Accuracy on test set - <span class="hljs-subst">{accuracy[<span class="hljs-string">&#x27;accuracy&#x27;</span>]:<span class="hljs-number">.3</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> accuracy

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_size</span>(<span class="hljs-params">self</span>):
        state_dict = self.model.model_body.state_dict()
        tmp_path = Path(<span class="hljs-string">&quot;model.pt&quot;</span>)
        torch.save(state_dict, tmp_path)
        <span class="hljs-comment"># Calculate size in megabytes</span>
        size_mb = Path(tmp_path).stat().st_size / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)
        <span class="hljs-comment"># Delete temporary file</span>
        tmp_path.unlink()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model size (MB) - <span class="hljs-subst">{size_mb:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;size_mb&quot;</span>: size_mb}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">time_model</span>(<span class="hljs-params">self, query=<span class="hljs-string">&quot;that loves its characters and communicates something rather beautiful about human nature&quot;</span></span>):
        latencies = []
        <span class="hljs-comment"># Warmup</span>
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
            _ = self.model([query])
        <span class="hljs-comment"># Timed run</span>
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">100</span>):
            start_time = perf_counter()
            _ = self.model([query])
            latency = perf_counter() - start_time
            latencies.append(latency)
        <span class="hljs-comment"># Compute run statistics</span>
        time_avg_ms = <span class="hljs-number">1000</span> * np.mean(latencies)
        time_std_ms = <span class="hljs-number">1000</span> * np.std(latencies)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">rf&quot;Average latency (ms) - <span class="hljs-subst">{time_avg_ms:<span class="hljs-number">.2</span>f}</span> +\\- <span class="hljs-subst">{time_std_ms:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;time_avg_ms&quot;</span>: time_avg_ms, <span class="hljs-string">&quot;time_std_ms&quot;</span>: time_std_ms}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_benchmark</span>(<span class="hljs-params">self</span>):
        metrics = {}
        metrics[self.optim_type] = self.compute_size()
        metrics[self.optim_type].update(self.compute_accuracy())
        metrics[self.optim_type].update(self.time_model())
        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),W=new w({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEElMEFkZWYlMjBwbG90X21ldHJpY3MocGVyZl9tZXRyaWNzKSUzQSUwQSUyMCUyMCUyMCUyMGRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChwZXJmX21ldHJpY3MlMkMlMjBvcmllbnQlM0QlMjJpbmRleCUyMiklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBpZHglMjBpbiUyMGRmLmluZGV4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGZfb3B0JTIwJTNEJTIwZGYubG9jJTVCaWR4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0LmVycm9yYmFyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRmX29wdCU1QiUyMnRpbWVfYXZnX21zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGZfb3B0JTVCJTIyYWNjdXJhY3klMjIlNUQlMjAqJTIwMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweGVyciUzRGRmX29wdCU1QiUyMnRpbWVfc3RkX21zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm10JTNEJTIybyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbXMlM0RkZl9vcHQlNUIlMjJzaXplX21iJTIyJTVEJTIwJTJGJTIwMTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbCUzRGlkeCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcHNpemUlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FwdGhpY2slM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGxlZ2VuZCUyMCUzRCUyMHBsdC5sZWdlbmQobG9jJTNEJTIybG93ZXIlMjByaWdodCUyMiklMEElMEElMjAlMjAlMjAlMjBwbHQueWxpbSg2MyUyQyUyMDk1KSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHNsb3dlc3QlMjBtb2RlbCUyMHRvJTIwZGVmaW5lJTIwdGhlJTIweC1heGlzJTIwcmFuZ2UlMEElMjAlMjAlMjAlMjB4bGltJTIwJTNEJTIwbWF4KCU1Qm1ldHJpY3MlNUIlMjJ0aW1lX2F2Z19tcyUyMiU1RCUyMGZvciUyMG1ldHJpY3MlMjBpbiUyMHBlcmZfbWV0cmljcy52YWx1ZXMoKSU1RCklMjAqJTIwMS4yJTBBJTIwJTIwJTIwJTIwcGx0LnhsaW0oMCUyQyUyMHhsaW0pJTBBJTIwJTIwJTIwJTIwcGx0LnlsYWJlbCglMjJBY2N1cmFjeSUyMCglMjUpJTIyKSUwQSUyMCUyMCUyMCUyMHBsdC54bGFiZWwoJTIyQXZlcmFnZSUyMGxhdGVuY3klMjB3aXRoJTIwYmF0Y2hfc2l6ZSUzRDElMjAobXMpJTIyKSUwQSUyMCUyMCUyMCUyMHBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_metrics</span>(<span class="hljs-params">perf_metrics</span>):
    df = pd.DataFrame.from_dict(perf_metrics, orient=<span class="hljs-string">&quot;index&quot;</span>)

    <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> df.index:
        df_opt = df.loc[idx]
        plt.errorbar(
            df_opt[<span class="hljs-string">&quot;time_avg_ms&quot;</span>],
            df_opt[<span class="hljs-string">&quot;accuracy&quot;</span>] * <span class="hljs-number">100</span>,
            xerr=df_opt[<span class="hljs-string">&quot;time_std_ms&quot;</span>],
            fmt=<span class="hljs-string">&quot;o&quot;</span>,
            alpha=<span class="hljs-number">0.5</span>,
            ms=df_opt[<span class="hljs-string">&quot;size_mb&quot;</span>] / <span class="hljs-number">15</span>,
            label=idx,
            capsize=<span class="hljs-number">5</span>,
            capthick=<span class="hljs-number">1</span>,
        )

    legend = plt.legend(loc=<span class="hljs-string">&quot;lower right&quot;</span>)

    plt.ylim(<span class="hljs-number">63</span>, <span class="hljs-number">95</span>)
    <span class="hljs-comment"># Use the slowest model to define the x-axis range</span>
    xlim = <span class="hljs-built_in">max</span>([metrics[<span class="hljs-string">&quot;time_avg_ms&quot;</span>] <span class="hljs-keyword">for</span> metrics <span class="hljs-keyword">in</span> perf_metrics.values()]) * <span class="hljs-number">1.2</span>
    plt.xlim(<span class="hljs-number">0</span>, xlim)
    plt.ylabel(<span class="hljs-string">&quot;Accuracy (%)&quot;</span>)
    plt.xlabel(<span class="hljs-string">&quot;Average latency with batch_size=1 (ms)&quot;</span>)
    plt.show()`,wrap:!1}}),G=new ol({props:{title:"3. Train/evaluate bge-small SetFit models",local:"3-trainevaluate-bge-small-setfit-models",headingTag:"h2"}}),k=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTZXRGaXQlMkZzc3QyJTIyKSUwQWRhdGFzZXQ=",highlighted:`from datasets import load_dataset

<span class="hljs-attribute">dataset</span> <span class="hljs-operator">=</span> load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
dataset`,wrap:!1}}),R=new w({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyUyQyUyMCdsYWJlbF90ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjkyMCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB2YWxpZGF0aW9uJTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclMkMlMjAnbGFiZWxfdGV4dCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDg3MiUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclMkMlMjAnbGFiZWxfdGV4dCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDE4MjElMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">6920</span>
    })
    validation: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">872</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">1821</span>
    })
})`,wrap:!1}}),E=new w({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ2YWxpZGF0aW9uJTIyJTVE",highlighted:`train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>]
test_dataset = dataset[<span class="hljs-string">&quot;validation&quot;</span>]`,wrap:!1}}),v=new w({props:{code:"JTIzJTIwRXZhbHVhdGUlMjB0aGUlMjB1cGxvYWRlZCUyMG1vZGVsISUwQWZyb20lMjBzZXRmaXQlMjBpbXBvcnQlMjBTZXRGaXRNb2RlbCUwQSUwQXNtYWxsX21vZGVsJTIwJTNEJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2hldyUyRmJnZS1zbWFsbC1lbi12MS41X3NldGZpdC1zc3QyLWVuZ2xpc2glMjIpJTBBcGIlMjAlM0QlMjBQZXJmb3JtYW5jZUJlbmNobWFyayhtb2RlbCUzRHNtYWxsX21vZGVsJTJDJTIwZGF0YXNldCUzRHRlc3RfZGF0YXNldCUyQyUyMG9wdGltX3R5cGUlM0QlMjJiZ2Utc21hbGwlMjAoUHlUb3JjaCklMjIpJTBBcGVyZl9tZXRyaWNzJTIwJTNEJTIwcGIucnVuX2JlbmNobWFyaygp",highlighted:`<span class="hljs-comment"># Evaluate the uploaded model!</span>
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

small_model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;moshew/bge-small-en-v1.5_setfit-sst2-english&quot;</span>)
pb = PerformanceBenchmark(model=small_model, dataset=test_dataset, optim_type=<span class="hljs-string">&quot;bge-small (PyTorch)&quot;</span>)
perf_metrics = pb.run_benchmark()`,wrap:!1}}),N=new w({props:{code:"TW9kZWwlMjBzaXplJTIwKE1CKSUyMC0lMjAxMjcuMzMlMEFBY2N1cmFjeSUyMG9uJTIwdGVzdCUyMHNldCUyMC0lMjAwLjkwNiUwQUF2ZXJhZ2UlMjBsYXRlbmN5JTIwKG1zKSUyMC0lMjAxNy40MiUyMCUyQiU1Qy0lMjA0LjQ3",highlighted:`<span class="hljs-attribute">Model</span> size (MB) - <span class="hljs-number">127</span>.<span class="hljs-number">33</span>
<span class="hljs-attribute">Accuracy</span> <span class="hljs-literal">on</span> test set - <span class="hljs-number">0</span>.<span class="hljs-number">906</span>
<span class="hljs-attribute">Average</span> latency (ms) - <span class="hljs-number">17</span>.<span class="hljs-number">42</span> +\\- <span class="hljs-number">4</span>.<span class="hljs-number">47</span>`,wrap:!1}}),z=new w({props:{code:"JTIzJTIwJTIzJTIwRmluZS10dW5lJTIwdGhlJTIwYmFzZSUyMG1vZGVsJTIwYW5kJTIwRXZhbHVhdGUhJTBBJTIzJTIwZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwVHJhaW5lciUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIzJTIwJTIzJTIwTG9hZCUyMHByZXRyYWluZWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEElMjMlMjBzbWFsbF9tb2RlbCUyMCUzRCUyMFNldEZpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjMlMjAlMjAlMjAlMjAlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIlMEElMjMlMjApJTBBJTIzJTIwYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG51bV9pdGVyYXRpb25zJTNEMjApJTBBJTBBJTIzJTIwJTIzJTIwQ3JlYXRlJTIwdHJhaW5lciUwQSUyMyUyMHNtYWxsX3RyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMyUyMCUyMCUyMCUyMG1vZGVsJTNEc21hbGxfbW9kZWwlMkMlMjBhcmdzJTNEYXJncyUyQyUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTBBJTIzJTIwKSUwQSUyMyUyMCUyMyUyMFRyYWluISUwQSUyMyUyMHNtYWxsX3RyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMCUyMyUyMEV2YWx1YXRlISUwQSUyMyUyMHBiJTIwJTNEJTIwUGVyZm9ybWFuY2VCZW5jaG1hcmsoJTBBJTIzJTIwJTIwJTIwJTIwbW9kZWwlM0RzbWFsbF90cmFpbmVyLm1vZGVsJTJDJTIwZGF0YXNldCUzRHRlc3RfZGF0YXNldCUyQyUyMG9wdGltX3R5cGUlM0QlMjJiZ2Utc21hbGwlMjAoYmFzZSklMjIlMEElMjMlMjApJTBBJTIzJTIwcGVyZl9tZXRyaWNzJTIwJTNEJTIwcGIucnVuX2JlbmNobWFyaygp",highlighted:`<span class="hljs-comment"># # Fine-tune the base model and Evaluate!</span>
<span class="hljs-comment"># from setfit import SetFitModel, Trainer, TrainingArguments</span>

<span class="hljs-comment"># # Load pretrained model from the Hub</span>
<span class="hljs-comment"># small_model = SetFitModel.from_pretrained(</span>
<span class="hljs-comment">#    &quot;BAAI/bge-small-en-v1.5&quot;</span>
<span class="hljs-comment"># )</span>
<span class="hljs-comment"># args = TrainingArguments(num_iterations=20)</span>

<span class="hljs-comment"># # Create trainer</span>
<span class="hljs-comment"># small_trainer = Trainer(</span>
<span class="hljs-comment">#    model=small_model, args=args, train_dataset=train_dataset</span>
<span class="hljs-comment"># )</span>
<span class="hljs-comment"># # Train!</span>
<span class="hljs-comment"># small_trainer.train()</span>

<span class="hljs-comment"># # Evaluate!</span>
<span class="hljs-comment"># pb = PerformanceBenchmark(</span>
<span class="hljs-comment">#    model=small_trainer.model, dataset=test_dataset, optim_type=&quot;bge-small (base)&quot;</span>
<span class="hljs-comment"># )</span>
<span class="hljs-comment"># perf_metrics = pb.run_benchmark()</span>`,wrap:!1}}),Q=new w({props:{code:"cGxvdF9tZXRyaWNzKHBlcmZfbWV0cmljcyk=",highlighted:'<span class="hljs-function"><span class="hljs-title">plot_metrics</span><span class="hljs-params">(perf_metrics)</span></span>',wrap:!1}}),Y=new ol({props:{title:"4. Compressing with Optimum ONNX and CUDAExecutionProvider",local:"4-compressing-with-optimum-onnx-and-cudaexecutionprovider",headingTag:"h2"}}),H=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcHRpbXVtJTVCb25ueHJ1bnRpbWUtZ3B1JTVEJTIwLXFxcQ==",highlighted:'!pip <span class="hljs-keyword">install</span> optimum[onnxruntime-gpu] -qqq',wrap:!1}}),L=new w({props:{code:"IW9wdGltdW0tY2xpJTIwZXhwb3J0JTIwb25ueCUyMCU1QyUwQSUyMCUyMC0tbW9kZWwlMjBtb3NoZXclMkZiZ2Utc21hbGwtZW4tdjEuNV9zZXRmaXQtc3N0Mi1lbmdsaXNoJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwZmVhdHVyZS1leHRyYWN0aW9uJTIwJTVDJTBBJTIwJTIwLS1vcHRpbWl6ZSUyME80JTIwJTVDJTBBJTIwJTIwLS1kZXZpY2UlMjBjdWRhJTIwJTVDJTBBJTIwJTIwYmdlX2F1dG9fb3B0X080",highlighted:`!optimum-cli export onnx \\
  --model moshew/bge-small-en-v1<span class="hljs-number">.5</span>_setfit-sst2-english \\
  --task feature-extraction \\
  --optimize O4 \\
  --device cuda \\
  bge_auto_opt_O4`,wrap:!1}}),D=new w({props:{code:"Y2xhc3MlMjBPbm54UGVyZm9ybWFuY2VCZW5jaG1hcmsoUGVyZm9ybWFuY2VCZW5jaG1hcmspJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMCphcmdzJTJDJTIwbW9kZWxfcGF0aCUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsX3BhdGglMjAlM0QlMjBtb2RlbF9wYXRoJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9zaXplKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZV9tYiUyMCUzRCUyMFBhdGgoc2VsZi5tb2RlbF9wYXRoKS5zdGF0KCkuc3Rfc2l6ZSUyMCUyRiUyMCgxMDI0JTIwKiUyMDEwMjQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMk1vZGVsJTIwc2l6ZSUyMChNQiklMjAtJTIwJTdCc2l6ZV9tYiUzQS4yZiU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJzaXplX21iJTIyJTNBJTIwc2l6ZV9tYiU3RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">OnnxPerformanceBenchmark</span>(<span class="hljs-title class_ inherited__">PerformanceBenchmark</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, *args, model_path, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(*args, **kwargs)
        self.model_path = model_path

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_size</span>(<span class="hljs-params">self</span>):
        size_mb = Path(self.model_path).stat().st_size / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model size (MB) - <span class="hljs-subst">{size_mb:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;size_mb&quot;</span>: size_mb}`,wrap:!1}}),ll=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nRmFjZSUyMEh1YiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCdiZ2VfYXV0b19vcHRfTzQnJTJDJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDUxMiklMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvckZlYXR1cmVFeHRyYWN0aW9uLmZyb21fcHJldHJhaW5lZCgnYmdlX2F1dG9fb3B0X080JyUyQyUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-comment"># Load model from HuggingFace Hub</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;bge_auto_opt_O4&#x27;</span>, model_max_length=<span class="hljs-number">512</span>)
ort_model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&#x27;bge_auto_opt_O4&#x27;</span>, provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>)`,wrap:!1}}),el=new w({props:{code:"ZnJvbSUyMHNldGZpdC5leHBvcnRlcnMudXRpbHMlMjBpbXBvcnQlMjBtZWFuX3Bvb2xpbmclMEElMEElMEFjbGFzcyUyME9ubnhTZXRGaXRNb2RlbCUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBvcnRfbW9kZWwlMkMlMjB0b2tlbml6ZXIlMkMlMjBtb2RlbF9oZWFkKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYub3J0X21vZGVsJTIwJTNEJTIwb3J0X21vZGVsJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi50b2tlbml6ZXIlMjAlM0QlMjB0b2tlbml6ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsX2hlYWQlMjAlM0QlMjBtb2RlbF9oZWFkJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlZGljdChzZWxmJTJDJTIwaW5wdXRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVuY29kZWRfaW5wdXRzJTIwJTNEJTIwc2VsZi50b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApLnRvKHNlbGYub3J0X21vZGVsLmRldmljZSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwc2VsZi5vcnRfbW9kZWwoKiplbmNvZGVkX2lucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWJlZGRpbmdzJTIwJTNEJTIwbWVhbl9wb29saW5nKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlNUIlMjJsYXN0X2hpZGRlbl9zdGF0ZSUyMiU1RCUyQyUyMGVuY29kZWRfaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5tb2RlbF9oZWFkLnByZWRpY3QoZW1iZWRkaW5ncy5jcHUoKSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwaW5wdXRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYucHJlZGljdChpbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> setfit.exporters.utils <span class="hljs-keyword">import</span> mean_pooling


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OnnxSetFitModel</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, ort_model, tokenizer, model_head</span>):
        self.ort_model = ort_model
        self.tokenizer = tokenizer
        self.model_head = model_head

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">self, inputs</span>):
        encoded_inputs = self.tokenizer(
            inputs, padding=<span class="hljs-literal">True</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        ).to(self.ort_model.device)

        outputs = self.ort_model(**encoded_inputs)
        embeddings = mean_pooling(
            outputs[<span class="hljs-string">&quot;last_hidden_state&quot;</span>], encoded_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
        )
        <span class="hljs-keyword">return</span> self.model_head.predict(embeddings.cpu())

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, inputs</span>):
        <span class="hljs-keyword">return</span> self.predict(inputs)`,wrap:!1}}),al=new w({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybW9zaGV3JTJGYmdlLXNtYWxsLWVuLXYxLjVfc2V0Zml0LXNzdDItZW5nbGlzaCUyMiklMEFvbm54X3NldGZpdF9tb2RlbCUyMCUzRCUyME9ubnhTZXRGaXRNb2RlbChvcnRfbW9kZWwlMkMlMjB0b2tlbml6ZXIlMkMlMjBtb2RlbC5tb2RlbF9oZWFkKSUwQSUwQSUyMyUyMFBlcmZvcm0lMjBpbmZlcmVuY2UlMEFvbm54X3NldGZpdF9tb2RlbCh0ZXN0X2RhdGFzZXQlNUIlMjJ0ZXh0JTIyJTVEJTVCJTNBMiU1RCk=",highlighted:`model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;moshew/bge-small-en-v1.5_setfit-sst2-english&quot;</span>)
onnx_setfit_model = OnnxSetFitModel(ort_model, tokenizer, model.model_head)

<span class="hljs-comment"># Perform inference</span>
onnx_setfit_model(test_dataset[<span class="hljs-string">&quot;text&quot;</span>][:<span class="hljs-number">2</span>])`,wrap:!1}}),nl=new w({props:{code:"YXJyYXkoJTVCMCUyQyUyMDAlNUQp",highlighted:'<span class="hljs-function"><span class="hljs-title">array</span><span class="hljs-params">([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>])</span></span>',wrap:!1}}),pl=new w({props:{code:"cGIlMjAlM0QlMjBPbm54UGVyZm9ybWFuY2VCZW5jaG1hcmsoJTBBJTIwJTIwJTIwJTIwb25ueF9zZXRmaXRfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0ZXN0X2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjAlMjJiZ2Utc21hbGwlMjAob3B0aW11bSUyME9OTlgpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcGF0aCUzRCUyMmJnZV9hdXRvX29wdF9PNCUyRm1vZGVsLm9ubnglMjIlMkMlMEEpJTBBcGVyZl9tZXRyaWNzLnVwZGF0ZShwYi5ydW5fYmVuY2htYXJrKCkp",highlighted:`pb = OnnxPerformanceBenchmark(
    onnx_setfit_model,
    test_dataset,
    <span class="hljs-string">&quot;bge-small (optimum ONNX)&quot;</span>,
    model_path=<span class="hljs-string">&quot;bge_auto_opt_O4/model.onnx&quot;</span>,
)
perf_metrics.update(pb.run_benchmark())`,wrap:!1}}),ml=new w({props:{code:"cGxvdF9tZXRyaWNzKHBlcmZfbWV0cmljcyk=",highlighted:"plot_metrics(perf_metrics)",wrap:!1}}),{c(){r=M("meta"),wl=a(),cl=M("p"),rl=a(),i(T.$$.fragment),Tl=a(),d=M("p"),d.innerHTML=os,dl=a(),U=M("p"),U.textContent=ws,Ul=a(),i(h.$$.fragment),hl=a(),u=M("p"),u.textContent=rs,ul=a(),i(I.$$.fragment),Il=a(),i(b.$$.fragment),bl=a(),f=M("p"),f.textContent=Ts,fl=a(),C=M("ul"),C.innerHTML=ds,Cl=a(),A=M("p"),A.textContent=Us,Al=a(),i(Z.$$.fragment),Zl=a(),B=M("p"),B.textContent=hs,Bl=a(),i(W.$$.fragment),Wl=a(),i(G.$$.fragment),Gl=a(),X=M("p"),X.innerHTML=us,Xl=a(),_=M("p"),_.textContent=Is,_l=a(),i(k.$$.fragment),kl=a(),i(R.$$.fragment),Rl=a(),g=M("p"),g.textContent=bs,gl=a(),i(E.$$.fragment),El=a(),x=M("p"),x.innerHTML=fs,xl=a(),V=M("p"),V.textContent=Cs,Vl=a(),i(v.$$.fragment),vl=a(),i(N.$$.fragment),Nl=a(),i(z.$$.fragment),zl=a(),$=M("p"),$.textContent=As,$l=a(),i(Q.$$.fragment),Ql=a(),F=M("p"),F.innerHTML=Zs,Fl=a(),i(Y.$$.fragment),Yl=a(),S=M("p"),S.innerHTML=Bs,Sl=a(),i(H.$$.fragment),Hl=a(),q=M("p"),q.innerHTML=Ws,ql=a(),i(L.$$.fragment),Ll=a(),K=M("p"),K.textContent=Gs,Kl=a(),P=M("p"),P.textContent=Xs,Pl=a(),i(D.$$.fragment),Dl=a(),O=M("p"),O.innerHTML=_s,Ol=a(),i(ll.$$.fragment),ls=a(),sl=M("p"),sl.textContent=ks,ss=a(),i(el.$$.fragment),es=a(),tl=M("p"),tl.textContent=Rs,ts=a(),i(al.$$.fragment),as=a(),i(nl.$$.fragment),ns=a(),Ml=M("p"),Ml.textContent=gs,Ms=a(),i(pl.$$.fragment),ps=a(),i(ml.$$.fragment),ms=a(),il=M("p"),il.innerHTML=Es,is=a(),jl=M("p"),jl.textContent=xs,js=a(),Jl=M("p"),Jl.textContent=Vs,Js=a(),yl=M("p"),this.h()},l(l){const s=Ss("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(e),wl=n(l),cl=p(l,"P",{}),vs(cl).forEach(e),rl=n(l),j(T.$$.fragment,l),Tl=n(l),d=p(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-n86os7"&&(d.innerHTML=os),dl=n(l),U=p(l,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1bd8w5"&&(U.textContent=ws),Ul=n(l),j(h.$$.fragment,l),hl=n(l),u=p(l,"P",{"data-svelte-h":!0}),m(u)!=="svelte-yduaqs"&&(u.textContent=rs),ul=n(l),j(I.$$.fragment,l),Il=n(l),j(b.$$.fragment,l),bl=n(l),f=p(l,"P",{"data-svelte-h":!0}),m(f)!=="svelte-13l2fse"&&(f.textContent=Ts),fl=n(l),C=p(l,"UL",{"data-svelte-h":!0}),m(C)!=="svelte-29gjki"&&(C.innerHTML=ds),Cl=n(l),A=p(l,"P",{"data-svelte-h":!0}),m(A)!=="svelte-z4wtvv"&&(A.textContent=Us),Al=n(l),j(Z.$$.fragment,l),Zl=n(l),B=p(l,"P",{"data-svelte-h":!0}),m(B)!=="svelte-6tflkv"&&(B.textContent=hs),Bl=n(l),j(W.$$.fragment,l),Wl=n(l),j(G.$$.fragment,l),Gl=n(l),X=p(l,"P",{"data-svelte-h":!0}),m(X)!=="svelte-15nd2qq"&&(X.innerHTML=us),Xl=n(l),_=p(l,"P",{"data-svelte-h":!0}),m(_)!=="svelte-saerdd"&&(_.textContent=Is),_l=n(l),j(k.$$.fragment,l),kl=n(l),j(R.$$.fragment,l),Rl=n(l),g=p(l,"P",{"data-svelte-h":!0}),m(g)!=="svelte-cffqw7"&&(g.textContent=bs),gl=n(l),j(E.$$.fragment,l),El=n(l),x=p(l,"P",{"data-svelte-h":!0}),m(x)!=="svelte-15w8xvk"&&(x.innerHTML=fs),xl=n(l),V=p(l,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1vdmtnq"&&(V.textContent=Cs),Vl=n(l),j(v.$$.fragment,l),vl=n(l),j(N.$$.fragment,l),Nl=n(l),j(z.$$.fragment,l),zl=n(l),$=p(l,"P",{"data-svelte-h":!0}),m($)!=="svelte-1r87202"&&($.textContent=As),$l=n(l),j(Q.$$.fragment,l),Ql=n(l),F=p(l,"P",{"data-svelte-h":!0}),m(F)!=="svelte-3yqnh2"&&(F.innerHTML=Zs),Fl=n(l),j(Y.$$.fragment,l),Yl=n(l),S=p(l,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1tl60qh"&&(S.innerHTML=Bs),Sl=n(l),j(H.$$.fragment,l),Hl=n(l),q=p(l,"P",{"data-svelte-h":!0}),m(q)!=="svelte-4oyakg"&&(q.innerHTML=Ws),ql=n(l),j(L.$$.fragment,l),Ll=n(l),K=p(l,"P",{"data-svelte-h":!0}),m(K)!=="svelte-hhd52e"&&(K.textContent=Gs),Kl=n(l),P=p(l,"P",{"data-svelte-h":!0}),m(P)!=="svelte-2m011h"&&(P.textContent=Xs),Pl=n(l),j(D.$$.fragment,l),Dl=n(l),O=p(l,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1n59tl1"&&(O.innerHTML=_s),Ol=n(l),j(ll.$$.fragment,l),ls=n(l),sl=p(l,"P",{"data-svelte-h":!0}),m(sl)!=="svelte-1fs19fo"&&(sl.textContent=ks),ss=n(l),j(el.$$.fragment,l),es=n(l),tl=p(l,"P",{"data-svelte-h":!0}),m(tl)!=="svelte-v502qs"&&(tl.textContent=Rs),ts=n(l),j(al.$$.fragment,l),as=n(l),j(nl.$$.fragment,l),ns=n(l),Ml=p(l,"P",{"data-svelte-h":!0}),m(Ml)!=="svelte-1tr4hv1"&&(Ml.textContent=gs),Ms=n(l),j(pl.$$.fragment,l),ps=n(l),j(ml.$$.fragment,l),ms=n(l),il=p(l,"P",{"data-svelte-h":!0}),m(il)!=="svelte-1yk7uwi"&&(il.innerHTML=Es),is=n(l),jl=p(l,"P",{"data-svelte-h":!0}),m(jl)!=="svelte-ph4797"&&(jl.textContent=xs),js=n(l),Jl=p(l,"P",{"data-svelte-h":!0}),m(Jl)!=="svelte-rbx6kg"&&(Jl.textContent=Vs),Js=n(l),yl=p(l,"P",{}),vs(yl).forEach(e),this.h()},h(){Ns(r,"name","hf:doc:metadata"),Ns(r,"content",Ls)},m(l,s){Hs(document.head,r),t(l,wl,s),t(l,cl,s),t(l,rl,s),J(T,l,s),t(l,Tl,s),t(l,d,s),t(l,dl,s),t(l,U,s),t(l,Ul,s),J(h,l,s),t(l,hl,s),t(l,u,s),t(l,ul,s),J(I,l,s),t(l,Il,s),J(b,l,s),t(l,bl,s),t(l,f,s),t(l,fl,s),t(l,C,s),t(l,Cl,s),t(l,A,s),t(l,Al,s),J(Z,l,s),t(l,Zl,s),t(l,B,s),t(l,Bl,s),J(W,l,s),t(l,Wl,s),J(G,l,s),t(l,Gl,s),t(l,X,s),t(l,Xl,s),t(l,_,s),t(l,_l,s),J(k,l,s),t(l,kl,s),J(R,l,s),t(l,Rl,s),t(l,g,s),t(l,gl,s),J(E,l,s),t(l,El,s),t(l,x,s),t(l,xl,s),t(l,V,s),t(l,Vl,s),J(v,l,s),t(l,vl,s),J(N,l,s),t(l,Nl,s),J(z,l,s),t(l,zl,s),t(l,$,s),t(l,$l,s),J(Q,l,s),t(l,Ql,s),t(l,F,s),t(l,Fl,s),J(Y,l,s),t(l,Yl,s),t(l,S,s),t(l,Sl,s),J(H,l,s),t(l,Hl,s),t(l,q,s),t(l,ql,s),J(L,l,s),t(l,Ll,s),t(l,K,s),t(l,Kl,s),t(l,P,s),t(l,Pl,s),J(D,l,s),t(l,Dl,s),t(l,O,s),t(l,Ol,s),J(ll,l,s),t(l,ls,s),t(l,sl,s),t(l,ss,s),J(el,l,s),t(l,es,s),t(l,tl,s),t(l,ts,s),J(al,l,s),t(l,as,s),J(nl,l,s),t(l,ns,s),t(l,Ml,s),t(l,Ms,s),J(pl,l,s),t(l,ps,s),J(ml,l,s),t(l,ms,s),t(l,il,s),t(l,is,s),t(l,jl,s),t(l,js,s),t(l,Jl,s),t(l,Js,s),t(l,yl,s),cs=!0},p:$s,i(l){cs||(c(T.$$.fragment,l),c(h.$$.fragment,l),c(I.$$.fragment,l),c(b.$$.fragment,l),c(Z.$$.fragment,l),c(W.$$.fragment,l),c(G.$$.fragment,l),c(k.$$.fragment,l),c(R.$$.fragment,l),c(E.$$.fragment,l),c(v.$$.fragment,l),c(N.$$.fragment,l),c(z.$$.fragment,l),c(Q.$$.fragment,l),c(Y.$$.fragment,l),c(H.$$.fragment,l),c(L.$$.fragment,l),c(D.$$.fragment,l),c(ll.$$.fragment,l),c(el.$$.fragment,l),c(al.$$.fragment,l),c(nl.$$.fragment,l),c(pl.$$.fragment,l),c(ml.$$.fragment,l),cs=!0)},o(l){y(T.$$.fragment,l),y(h.$$.fragment,l),y(I.$$.fragment,l),y(b.$$.fragment,l),y(Z.$$.fragment,l),y(W.$$.fragment,l),y(G.$$.fragment,l),y(k.$$.fragment,l),y(R.$$.fragment,l),y(E.$$.fragment,l),y(v.$$.fragment,l),y(N.$$.fragment,l),y(z.$$.fragment,l),y(Q.$$.fragment,l),y(Y.$$.fragment,l),y(H.$$.fragment,l),y(L.$$.fragment,l),y(D.$$.fragment,l),y(ll.$$.fragment,l),y(el.$$.fragment,l),y(al.$$.fragment,l),y(nl.$$.fragment,l),y(pl.$$.fragment,l),y(ml.$$.fragment,l),cs=!1},d(l){l&&(e(wl),e(cl),e(rl),e(Tl),e(d),e(dl),e(U),e(Ul),e(hl),e(u),e(ul),e(Il),e(bl),e(f),e(fl),e(C),e(Cl),e(A),e(Al),e(Zl),e(B),e(Bl),e(Wl),e(Gl),e(X),e(Xl),e(_),e(_l),e(kl),e(Rl),e(g),e(gl),e(El),e(x),e(xl),e(V),e(Vl),e(vl),e(Nl),e(zl),e($),e($l),e(Ql),e(F),e(Fl),e(Yl),e(S),e(Sl),e(Hl),e(q),e(ql),e(Ll),e(K),e(Kl),e(P),e(Pl),e(Dl),e(O),e(Ol),e(ls),e(sl),e(ss),e(es),e(tl),e(ts),e(as),e(ns),e(Ml),e(Ms),e(ps),e(ms),e(il),e(is),e(jl),e(js),e(Jl),e(Js),e(yl)),e(r),o(T,l),o(h,l),o(I,l),o(b,l),o(Z,l),o(W,l),o(G,l),o(k,l),o(R,l),o(E,l),o(v,l),o(N,l),o(z,l),o(Q,l),o(Y,l),o(H,l),o(L,l),o(D,l),o(ll,l),o(el,l),o(al,l),o(nl,l),o(pl,l),o(ml,l)}}}const Ls='{"title":"Efficiently run SetFit Models with Optimum","local":"efficiently-run-setfit-models-with-optimum","sections":[{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Create a performance benchmark","local":"2-create-a-performance-benchmark","sections":[],"depth":2},{"title":"3. Train/evaluate bge-small SetFit models","local":"3-trainevaluate-bge-small-setfit-models","sections":[],"depth":2},{"title":"4. Compressing with Optimum ONNX and CUDAExecutionProvider","local":"4-compressing-with-optimum-onnx-and-cudaexecutionprovider","sections":[],"depth":2}],"depth":1}';function Ks(ys){return Qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class se extends Fs{constructor(r){super(),Ys(this,r,Ks,qs,zs,{})}}export{se as component};
