import{s as ql,z as Ll,o as Al,n as zl}from"../chunks/scheduler.182ea377.js";import{S as Kl,i as Dl,g as i,s as n,r as o,A as Pl,h as p,f as a,c as s,j as qa,u as r,x as m,k as b,y as Ol,a as l,v as c,d,t as u,w as g}from"../chunks/index.abf12888.js";import{T as El}from"../chunks/Tip.230e2334.js";import{C as h}from"../chunks/CodeBlock.57fe6e13.js";import{D as en}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as M}from"../chunks/Heading.16916d63.js";function tn(it){let f,J='You’ll notice throughout the guide, we use <a href="/docs/diffusers/v0.22.3/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> and <a href="/docs/diffusers/v0.22.3/en/api/pipelines/stable_diffusion/image_variation#diffusers.StableDiffusionImageVariationPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a>, to save memory and increase inference speed. If you’re using PyTorch 2.0, it’s not necessary to call <a href="/docs/diffusers/v0.22.3/en/api/pipelines/stable_diffusion/image_variation#diffusers.StableDiffusionImageVariationPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on your pipeline because it’ll already be using PyTorch 2.0’s native <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a>.';return{c(){f=i("p"),f.innerHTML=J},l(y){f=p(y,"P",{"data-svelte-h":!0}),m(f)!=="svelte-a84xvz"&&(f.innerHTML=J)},m(y,W){l(y,f,W)},p:zl,d(y){y&&a(f)}}}function an(it){let f,J='It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in latent space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE. For example, in the <a href="#text-to-image-to-inpaint">Text-to-image-to-inpaint</a> section, Kandinsky 2.2 uses a different VAE class than the Stable Diffusion model so it won’t work. But if you use Stable Diffusion v1.5 for both pipelines, then you can keep everything in latent space because they both use <a href="/docs/diffusers/v0.22.3/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.';return{c(){f=i("p"),f.innerHTML=J},l(y){f=p(y,"P",{"data-svelte-h":!0}),m(f)!=="svelte-18odv2g"&&(f.innerHTML=J)},m(y,W){l(y,f,W)},p:zl,d(y){y&&a(f)}}}function ln(it){let f,J,y,W,F,mt,R,ot,x,La="Inpainting replaces or edits specific areas of an image. This makes it a useful tool for image restoration like removing defects and artifacts, or even replacing an image area with something entirely new. Inpainting relies on a mask to determine which regions of an image to fill in; the area to inpaint is represented by white pixels and the area to keep is represented by black pixels. The white pixels are filled in by the prompt.",rt,V,Aa="With 🤗 Diffusers, here is how you can do inpainting:",ct,$,Ka='<li>Load an inpainting checkpoint with the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> class. This’ll automatically detect the appropriate pipeline class to load based on the checkpoint:</li>',dt,C,ut,w,gt,T,Da="<li>Load the base and mask images:</li>",ft,Q,ht,j,Pa="<li>Create a prompt to inpaint the image with and pass it to the pipeline with the base and mask images:</li>",Mt,H,yt,U,Oa='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',bt,N,Jt,S,el="Throughout this guide, the mask image is provided in all of the code examples for convenience. You can inpaint on your own images, but you’ll need to create a mask image for it. Use the Space below to easily create a mask image.",Zt,E,tl="Upload a base image to inpaint on and use the sketch tool to draw a mask. Once you’re done, click <strong>Run</strong> to generate and download the mask image.",Wt,Z,al,wt,z,Tt,q,ll='<a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">Stable Diffusion Inpainting</a>, <a href="https://huggingface.co/diffusers/stable-diffusion-xl-1.0-inpainting-0.1" rel="nofollow">Stable Diffusion XL (SDXL) Inpainting</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder-inpaint" rel="nofollow">Kandinsky 2.2</a> are among the most popular models for inpainting. SDXL typically produces higher resolution images than Stable Diffusion v1.5, and Kandinsky 2.2 is also capable of generating high-quality images.',jt,L,Ut,A,nl="Stable Diffusion Inpainting is a latent diffusion model finetuned on 512x512 images on inpainting. It is a good starting point because it is relatively fast and generates good quality images. To use this model for inpainting, you’ll need to pass a prompt, base and mask image to the pipeline:",Gt,K,kt,D,Bt,P,sl='SDXL is a larger and more powerful version of Stable Diffusion v1.5. This model can follow a two-stage model process (though each model can also be used alone); the base model generates an image, and a refiner model takes that image and further enhances its details and quality. Take a look at the <a href="sdxl">SDXL</a> guide for a more comprehensive guide on how to use SDXL and configure it’s parameters.',vt,O,It,ee,Xt,te,il='The Kandinsky model family is similar to SDXL because it uses two models as well; the image prior model creates image embeddings, and the diffusion model generates images from them. You can load the image prior and diffusion model separately, but the easiest way to use Kandinsky 2.2 is to load it into the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> class which uses the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22InpaintCombinedPipeline">KandinskyV22InpaintCombinedPipeline</a> under the hood.',Yt,ae,_t,G,pl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-sdv1.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion Inpainting</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-sdxl.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion XL Inpainting</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-kandinsky.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Kandinsky 2.2 Inpainting</figcaption></div>',Ft,le,Rt,ne,ml="Image features - like quality and “creativity” - are dependent on pipeline parameters. Knowing what these parameters do is important for getting the results you want. Let’s take a look at the most important parameters and see how changing them affects the output.",xt,se,Vt,ie,ol="<code>strength</code> is a measure of how much noise is added to the base image, which influences how similar the output is to the base image.",$t,pe,rl="<li>📈 a high <code>strength</code> value means more noise is added to an image and the denoising process takes longer, but you’ll get higher quality images that are more different from the base image</li> <li>📉 a low <code>strength</code> value means less noise is added to an image and the denoising process is faster, but the image quality may not be as great and the generated image resembles the base image more</li>",Ct,me,Qt,k,cl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-0.6.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.6</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.8</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-1.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 1.0</figcaption></div>',Ht,oe,Nt,re,dl="<code>guidance_scale</code> affects how aligned the text prompt and generated image are.",St,ce,ul="<li>📈 a high <code>guidance_scale</code> value means the prompt and generated image are closely aligned, so the output is a stricter interpretation of the prompt</li> <li>📉 a low <code>guidance_scale</code> value means the prompt and generated image are more loosely aligned, so the output may be more varied from the prompt</li>",Et,de,gl="You can use <code>strength</code> and <code>guidance_scale</code> together for more control over how expressive the model is. For example, a combination high <code>strength</code> and <code>guidance_scale</code> values gives the model the most creative freedom.",zt,ue,qt,B,fl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-2.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 2.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 7.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-12.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 12.5</figcaption></div>',Lt,ge,At,fe,hl="A negative prompt assumes the opposite role of a prompt; it guides the model away from generating certain things in an image. This is useful for quickly improving image quality and preventing the model from generating things you don’t want.",Kt,he,Dt,v,Ml='<figure><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-negative.png"/> <figcaption class="text-center">negative_prompt = &quot;bad architecture, unstable, poor details, blurry&quot;</figcaption></figure>',Pt,Me,Ot,ye,yl='The <a href="/docs/diffusers/v0.22.3/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> (and other inpainting pipelines) generally changes the unmasked parts of an image to create a more natural transition between the masked and unmasked region. If this behavior is undesirable, you can force the unmasked area to remain the same. However, forcing the unmasked portion of the image to remain the same may result in some unusual transitions between the unmasked and masked areas.',ea,be,ta,Je,aa,Ze,bl='<a href="/docs/diffusers/v0.22.3/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> can be chained with other 🤗 Diffusers pipelines to edit their outputs. This is often useful for improving the output quality from your other diffusion pipelines, and if you’re using multiple pipelines, it can be more memory-efficient to chain them together to keep the outputs in latent space and reuse the same pipeline components.',la,We,na,we,Jl="Chaining a text-to-image and inpainting pipeline allows you to inpaint the generated image, and you don’t have to provide a base image to begin with. This makes it convenient to edit your favorite text-to-image outputs without having to generate an entirely new image.",sa,Te,Zl="Start with the text-to-image pipeline to create a castle:",ia,je,pa,Ue,Wl="Load the mask image of the output from above:",ma,Ge,oa,ke,wl="And let’s inpaint the masked area with a waterfall:",ra,Be,ca,I,Tl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-text-chain.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">text-to-image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-text-chain-out.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">inpaint</figcaption></div>',da,ve,ua,Ie,jl="You can also chain an inpainting pipeline before another pipeline like image-to-image or an upscaler to improve the quality.",ga,Xe,Ul="Begin by inpainting an image:",fa,Ye,ha,_e,Gl="Now let’s pass the image to another inpainting pipeline with SDXL’s refiner model to enhance the image details and quality:",Ma,Fe,ya,X,ba,Re,kl='Finally, you can pass this image to an image-to-image pipeline to put the finishing touches on it. It is more efficient to use the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method to reuse the existing pipeline components, and avoid unnecessarily loading all the pipeline components into memory again.',Ja,xe,Za,Y,Bl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-to-image-chain.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">inpaint</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-to-image-final.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image-to-image</figcaption></div>',Wa,Ve,vl="Image-to-image and inpainting are actually very similar tasks. Image-to-image generates a new image that resembles the existing provided image. Inpainting does the same thing, but it only transforms the image area defined by the mask and the rest of the image is unchanged. You can think of inpainting as a more precise tool for making specific changes and image-to-image has a broader scope for making more sweeping changes.",wa,$e,Ta,Ce,Il="Getting an image to look exactly the way you want is challenging because the denoising process is random. While you can control certain aspects of generation by configuring parameters like <code>negative_prompt</code>, there are better and more efficient methods for controlling image generation.",ja,Qe,Ua,He,Xl='Prompt weighting provides a quantifiable way to scale the representation of concepts in a prompt. You can use it to increase or decrease the magnitude of the text embedding vector for each concept in the prompt, which subsequently determines how much of each concept is generated. The <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library offers an intuitive syntax for scaling the prompt weights and generating the embeddings. Learn how to create the embeddings in the <a href="../using-diffusers/weighted_prompts">Prompt weighting</a> guide.',Ga,Ne,Yl='Once you’ve generated the embeddings, pass them to the <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter in the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a>. The embeddings replace the <code>prompt</code> parameter:',ka,Se,Ba,Ee,va,ze,_l="ControlNet models are used with other diffusion models like Stable Diffusion, and they provide an even more flexible and accurate way to control how an image is generated. A ControlNet accepts an additional conditioning image input that guides the diffusion model to preserve the features in it.",Ia,qe,Fl="For example, let’s condition an image with a ControlNet pretrained on inpaint images:",Xa,Le,Ya,Ae,Rl="Now generate an image from the base, mask and control images. You’ll notice features of the base image are strongly preserved in the generated image.",_a,Ke,Fa,De,xl='You can take this a step further and chain it with an image-to-image pipeline to apply a new <a href="https://huggingface.co/nitrosocke/elden-ring-diffusion" rel="nofollow">style</a>:',Ra,Pe,xa,_,Vl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet inpaint</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image-to-image</figcaption></div>',Va,Oe,$a,et,$l='It can be difficult and slow to run diffusion models if you’re resource constrained, but it doesn’t have to be with a few optimization tricks. One of the biggest (and easiest) optimizations you can enable is switching to memory-efficient attention. If you’re using PyTorch 2.0, <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a> is automatically enabled and you don’t need to do anything else. For non-PyTorch 2.0 users, you can install and use <a href="../optimization/xformers">xFormers</a>’s implementation of memory-efficient attention. Both options reduce memory usage and accelerate inference.',Ca,tt,Cl="You can also offload the model to the GPU to save even more memory:",Qa,at,Ha,lt,Ql='To speed-up your inference code even more, use <a href="../optimization/torch2.0#torch.compile"><code>torch_compile</code></a>. You should wrap <code>torch.compile</code> around the most intensive component in the pipeline which is typically the UNet:',Na,nt,Sa,st,Hl='Learn more in the <a href="../optimization/memory">Reduce memory usage</a> and <a href="../optimization/torch2.0">Torch 2.0</a> guides.',Ea,pt,za;return F=new M({props:{title:"Inpainting",local:"inpainting",headingTag:"h1"}}),R=new en({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"}]}}),C=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),w=new El({props:{$$slots:{default:[tn]},$$scope:{ctx:it}}}),Q=new h({props:{code:"aW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludC5wbmclMjIpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpLmNvbnZlcnQoJTIyUkdCJTIyKQ==",highlighted:`init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),H=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJsYWNrJTIwY2F0JTIwd2l0aCUyMGdsb3dpbmclMjBleWVzJTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwZGlzbmV5JTJDJTIwcGl4YXIlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyYmFkJTIwYW5hdG9teSUyQyUyMGRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMGRpc2ZpZ3VyZWQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`prompt = <span class="hljs-string">&quot;a black cat with glowing eyes, cute, adorable, disney, pixar, highly detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad anatomy, deformed, ugly, disfigured&quot;</span>
image = pipeline(prompt=prompt, negative_prompt=negative_prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),N=new M({props:{title:"Create a mask image",local:"create-a-mask-image",headingTag:"h2"}}),z=new M({props:{title:"Popular models",local:"popular-models",headingTag:"h2"}}),L=new M({props:{title:"Stable Diffusion Inpainting",local:"stable-diffusion-inpainting",headingTag:"h3"}}),K=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoOTIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),D=new M({props:{title:"Stable Diffusion XL (SDXL) Inpainting",local:"stable-diffusion-xl-sdxl-inpainting",headingTag:"h3"}}),O=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoOTIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ee=new M({props:{title:"Kandinsky 2.2 Inpainting",local:"kandinsky-22-inpainting",headingTag:"h3"}}),ae=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMGxvYWQlMjBiYXNlJTIwYW5kJTIwbWFzayUyMGltYWdlJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludC5wbmclMjIpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg5MiklMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),le=new M({props:{title:"Configure pipeline parameters",local:"configure-pipeline-parameters",headingTag:"h2"}}),se=new M({props:{title:"Strength",local:"strength",headingTag:"h3"}}),me=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNikuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.6</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),oe=new M({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),ue=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDIuNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, guidance_scale=<span class="hljs-number">2.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ge=new M({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),he=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmJhZCUyMGFyY2hpdGVjdHVyZSUyQyUyMHVuc3RhYmxlJTJDJTIwcG9vciUyMGRldGFpbHMlMkMlMjBibHVycnklMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad architecture, unstable, poor details, blurry&quot;</span>
image = pipeline(prompt=prompt, negative_prompt=negative_prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Me=new M({props:{title:"Preserve unmasked areas",local:"preserve-unmasked-areas",headingTag:"h2"}}),be=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
)
pipeline = pipeline.to(device)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
repainted_image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
repainted_image.save(<span class="hljs-string">&quot;repainted_image.png&quot;</span>)

<span class="hljs-comment"># Convert mask to grayscale NumPy array</span>
mask_image_arr = np.array(mask_image.convert(<span class="hljs-string">&quot;L&quot;</span>))
<span class="hljs-comment"># Add a channel dimension to the end of the grayscale mask</span>
mask_image_arr = mask_image_arr[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-comment"># Binarize the mask: 1s correspond to the pixels which are repainted</span>
mask_image_arr = mask_image_arr.astype(np.float32) / <span class="hljs-number">255.0</span>
mask_image_arr[mask_image_arr &lt; <span class="hljs-number">0.5</span>] = <span class="hljs-number">0</span>
mask_image_arr[mask_image_arr &gt;= <span class="hljs-number">0.5</span>] = <span class="hljs-number">1</span>

<span class="hljs-comment"># Take the masked pixels from the repainted image and the unmasked pixels from the initial image</span>
unmasked_unchanged_image_arr = (<span class="hljs-number">1</span> - mask_image_arr) * init_image + mask_image_arr * repainted_image
unmasked_unchanged_image = PIL.Image.fromarray(unmasked_unchanged_image_arr.<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>))
unmasked_unchanged_image.save(<span class="hljs-string">&quot;force_unmasked_unchanged.png&quot;</span>)`,wrap:!1}}),Je=new M({props:{title:"Chained inpainting pipelines",local:"chained-inpainting-pipelines",headingTag:"h2"}}),We=new M({props:{title:"Text-to-image-to-inpaint",local:"text-to-image-to-inpaint",headingTag:"h3"}}),je=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(<span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ge=new h({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludF90ZXh0LWNoYWluLW1hc2sucG5nJTIyKS5jb252ZXJ0KCUyMlJHQiUyMik=",highlighted:'mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_text-chain-mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)',wrap:!1}}),Be=new h({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhJTIwZmFudGFzeSUyMHdhdGVyZmFsbCUyQyUyMGNsb3VkeSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;digital painting of a fantasy waterfall, cloudy&quot;</span>
image = pipeline(prompt=prompt, image=image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ve=new M({props:{title:"Inpaint-to-image-to-image",local:"inpaint-to-image-to-image",headingTag:"h3"}}),Ye=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUyQyUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMGxvYWQlMjBiYXNlJTIwYW5kJTIwbWFzayUyMGltYWdlJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludC5wbmclMjIpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQSUwQSUyMyUyMHJlc2l6ZSUyMGltYWdlJTIwdG8lMjAxMDI0eDEwMjQlMjBmb3IlMjBTRFhMJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># resize image to 1024x1024 for SDXL</span>
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))`,wrap:!1}}),Fe=new h({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt=prompt, image=image, mask_image=mask_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),X=new El({props:{$$slots:{default:[an]},$$scope:{ctx:it}}}),xe=new h({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmUpJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipeline = AutoPipelineForImage2Image.from_pipe(pipeline)
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$e=new M({props:{title:"Control image generation",local:"control-image-generation",headingTag:"h2"}}),Qe=new M({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h3"}}),Se=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0X2VtZWJkcyUzRHByb21wdF9lbWJlZHMlMkMlMjAlMjMlMjBnZW5lcmF0ZWQlMjBmcm9tJTIwQ29tcGVsJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUyQyUyMCUyMyUyMGdlbmVyYXRlZCUyMGZyb20lMjBDb21wZWwlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt_emebds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    image=init_image,
    mask_image=mask_image
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ee=new M({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),Le=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionControlNetInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-comment"># load ControlNet</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

<span class="hljs-comment"># pass ControlNet to the pipeline</span>
pipeline = StableDiffusionControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-comment"># prepare control image</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_inpaint_condition</span>(<span class="hljs-params">init_image, mask_image</span>):
    init_image = np.array(init_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>
    mask_image = np.array(mask_image.convert(<span class="hljs-string">&quot;L&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>

    <span class="hljs-keyword">assert</span> init_image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>] == mask_image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>], <span class="hljs-string">&quot;image and image_mask must have the same image size&quot;</span>
    init_image[mask_image &gt; <span class="hljs-number">0.5</span>] = -<span class="hljs-number">1.0</span>  <span class="hljs-comment"># set as masked pixel</span>
    init_image = np.expand_dims(init_image, <span class="hljs-number">0</span>).transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    init_image = torch.from_numpy(init_image)
    <span class="hljs-keyword">return</span> init_image

control_image = make_inpaint_condition(init_image, mask_image)`,wrap:!1}}),Ke=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, control_image=control_image).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Pe=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybml0cm9zb2NrZSUyRmVsZGVuLXJpbmctZGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJlbGRlbiUyMHJpbmclMjBzdHlsZSUyMGNhc3RsZSUyMiUyMCUyMyUyMGluY2x1ZGUlMjB0aGUlMjB0b2tlbiUyMCUyMmVsZGVuJTIwcmluZyUyMHN0eWxlJTIyJTIwaW4lMjB0aGUlMjBwcm9tcHQlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJiYWQlMjBhcmNoaXRlY3R1cmUlMkMlMjBkZWZvcm1lZCUyQyUyMGRpc2ZpZ3VyZWQlMkMlMjBwb29yJTIwZGV0YWlscyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;nitrosocke/elden-ring-diffusion&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;elden ring style castle&quot;</span> <span class="hljs-comment"># include the token &quot;elden ring style&quot; in the prompt</span>
negative_prompt = <span class="hljs-string">&quot;bad architecture, deformed, disfigured, poor details&quot;</span>

image = pipeline(prompt, negative_prompt=negative_prompt, image=image).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Oe=new M({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),at=new h({props:{code:"JTJCJTIwcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMkIlMjBwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-addition">+ pipeline.enable_xformers_memory_efficient_attention()</span>
<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>`,wrap:!1}}),nt=new h({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:'pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){f=i("meta"),J=n(),y=i("p"),W=n(),o(F.$$.fragment),mt=n(),o(R.$$.fragment),ot=n(),x=i("p"),x.textContent=La,rt=n(),V=i("p"),V.textContent=Aa,ct=n(),$=i("ol"),$.innerHTML=Ka,dt=n(),o(C.$$.fragment),ut=n(),o(w.$$.fragment),gt=n(),T=i("ol"),T.innerHTML=Da,ft=n(),o(Q.$$.fragment),ht=n(),j=i("ol"),j.innerHTML=Pa,Mt=n(),o(H.$$.fragment),yt=n(),U=i("div"),U.innerHTML=Oa,bt=n(),o(N.$$.fragment),Jt=n(),S=i("p"),S.textContent=el,Zt=n(),E=i("p"),E.innerHTML=tl,Wt=n(),Z=i("iframe"),wt=n(),o(z.$$.fragment),Tt=n(),q=i("p"),q.innerHTML=ll,jt=n(),o(L.$$.fragment),Ut=n(),A=i("p"),A.textContent=nl,Gt=n(),o(K.$$.fragment),kt=n(),o(D.$$.fragment),Bt=n(),P=i("p"),P.innerHTML=sl,vt=n(),o(O.$$.fragment),It=n(),o(ee.$$.fragment),Xt=n(),te=i("p"),te.innerHTML=il,Yt=n(),o(ae.$$.fragment),_t=n(),G=i("div"),G.innerHTML=pl,Ft=n(),o(le.$$.fragment),Rt=n(),ne=i("p"),ne.textContent=ml,xt=n(),o(se.$$.fragment),Vt=n(),ie=i("p"),ie.innerHTML=ol,$t=n(),pe=i("ul"),pe.innerHTML=rl,Ct=n(),o(me.$$.fragment),Qt=n(),k=i("div"),k.innerHTML=cl,Ht=n(),o(oe.$$.fragment),Nt=n(),re=i("p"),re.innerHTML=dl,St=n(),ce=i("ul"),ce.innerHTML=ul,Et=n(),de=i("p"),de.innerHTML=gl,zt=n(),o(ue.$$.fragment),qt=n(),B=i("div"),B.innerHTML=fl,Lt=n(),o(ge.$$.fragment),At=n(),fe=i("p"),fe.textContent=hl,Kt=n(),o(he.$$.fragment),Dt=n(),v=i("div"),v.innerHTML=Ml,Pt=n(),o(Me.$$.fragment),Ot=n(),ye=i("p"),ye.innerHTML=yl,ea=n(),o(be.$$.fragment),ta=n(),o(Je.$$.fragment),aa=n(),Ze=i("p"),Ze.innerHTML=bl,la=n(),o(We.$$.fragment),na=n(),we=i("p"),we.textContent=Jl,sa=n(),Te=i("p"),Te.textContent=Zl,ia=n(),o(je.$$.fragment),pa=n(),Ue=i("p"),Ue.textContent=Wl,ma=n(),o(Ge.$$.fragment),oa=n(),ke=i("p"),ke.textContent=wl,ra=n(),o(Be.$$.fragment),ca=n(),I=i("div"),I.innerHTML=Tl,da=n(),o(ve.$$.fragment),ua=n(),Ie=i("p"),Ie.textContent=jl,ga=n(),Xe=i("p"),Xe.textContent=Ul,fa=n(),o(Ye.$$.fragment),ha=n(),_e=i("p"),_e.textContent=Gl,Ma=n(),o(Fe.$$.fragment),ya=n(),o(X.$$.fragment),ba=n(),Re=i("p"),Re.innerHTML=kl,Ja=n(),o(xe.$$.fragment),Za=n(),Y=i("div"),Y.innerHTML=Bl,Wa=n(),Ve=i("p"),Ve.textContent=vl,wa=n(),o($e.$$.fragment),Ta=n(),Ce=i("p"),Ce.innerHTML=Il,ja=n(),o(Qe.$$.fragment),Ua=n(),He=i("p"),He.innerHTML=Xl,Ga=n(),Ne=i("p"),Ne.innerHTML=Yl,ka=n(),o(Se.$$.fragment),Ba=n(),o(Ee.$$.fragment),va=n(),ze=i("p"),ze.textContent=_l,Ia=n(),qe=i("p"),qe.textContent=Fl,Xa=n(),o(Le.$$.fragment),Ya=n(),Ae=i("p"),Ae.textContent=Rl,_a=n(),o(Ke.$$.fragment),Fa=n(),De=i("p"),De.innerHTML=xl,Ra=n(),o(Pe.$$.fragment),xa=n(),_=i("div"),_.innerHTML=Vl,Va=n(),o(Oe.$$.fragment),$a=n(),et=i("p"),et.innerHTML=$l,Ca=n(),tt=i("p"),tt.textContent=Cl,Qa=n(),o(at.$$.fragment),Ha=n(),lt=i("p"),lt.innerHTML=Ql,Na=n(),o(nt.$$.fragment),Sa=n(),st=i("p"),st.innerHTML=Hl,Ea=n(),pt=i("p"),this.h()},l(e){const t=Pl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(a),J=s(e),y=p(e,"P",{}),qa(y).forEach(a),W=s(e),r(F.$$.fragment,e),mt=s(e),r(R.$$.fragment,e),ot=s(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1vjeoqc"&&(x.textContent=La),rt=s(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1t7j32f"&&(V.textContent=Aa),ct=s(e),$=p(e,"OL",{"data-svelte-h":!0}),m($)!=="svelte-1pu1m0g"&&($.innerHTML=Ka),dt=s(e),r(C.$$.fragment,e),ut=s(e),r(w.$$.fragment,e),gt=s(e),T=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(T)!=="svelte-1jtpcib"&&(T.innerHTML=Da),ft=s(e),r(Q.$$.fragment,e),ht=s(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(j)!=="svelte-1przvba"&&(j.innerHTML=Pa),Mt=s(e),r(H.$$.fragment,e),yt=s(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(U)!=="svelte-xste8g"&&(U.innerHTML=Oa),bt=s(e),r(N.$$.fragment,e),Jt=s(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-ic55ez"&&(S.textContent=el),Zt=s(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-87gmw5"&&(E.innerHTML=tl),Wt=s(e),Z=p(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),qa(Z).forEach(a),wt=s(e),r(z.$$.fragment,e),Tt=s(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-xt7vx6"&&(q.innerHTML=ll),jt=s(e),r(L.$$.fragment,e),Ut=s(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-siyv04"&&(A.textContent=nl),Gt=s(e),r(K.$$.fragment,e),kt=s(e),r(D.$$.fragment,e),Bt=s(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1grw9dr"&&(P.innerHTML=sl),vt=s(e),r(O.$$.fragment,e),It=s(e),r(ee.$$.fragment,e),Xt=s(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1h74vb4"&&(te.innerHTML=il),Yt=s(e),r(ae.$$.fragment,e),_t=s(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(G)!=="svelte-xc2o0t"&&(G.innerHTML=pl),Ft=s(e),r(le.$$.fragment,e),Rt=s(e),ne=p(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-13ocbdc"&&(ne.textContent=ml),xt=s(e),r(se.$$.fragment,e),Vt=s(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-qcb5md"&&(ie.innerHTML=ol),$t=s(e),pe=p(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-vvcg88"&&(pe.innerHTML=rl),Ct=s(e),r(me.$$.fragment,e),Qt=s(e),k=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(k)!=="svelte-1vmqp5s"&&(k.innerHTML=cl),Ht=s(e),r(oe.$$.fragment,e),Nt=s(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-zcb81p"&&(re.innerHTML=dl),St=s(e),ce=p(e,"UL",{"data-svelte-h":!0}),m(ce)!=="svelte-cnggx4"&&(ce.innerHTML=ul),Et=s(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-196id8d"&&(de.innerHTML=gl),zt=s(e),r(ue.$$.fragment,e),qt=s(e),B=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(B)!=="svelte-1cwhpu7"&&(B.innerHTML=fl),Lt=s(e),r(ge.$$.fragment,e),At=s(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1ru9kar"&&(fe.textContent=hl),Kt=s(e),r(he.$$.fragment,e),Dt=s(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-15bd4ta"&&(v.innerHTML=Ml),Pt=s(e),r(Me.$$.fragment,e),Ot=s(e),ye=p(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-14f0lj"&&(ye.innerHTML=yl),ea=s(e),r(be.$$.fragment,e),ta=s(e),r(Je.$$.fragment,e),aa=s(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1iohl5s"&&(Ze.innerHTML=bl),la=s(e),r(We.$$.fragment,e),na=s(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1uqw6jr"&&(we.textContent=Jl),sa=s(e),Te=p(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1kzp8f0"&&(Te.textContent=Zl),ia=s(e),r(je.$$.fragment,e),pa=s(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-yqefj6"&&(Ue.textContent=Wl),ma=s(e),r(Ge.$$.fragment,e),oa=s(e),ke=p(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-ua49j1"&&(ke.textContent=wl),ra=s(e),r(Be.$$.fragment,e),ca=s(e),I=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(I)!=="svelte-15ens2s"&&(I.innerHTML=Tl),da=s(e),r(ve.$$.fragment,e),ua=s(e),Ie=p(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-16qmg1v"&&(Ie.textContent=jl),ga=s(e),Xe=p(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-1du3njh"&&(Xe.textContent=Ul),fa=s(e),r(Ye.$$.fragment,e),ha=s(e),_e=p(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-j4alid"&&(_e.textContent=Gl),Ma=s(e),r(Fe.$$.fragment,e),ya=s(e),r(X.$$.fragment,e),ba=s(e),Re=p(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1gan6eg"&&(Re.innerHTML=kl),Ja=s(e),r(xe.$$.fragment,e),Za=s(e),Y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(Y)!=="svelte-1lbnv8n"&&(Y.innerHTML=Bl),Wa=s(e),Ve=p(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-1fd5b22"&&(Ve.textContent=vl),wa=s(e),r($e.$$.fragment,e),Ta=s(e),Ce=p(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1gc804h"&&(Ce.innerHTML=Il),ja=s(e),r(Qe.$$.fragment,e),Ua=s(e),He=p(e,"P",{"data-svelte-h":!0}),m(He)!=="svelte-6zcpc0"&&(He.innerHTML=Xl),Ga=s(e),Ne=p(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1igmblf"&&(Ne.innerHTML=Yl),ka=s(e),r(Se.$$.fragment,e),Ba=s(e),r(Ee.$$.fragment,e),va=s(e),ze=p(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-3rypf9"&&(ze.textContent=_l),Ia=s(e),qe=p(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1x7ee8u"&&(qe.textContent=Fl),Xa=s(e),r(Le.$$.fragment,e),Ya=s(e),Ae=p(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-db3ja"&&(Ae.textContent=Rl),_a=s(e),r(Ke.$$.fragment,e),Fa=s(e),De=p(e,"P",{"data-svelte-h":!0}),m(De)!=="svelte-iaoixt"&&(De.innerHTML=xl),Ra=s(e),r(Pe.$$.fragment,e),xa=s(e),_=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(_)!=="svelte-9rfwwm"&&(_.innerHTML=Vl),Va=s(e),r(Oe.$$.fragment,e),$a=s(e),et=p(e,"P",{"data-svelte-h":!0}),m(et)!=="svelte-1f04pnr"&&(et.innerHTML=$l),Ca=s(e),tt=p(e,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-kpc34x"&&(tt.textContent=Cl),Qa=s(e),r(at.$$.fragment,e),Ha=s(e),lt=p(e,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1co8a20"&&(lt.innerHTML=Ql),Na=s(e),r(nt.$$.fragment,e),Sa=s(e),st=p(e,"P",{"data-svelte-h":!0}),m(st)!=="svelte-ve8eie"&&(st.innerHTML=Hl),Ea=s(e),pt=p(e,"P",{}),qa(pt).forEach(a),this.h()},h(){b(f,"name","hf:doc:metadata"),b(f,"content",nn),b(T,"start","2"),b(j,"start","3"),b(U,"class","flex gap-4"),Ll(Z.src,al="https://stevhliu-inpaint-mask-maker.hf.space")||b(Z,"src",al),b(Z,"frameborder","0"),b(Z,"width","850"),b(Z,"height","450"),b(G,"class","flex flex-row gap-4"),b(k,"class","flex flex-row gap-4"),b(B,"class","flex flex-row gap-4"),b(v,"class","flex justify-center"),b(I,"class","flex flex-row gap-4"),b(Y,"class","flex flex-row gap-4"),b(_,"class","flex flex-row gap-4")},m(e,t){Ol(document.head,f),l(e,J,t),l(e,y,t),l(e,W,t),c(F,e,t),l(e,mt,t),c(R,e,t),l(e,ot,t),l(e,x,t),l(e,rt,t),l(e,V,t),l(e,ct,t),l(e,$,t),l(e,dt,t),c(C,e,t),l(e,ut,t),c(w,e,t),l(e,gt,t),l(e,T,t),l(e,ft,t),c(Q,e,t),l(e,ht,t),l(e,j,t),l(e,Mt,t),c(H,e,t),l(e,yt,t),l(e,U,t),l(e,bt,t),c(N,e,t),l(e,Jt,t),l(e,S,t),l(e,Zt,t),l(e,E,t),l(e,Wt,t),l(e,Z,t),l(e,wt,t),c(z,e,t),l(e,Tt,t),l(e,q,t),l(e,jt,t),c(L,e,t),l(e,Ut,t),l(e,A,t),l(e,Gt,t),c(K,e,t),l(e,kt,t),c(D,e,t),l(e,Bt,t),l(e,P,t),l(e,vt,t),c(O,e,t),l(e,It,t),c(ee,e,t),l(e,Xt,t),l(e,te,t),l(e,Yt,t),c(ae,e,t),l(e,_t,t),l(e,G,t),l(e,Ft,t),c(le,e,t),l(e,Rt,t),l(e,ne,t),l(e,xt,t),c(se,e,t),l(e,Vt,t),l(e,ie,t),l(e,$t,t),l(e,pe,t),l(e,Ct,t),c(me,e,t),l(e,Qt,t),l(e,k,t),l(e,Ht,t),c(oe,e,t),l(e,Nt,t),l(e,re,t),l(e,St,t),l(e,ce,t),l(e,Et,t),l(e,de,t),l(e,zt,t),c(ue,e,t),l(e,qt,t),l(e,B,t),l(e,Lt,t),c(ge,e,t),l(e,At,t),l(e,fe,t),l(e,Kt,t),c(he,e,t),l(e,Dt,t),l(e,v,t),l(e,Pt,t),c(Me,e,t),l(e,Ot,t),l(e,ye,t),l(e,ea,t),c(be,e,t),l(e,ta,t),c(Je,e,t),l(e,aa,t),l(e,Ze,t),l(e,la,t),c(We,e,t),l(e,na,t),l(e,we,t),l(e,sa,t),l(e,Te,t),l(e,ia,t),c(je,e,t),l(e,pa,t),l(e,Ue,t),l(e,ma,t),c(Ge,e,t),l(e,oa,t),l(e,ke,t),l(e,ra,t),c(Be,e,t),l(e,ca,t),l(e,I,t),l(e,da,t),c(ve,e,t),l(e,ua,t),l(e,Ie,t),l(e,ga,t),l(e,Xe,t),l(e,fa,t),c(Ye,e,t),l(e,ha,t),l(e,_e,t),l(e,Ma,t),c(Fe,e,t),l(e,ya,t),c(X,e,t),l(e,ba,t),l(e,Re,t),l(e,Ja,t),c(xe,e,t),l(e,Za,t),l(e,Y,t),l(e,Wa,t),l(e,Ve,t),l(e,wa,t),c($e,e,t),l(e,Ta,t),l(e,Ce,t),l(e,ja,t),c(Qe,e,t),l(e,Ua,t),l(e,He,t),l(e,Ga,t),l(e,Ne,t),l(e,ka,t),c(Se,e,t),l(e,Ba,t),c(Ee,e,t),l(e,va,t),l(e,ze,t),l(e,Ia,t),l(e,qe,t),l(e,Xa,t),c(Le,e,t),l(e,Ya,t),l(e,Ae,t),l(e,_a,t),c(Ke,e,t),l(e,Fa,t),l(e,De,t),l(e,Ra,t),c(Pe,e,t),l(e,xa,t),l(e,_,t),l(e,Va,t),c(Oe,e,t),l(e,$a,t),l(e,et,t),l(e,Ca,t),l(e,tt,t),l(e,Qa,t),c(at,e,t),l(e,Ha,t),l(e,lt,t),l(e,Na,t),c(nt,e,t),l(e,Sa,t),l(e,st,t),l(e,Ea,t),l(e,pt,t),za=!0},p(e,[t]){const Nl={};t&2&&(Nl.$$scope={dirty:t,ctx:e}),w.$set(Nl);const Sl={};t&2&&(Sl.$$scope={dirty:t,ctx:e}),X.$set(Sl)},i(e){za||(d(F.$$.fragment,e),d(R.$$.fragment,e),d(C.$$.fragment,e),d(w.$$.fragment,e),d(Q.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(z.$$.fragment,e),d(L.$$.fragment,e),d(K.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(me.$$.fragment,e),d(oe.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(Je.$$.fragment,e),d(We.$$.fragment,e),d(je.$$.fragment,e),d(Ge.$$.fragment,e),d(Be.$$.fragment,e),d(ve.$$.fragment,e),d(Ye.$$.fragment,e),d(Fe.$$.fragment,e),d(X.$$.fragment,e),d(xe.$$.fragment,e),d($e.$$.fragment,e),d(Qe.$$.fragment,e),d(Se.$$.fragment,e),d(Ee.$$.fragment,e),d(Le.$$.fragment,e),d(Ke.$$.fragment,e),d(Pe.$$.fragment,e),d(Oe.$$.fragment,e),d(at.$$.fragment,e),d(nt.$$.fragment,e),za=!0)},o(e){u(F.$$.fragment,e),u(R.$$.fragment,e),u(C.$$.fragment,e),u(w.$$.fragment,e),u(Q.$$.fragment,e),u(H.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(me.$$.fragment,e),u(oe.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(We.$$.fragment,e),u(je.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(ve.$$.fragment,e),u(Ye.$$.fragment,e),u(Fe.$$.fragment,e),u(X.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Qe.$$.fragment,e),u(Se.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(Ke.$$.fragment,e),u(Pe.$$.fragment,e),u(Oe.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),za=!1},d(e){e&&(a(J),a(y),a(W),a(mt),a(ot),a(x),a(rt),a(V),a(ct),a($),a(dt),a(ut),a(gt),a(T),a(ft),a(ht),a(j),a(Mt),a(yt),a(U),a(bt),a(Jt),a(S),a(Zt),a(E),a(Wt),a(Z),a(wt),a(Tt),a(q),a(jt),a(Ut),a(A),a(Gt),a(kt),a(Bt),a(P),a(vt),a(It),a(Xt),a(te),a(Yt),a(_t),a(G),a(Ft),a(Rt),a(ne),a(xt),a(Vt),a(ie),a($t),a(pe),a(Ct),a(Qt),a(k),a(Ht),a(Nt),a(re),a(St),a(ce),a(Et),a(de),a(zt),a(qt),a(B),a(Lt),a(At),a(fe),a(Kt),a(Dt),a(v),a(Pt),a(Ot),a(ye),a(ea),a(ta),a(aa),a(Ze),a(la),a(na),a(we),a(sa),a(Te),a(ia),a(pa),a(Ue),a(ma),a(oa),a(ke),a(ra),a(ca),a(I),a(da),a(ua),a(Ie),a(ga),a(Xe),a(fa),a(ha),a(_e),a(Ma),a(ya),a(ba),a(Re),a(Ja),a(Za),a(Y),a(Wa),a(Ve),a(wa),a(Ta),a(Ce),a(ja),a(Ua),a(He),a(Ga),a(Ne),a(ka),a(Ba),a(va),a(ze),a(Ia),a(qe),a(Xa),a(Ya),a(Ae),a(_a),a(Fa),a(De),a(Ra),a(xa),a(_),a(Va),a($a),a(et),a(Ca),a(tt),a(Qa),a(Ha),a(lt),a(Na),a(Sa),a(st),a(Ea),a(pt)),a(f),g(F,e),g(R,e),g(C,e),g(w,e),g(Q,e),g(H,e),g(N,e),g(z,e),g(L,e),g(K,e),g(D,e),g(O,e),g(ee,e),g(ae,e),g(le,e),g(se,e),g(me,e),g(oe,e),g(ue,e),g(ge,e),g(he,e),g(Me,e),g(be,e),g(Je,e),g(We,e),g(je,e),g(Ge,e),g(Be,e),g(ve,e),g(Ye,e),g(Fe,e),g(X,e),g(xe,e),g($e,e),g(Qe,e),g(Se,e),g(Ee,e),g(Le,e),g(Ke,e),g(Pe,e),g(Oe,e),g(at,e),g(nt,e)}}}const nn='{"title":"Inpainting","local":"inpainting","sections":[{"title":"Create a mask image","local":"create-a-mask-image","sections":[],"depth":2},{"title":"Popular models","local":"popular-models","sections":[{"title":"Stable Diffusion Inpainting","local":"stable-diffusion-inpainting","sections":[],"depth":3},{"title":"Stable Diffusion XL (SDXL) Inpainting","local":"stable-diffusion-xl-sdxl-inpainting","sections":[],"depth":3},{"title":"Kandinsky 2.2 Inpainting","local":"kandinsky-22-inpainting","sections":[],"depth":3}],"depth":2},{"title":"Configure pipeline parameters","local":"configure-pipeline-parameters","sections":[{"title":"Strength","local":"strength","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3}],"depth":2},{"title":"Preserve unmasked areas","local":"preserve-unmasked-areas","sections":[],"depth":2},{"title":"Chained inpainting pipelines","local":"chained-inpainting-pipelines","sections":[{"title":"Text-to-image-to-inpaint","local":"text-to-image-to-inpaint","sections":[],"depth":3},{"title":"Inpaint-to-image-to-image","local":"inpaint-to-image-to-image","sections":[],"depth":3}],"depth":2},{"title":"Control image generation","local":"control-image-generation","sections":[{"title":"Prompt weighting","local":"prompt-weighting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2}],"depth":1}';function sn(it){return Al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class un extends Kl{constructor(f){super(),Dl(this,f,sn,ln,ql,{})}}export{un as component};
