import{s as Jl,o as wl}from"../chunks/scheduler.00bde567.js";import{S as Tl,i as hl,g as r,s,r as o,A as bl,h as i,f as t,c as n,j as ul,u as p,x as c,k as jl,y as fl,a,v as M,d as m,t as d,w as y,m as Ul,n as Il}from"../chunks/index.752e2ff6.js";import{T as gl}from"../chunks/Tip.6fda87e9.js";import{C as j}from"../chunks/CodeBlock.e62cd1dc.js";import{H as ne}from"../chunks/Heading.476d3364.js";function _l(re){let u;return{c(){u=Ul(`Trackers built in Accelerate will automatically execute on the correct process, 
  so if a tracker is only meant to be ran on the main process it will do so 
  automatically.`)},l(J){u=Il(J,`Trackers built in Accelerate will automatically execute on the correct process, 
  so if a tracker is only meant to be ran on the main process it will do so 
  automatically.`)},m(J,T){a(J,u,T)},d(J){J&&t(u)}}}function Bl(re){let u,J,T,ie,h,ce,b,Se=`There are a large number of experiment tracking API’s available, however getting them all to work with in a multi-processing environment can oftentimes be complex.
🤗 Accelerate provides a general tracking API that can be used to log useful items during your script through <code>Accelerator.log()</code>`,oe,f,pe,U,Le="Currently <code>Accelerate</code> supports six trackers out-of-the-box:",Me,I,Ke="<li>TensorBoard</li> <li>WandB</li> <li>CometML</li> <li>Aim</li> <li>MLFlow</li> <li>ClearML</li>",me,g,Pe="To use any of them, pass in the selected type(s) to the <code>log_with</code> parameter in <code>Accelerate</code>:",de,_,ye,B,De="At the start of your experiment <code>Accelerator.init_trackers()</code> should be used to setup your project, and potentially add any experiment hyperparameters to be logged:",ue,C,je,k,Oe=`When you are ready to log any data, <code>Accelerator.log()</code> should be used.
A <code>step</code> can also be passed in to correlate the data with a particular step in the training loop.`,Je,$,we,A,el="Once you’ve finished training, make sure to run <code>Accelerator.end_training()</code> so that all the trackers can run their finish functionalities if they have any.",Te,Z,he,v,ll="A full example is below:",be,W,fe,G,tl=`If a tracker requires a directory to save data to, such as <code>TensorBoard</code>, then pass the directory path to <code>project_dir</code>. The <code>project_dir</code> parameter is useful
when there are other configurations to be combined with in the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> data class. For example, you can save the TensorBoard data to <code>project_dir</code> and everything else can be logged in the <code>logging_dir</code> parameter of [<code>~utils.ProjectConfiguration</code>:`,Ue,X,Ie,Y,ge,R,al=`To implement a new tracker to be used in <code>Accelerator</code>, a new one can be made through implementing the <code>GeneralTracker</code> class.
Every tracker must implement three functions and have three properties:`,_e,V,sl="<li><p><code>__init__</code>:</p> <ul><li>Should store a <code>run_name</code> and initialize the tracker API of the integrated library.</li> <li>If a tracker stores their data locally (such as TensorBoard), a <code>logging_dir</code> parameter can be added.</li></ul></li> <li><p><code>store_init_configuration</code>:</p> <ul><li>Should take in a <code>values</code> dictionary and store them as a one-time experiment configuration</li></ul></li> <li><p><code>log</code>:</p> <ul><li>Should take in a <code>values</code> dictionary and a <code>step</code>, and should log them to the run</li></ul></li> <li><p><code>name</code> (<code>str</code>):</p> <ul><li>A unique string name for the tracker, such as <code>&quot;wandb&quot;</code> for the wandb tracker.</li> <li>This will be used for interacting with this tracker specifically</li></ul></li> <li><p><code>requires_logging_directory</code> (<code>bool</code>):</p> <ul><li>Whether a <code>logging_dir</code> is needed for this particular tracker and if it uses one.</li></ul></li> <li><p><code>tracker</code>:</p> <ul><li>This should be implemented as a <code>@property</code> function</li> <li>Should return the internal tracking mechanism the library uses, such as the <code>run</code> object for <code>wandb</code>.</li></ul></li>",Be,H,nl='Each method should also utilize the <a href="/docs/accelerate/main/en/package_reference/state#accelerate.PartialState">state.PartialState</a> class if the logger should only be executed on the main process for instance.',Ce,N,rl=`A brief example can be seen below with an integration with Weights and Biases, containing only the relevant information and logging just on
the main process:`,ke,Q,$e,x,il=`When you are ready to build your <code>Accelerator</code> object, pass in an <strong>instance</strong> of your tracker to <code>Accelerator.log_with</code> to have it automatically
be used with the API:`,Ae,F,Ze,E,cl="These also can be mixed with existing trackers, including with <code>&quot;all&quot;</code>:",ve,z,We,q,Ge,S,ol=`If some custom interactions with a tracker might be wanted directly, you can quickly access one using the
<a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.get_tracker">Accelerator.get_tracker()</a> method. Just pass in the string corresponding to a tracker’s <code>.name</code> attribute
and it will return that tracker on the main process.`,Xe,L,pl="This example shows doing so with wandb:",Ye,K,Re,P,Ml="From there you can interact with <code>wandb</code>’s <code>run</code> object like normal:",Ve,D,He,w,Ne,O,ml=`If you want to truly remove Accelerate’s wrapping entirely, you can
achieve the same outcome with:`,Qe,ee,xe,le,Fe,te,dl="If a library has an API that does not follow a strict <code>.log</code> with an overall dictionary such as Neptune.AI, logging can be done manually under an <code>if accelerator.is_main_process</code> statement:",Ee,ae,ze,se,qe;return h=new ne({props:{title:"Tracking",local:"tracking",headingTag:"h1"}}),f=new ne({props:{title:"Integrated Trackers",local:"integrated-trackers",headingTag:"h2"}}),_=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwTG9nZ2VyVHlwZSUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlMjJhbGwlMjIpJTIwJTIwJTIzJTIwRm9yJTIwYWxsJTIwYXZhaWxhYmxlJTIwdHJhY2tlcnMlMjBpbiUyMHRoZSUyMGVudmlyb25tZW50JTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihsb2dfd2l0aCUzRCUyMndhbmRiJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlNUIlMjJ3YW5kYiUyMiUyQyUyMExvZ2dlclR5cGUuVEVOU09SQk9BUkQlNUQp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> LoggerType

accelerator = Accelerator(log_with=<span class="hljs-string">&quot;all&quot;</span>)  <span class="hljs-comment"># For all available trackers in the environment</span>
accelerator = Accelerator(log_with=<span class="hljs-string">&quot;wandb&quot;</span>)
accelerator = Accelerator(log_with=[<span class="hljs-string">&quot;wandb&quot;</span>, LoggerType.TENSORBOARD])`,wrap:!1}}),C=new j({props:{code:"aHBzJTIwJTNEJTIwJTdCJTIybnVtX2l0ZXJhdGlvbnMlMjIlM0ElMjA1JTJDJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTIlN0QlMEFhY2NlbGVyYXRvci5pbml0X3RyYWNrZXJzKCUyMm15X3Byb2plY3QlMjIlMkMlMjBjb25maWclM0RocHMp",highlighted:`hps = {<span class="hljs-string">&quot;num_iterations&quot;</span>: <span class="hljs-number">5</span>, <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">1e-2</span>}
accelerator.init_trackers(<span class="hljs-string">&quot;my_project&quot;</span>, config=hps)`,wrap:!1}}),$=new j({props:{code:"YWNjZWxlcmF0b3IubG9nKCU3QiUyMnRyYWluX2xvc3MlMjIlM0ElMjAxLjEyJTJDJTIwJTIydmFsaWRfbG9zcyUyMiUzQSUyMDAuOCU3RCUyQyUyMHN0ZXAlM0QxKQ==",highlighted:'accelerator.log({<span class="hljs-string">&quot;train_loss&quot;</span>: <span class="hljs-number">1.12</span>, <span class="hljs-string">&quot;valid_loss&quot;</span>: <span class="hljs-number">0.8</span>}, step=<span class="hljs-number">1</span>)',wrap:!1}}),Z=new j({props:{code:"YWNjZWxlcmF0b3IuZW5kX3RyYWluaW5nKCk=",highlighted:"accelerator.end_training()",wrap:!1}}),W=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlMjJhbGwlMjIpJTBBY29uZmlnJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIybnVtX2l0ZXJhdGlvbnMlMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTIlMkMlMEElMjAlMjAlMjAlMjAlMjJsb3NzX2Z1bmN0aW9uJTIyJTNBJTIwc3RyKG15X2xvc3NfZnVuY3Rpb24pJTJDJTBBJTdEJTBBJTBBYWNjZWxlcmF0b3IuaW5pdF90cmFja2VycyglMjJleGFtcGxlX3Byb2plY3QlMjIlMkMlMjBjb25maWclM0Rjb25maWcpJTBBJTBBbXlfbW9kZWwlMkMlMjBteV9vcHRpbWl6ZXIlMkMlMjBteV90cmFpbmluZ19kYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0ZS5wcmVwYXJlKG15X21vZGVsJTJDJTIwbXlfb3B0aW1pemVyJTJDJTIwbXlfdHJhaW5pbmdfZGF0YWxvYWRlciklMEFkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEFteV9tb2RlbC50byhkZXZpY2UpJTBBJTBBZm9yJTIwaXRlcmF0aW9uJTIwaW4lMjBjb25maWclNUIlMjJudW1faXRlcmF0aW9ucyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMHN0ZXAlMkMlMjBiYXRjaCUyMGluJTIwbXlfdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG15X29wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBteV9tb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG15X2xvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IubG9nKCU3QiUyMnRyYWluaW5nX2xvc3MlMjIlM0ElMjBsb3NzJTdEJTJDJTIwc3RlcCUzRHN0ZXApJTBBYWNjZWxlcmF0b3IuZW5kX3RyYWluaW5nKCk=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator(log_with=<span class="hljs-string">&quot;all&quot;</span>)
config = {
    <span class="hljs-string">&quot;num_iterations&quot;</span>: <span class="hljs-number">5</span>,
    <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">1e-2</span>,
    <span class="hljs-string">&quot;loss_function&quot;</span>: <span class="hljs-built_in">str</span>(my_loss_function),
}

accelerator.init_trackers(<span class="hljs-string">&quot;example_project&quot;</span>, config=config)

my_model, my_optimizer, my_training_dataloader = accelerate.prepare(my_model, my_optimizer, my_training_dataloader)
device = accelerator.device
my_model.to(device)

<span class="hljs-keyword">for</span> iteration <span class="hljs-keyword">in</span> config[<span class="hljs-string">&quot;num_iterations&quot;</span>]:
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> my_training_dataloader:
        my_optimizer.zero_grad()
        inputs, targets = batch
        inputs = inputs.to(device)
        targets = targets.to(device)
        outputs = my_model(inputs)
        loss = my_loss_function(outputs, targets)
        accelerator.backward(loss)
        my_optimizer.step()
        accelerator.log({<span class="hljs-string">&quot;training_loss&quot;</span>: loss}, step=step)
accelerator.end_training()`,wrap:!1}}),X=new j({props:{code:"YWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihsb2dfd2l0aCUzRCUyMnRlbnNvcmJvYXJkJTIyJTJDJTIwcHJvamVjdF9kaXIlM0QlMjIuJTIyKSUwQSUwQSUyMyUyMHVzZSUyMHdpdGglMjBQcm9qZWN0Q29uZmlndXJhdGlvbiUwQWNvbmZpZyUyMCUzRCUyMFByb2plY3RDb25maWd1cmF0aW9uKHByb2plY3RfZGlyJTNEJTIyLiUyMiUyQyUyMGxvZ2dpbmdfZGlyJTNEJTIyYW5vdGhlciUyRmRpcmVjdG9yeSUyMiklMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGxvZ193aXRoJTNEJTIydGVuc29yYm9hcmQlMjIlMkMlMjBwcm9qZWN0X2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`accelerator = Accelerator(log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>, project_dir=<span class="hljs-string">&quot;.&quot;</span>)

<span class="hljs-comment"># use with ProjectConfiguration</span>
config = ProjectConfiguration(project_dir=<span class="hljs-string">&quot;.&quot;</span>, logging_dir=<span class="hljs-string">&quot;another/directory&quot;</span>)
accelerator = Accelerator(log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>, project_config=config)`,wrap:!1}}),Y=new ne({props:{title:"Implementing Custom Trackers",local:"implementing-custom-trackers",headingTag:"h2"}}),Q=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudHJhY2tpbmclMjBpbXBvcnQlMjBHZW5lcmFsVHJhY2tlciUyQyUyMG9uX21haW5fcHJvY2VzcyUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUwQSUwQWltcG9ydCUyMHdhbmRiJTBBJTBBJTBBY2xhc3MlMjBNeUN1c3RvbVRyYWNrZXIoR2VuZXJhbFRyYWNrZXIpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMndhbmRiJTIyJTBBJTIwJTIwJTIwJTIwcmVxdWlyZXNfbG9nZ2luZ19kaXJlY3RvcnklMjAlM0QlMjBGYWxzZSUwQSUwQSUyMCUyMCUyMCUyMCU0MG9uX21haW5fcHJvY2VzcyUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBydW5fbmFtZSUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnJ1bl9uYW1lJTIwJTNEJTIwcnVuX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBydW4lMjAlM0QlMjB3YW5kYi5pbml0KHNlbGYucnVuX25hbWUpJTBBJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjB0cmFja2VyKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5ydW4ucnVuJTBBJTBBJTIwJTIwJTIwJTIwJTQwb25fbWFpbl9wcm9jZXNzJTBBJTIwJTIwJTIwJTIwZGVmJTIwc3RvcmVfaW5pdF9jb25maWd1cmF0aW9uKHNlbGYlMkMlMjB2YWx1ZXMlM0ElMjBkaWN0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdhbmRiLmNvbmZpZyh2YWx1ZXMpJTBBJTBBJTIwJTIwJTIwJTIwJTQwb25fbWFpbl9wcm9jZXNzJTBBJTIwJTIwJTIwJTIwZGVmJTIwbG9nKHNlbGYlMkMlMjB2YWx1ZXMlM0ElMjBkaWN0JTJDJTIwc3RlcCUzQSUyME9wdGlvbmFsJTVCaW50JTVEJTIwJTNEJTIwTm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3YW5kYi5sb2codmFsdWVzJTJDJTIwc3RlcCUzRHN0ZXAp",highlighted:`<span class="hljs-keyword">from</span> accelerate.tracking <span class="hljs-keyword">import</span> GeneralTracker, on_main_process
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">import</span> wandb


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomTracker</span>(<span class="hljs-title class_ inherited__">GeneralTracker</span>):
    name = <span class="hljs-string">&quot;wandb&quot;</span>
    requires_logging_directory = <span class="hljs-literal">False</span>

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, run_name: <span class="hljs-built_in">str</span></span>):
        self.run_name = run_name
        run = wandb.init(self.run_name)

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">tracker</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> self.run.run

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">store_init_configuration</span>(<span class="hljs-params">self, values: <span class="hljs-built_in">dict</span></span>):
        wandb.config(values)

<span class="hljs-meta">    @on_main_process</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">log</span>(<span class="hljs-params">self, values: <span class="hljs-built_in">dict</span>, step: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>):
        wandb.log(values, step=step)`,wrap:!1}}),F=new j({props:{code:"dHJhY2tlciUyMCUzRCUyME15Q3VzdG9tVHJhY2tlciglMjJzb21lX3J1bl9uYW1lJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0R0cmFja2VyKQ==",highlighted:`tracker = MyCustomTracker(<span class="hljs-string">&quot;some_run_name&quot;</span>)
accelerator = Accelerator(log_with=tracker)`,wrap:!1}}),z=new j({props:{code:"dHJhY2tlciUyMCUzRCUyME15Q3VzdG9tVHJhY2tlciglMjJzb21lX3J1bl9uYW1lJTIyKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlNUJ0cmFja2VyJTJDJTIwJTIyYWxsJTIyJTVEKQ==",highlighted:`tracker = MyCustomTracker(<span class="hljs-string">&quot;some_run_name&quot;</span>)
accelerator = Accelerator(log_with=[tracker, <span class="hljs-string">&quot;all&quot;</span>])`,wrap:!1}}),q=new ne({props:{title:"Accessing the internal tracker",local:"accessing-the-internal-tracker",headingTag:"h2"}}),K=new j({props:{code:"d2FuZGJfdHJhY2tlciUyMCUzRCUyMGFjY2VsZXJhdG9yLmdldF90cmFja2VyKCUyMndhbmRiJTIyKQ==",highlighted:'wandb_tracker = accelerator.get_tracker(<span class="hljs-string">&quot;wandb&quot;</span>)',wrap:!1}}),D=new j({props:{code:"d2FuZGJfcnVuLmxvZ19hcnRpZmFjdChzb21lX2FydGlmYWN0X3RvX2xvZyk=",highlighted:"wandb_run.log_artifact(some_artifact_to_log)",wrap:!1}}),w=new gl({props:{$$slots:{default:[_l]},$$scope:{ctx:re}}}),ee=new j({props:{code:"d2FuZGJfdHJhY2tlciUyMCUzRCUyMGFjY2VsZXJhdG9yLmdldF90cmFja2VyKCUyMndhbmRiJTIyJTJDJTIwdW53cmFwJTNEVHJ1ZSklMEF3aXRoJTIwYWNjZWxlcmF0b3Iub25fbWFpbl9wcm9jZXNzJTNBJTBBJTIwJTIwJTIwJTIwd2FuZGJfdHJhY2tlci5sb2dfYXJ0aWZhY3Qoc29tZV9hcnRpZmFjdF90b19sb2cp",highlighted:`wandb_tracker = accelerator.get_tracker(<span class="hljs-string">&quot;wandb&quot;</span>, unwrap=<span class="hljs-literal">True</span>)
<span class="hljs-keyword">with</span> accelerator.on_main_process:
    wandb_tracker.log_artifact(some_artifact_to_log)`,wrap:!1}}),le=new ne({props:{title:"When a wrapper cannot work",local:"when-a-wrapper-cannot-work",headingTag:"h2"}}),ae=new j({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGltcG9ydCUyMG5lcHR1bmUubmV3JTIwYXMlMjBuZXB0dW5lJTBBJTBBJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTJCJTIwcnVuJTIwJTNEJTIwbmVwdHVuZS5pbml0KC4uLiklMEElMEElMjAlMjBteV9tb2RlbCUyQyUyMG15X29wdGltaXplciUyQyUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIlMjAlM0QlMjBhY2NlbGVyYXRlLnByZXBhcmUobXlfbW9kZWwlMkMlMjBteV9vcHRpbWl6ZXIlMkMlMjBteV90cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUyMCUyMGRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQSUyMCUyMG15X21vZGVsLnRvKGRldmljZSklMEElMEElMjAlMjBmb3IlMjBpdGVyYXRpb24lMjBpbiUyMGNvbmZpZyU1QiUyMm51bV9pdGVyYXRpb25zJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMkMlMjB0YXJnZXRzJTIwJTNEJTIwYmF0Y2glMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbXlfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBteV9sb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvdGFsX2xvc3MlMjAlMkIlM0QlMjBsb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuc3RlcCgpJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBydW4lNUIlMjJsb2dzJTJGdHJhaW5pbmclMkZiYXRjaCUyRmxvc3MlMjIlNUQubG9nKGxvc3Mp",highlighted:`  from accelerate import Accelerator
<span class="hljs-addition">+ import neptune.new as neptune</span>

  accelerator = Accelerator()
<span class="hljs-addition">+ run = neptune.init(...)</span>

  my_model, my_optimizer, my_training_dataloader = accelerate.prepare(my_model, my_optimizer, my_training_dataloader)
  device = accelerator.device
  my_model.to(device)

  for iteration in config[&quot;num_iterations&quot;]:
      for batch in my_training_dataloader:
          my_optimizer.zero_grad()
          inputs, targets = batch
          inputs = inputs.to(device)
          targets = targets.to(device)
          outputs = my_model(inputs)
          loss = my_loss_function(outputs, targets)
          total_loss += loss
          accelerator.backward(loss)
          my_optimizer.step()
<span class="hljs-addition">+         if accelerator.is_main_process:</span>
<span class="hljs-addition">+             run[&quot;logs/training/batch/loss&quot;].log(loss)</span>`,wrap:!1}}),{c(){u=r("meta"),J=s(),T=r("p"),ie=s(),o(h.$$.fragment),ce=s(),b=r("p"),b.innerHTML=Se,oe=s(),o(f.$$.fragment),pe=s(),U=r("p"),U.innerHTML=Le,Me=s(),I=r("ul"),I.innerHTML=Ke,me=s(),g=r("p"),g.innerHTML=Pe,de=s(),o(_.$$.fragment),ye=s(),B=r("p"),B.innerHTML=De,ue=s(),o(C.$$.fragment),je=s(),k=r("p"),k.innerHTML=Oe,Je=s(),o($.$$.fragment),we=s(),A=r("p"),A.innerHTML=el,Te=s(),o(Z.$$.fragment),he=s(),v=r("p"),v.textContent=ll,be=s(),o(W.$$.fragment),fe=s(),G=r("p"),G.innerHTML=tl,Ue=s(),o(X.$$.fragment),Ie=s(),o(Y.$$.fragment),ge=s(),R=r("p"),R.innerHTML=al,_e=s(),V=r("ul"),V.innerHTML=sl,Be=s(),H=r("p"),H.innerHTML=nl,Ce=s(),N=r("p"),N.textContent=rl,ke=s(),o(Q.$$.fragment),$e=s(),x=r("p"),x.innerHTML=il,Ae=s(),o(F.$$.fragment),Ze=s(),E=r("p"),E.innerHTML=cl,ve=s(),o(z.$$.fragment),We=s(),o(q.$$.fragment),Ge=s(),S=r("p"),S.innerHTML=ol,Xe=s(),L=r("p"),L.textContent=pl,Ye=s(),o(K.$$.fragment),Re=s(),P=r("p"),P.innerHTML=Ml,Ve=s(),o(D.$$.fragment),He=s(),o(w.$$.fragment),Ne=s(),O=r("p"),O.textContent=ml,Qe=s(),o(ee.$$.fragment),xe=s(),o(le.$$.fragment),Fe=s(),te=r("p"),te.innerHTML=dl,Ee=s(),o(ae.$$.fragment),ze=s(),se=r("p"),this.h()},l(e){const l=bl("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(t),J=n(e),T=i(e,"P",{}),ul(T).forEach(t),ie=n(e),p(h.$$.fragment,e),ce=n(e),b=i(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1f9d4ma"&&(b.innerHTML=Se),oe=n(e),p(f.$$.fragment,e),pe=n(e),U=i(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1nrf04r"&&(U.innerHTML=Le),Me=n(e),I=i(e,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-1mj8z9g"&&(I.innerHTML=Ke),me=n(e),g=i(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1s812u7"&&(g.innerHTML=Pe),de=n(e),p(_.$$.fragment,e),ye=n(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1myr0m3"&&(B.innerHTML=De),ue=n(e),p(C.$$.fragment,e),je=n(e),k=i(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1eivltl"&&(k.innerHTML=Oe),Je=n(e),p($.$$.fragment,e),we=n(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-2gut8k"&&(A.innerHTML=el),Te=n(e),p(Z.$$.fragment,e),he=n(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-14biqpt"&&(v.textContent=ll),be=n(e),p(W.$$.fragment,e),fe=n(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1xvy8p4"&&(G.innerHTML=tl),Ue=n(e),p(X.$$.fragment,e),Ie=n(e),p(Y.$$.fragment,e),ge=n(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-rvhb9m"&&(R.innerHTML=al),_e=n(e),V=i(e,"UL",{"data-svelte-h":!0}),c(V)!=="svelte-bz1vgf"&&(V.innerHTML=sl),Be=n(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-cy8o0f"&&(H.innerHTML=nl),Ce=n(e),N=i(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1e80qmi"&&(N.textContent=rl),ke=n(e),p(Q.$$.fragment,e),$e=n(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-19lwbk8"&&(x.innerHTML=il),Ae=n(e),p(F.$$.fragment,e),Ze=n(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-13imq9d"&&(E.innerHTML=cl),ve=n(e),p(z.$$.fragment,e),We=n(e),p(q.$$.fragment,e),Ge=n(e),S=i(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-10po0uv"&&(S.innerHTML=ol),Xe=n(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-bsc6i9"&&(L.textContent=pl),Ye=n(e),p(K.$$.fragment,e),Re=n(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-gdcdqr"&&(P.innerHTML=Ml),Ve=n(e),p(D.$$.fragment,e),He=n(e),p(w.$$.fragment,e),Ne=n(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-8mhpnh"&&(O.textContent=ml),Qe=n(e),p(ee.$$.fragment,e),xe=n(e),p(le.$$.fragment,e),Fe=n(e),te=i(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-e74pz9"&&(te.innerHTML=dl),Ee=n(e),p(ae.$$.fragment,e),ze=n(e),se=i(e,"P",{}),ul(se).forEach(t),this.h()},h(){jl(u,"name","hf:doc:metadata"),jl(u,"content",Cl)},m(e,l){fl(document.head,u),a(e,J,l),a(e,T,l),a(e,ie,l),M(h,e,l),a(e,ce,l),a(e,b,l),a(e,oe,l),M(f,e,l),a(e,pe,l),a(e,U,l),a(e,Me,l),a(e,I,l),a(e,me,l),a(e,g,l),a(e,de,l),M(_,e,l),a(e,ye,l),a(e,B,l),a(e,ue,l),M(C,e,l),a(e,je,l),a(e,k,l),a(e,Je,l),M($,e,l),a(e,we,l),a(e,A,l),a(e,Te,l),M(Z,e,l),a(e,he,l),a(e,v,l),a(e,be,l),M(W,e,l),a(e,fe,l),a(e,G,l),a(e,Ue,l),M(X,e,l),a(e,Ie,l),M(Y,e,l),a(e,ge,l),a(e,R,l),a(e,_e,l),a(e,V,l),a(e,Be,l),a(e,H,l),a(e,Ce,l),a(e,N,l),a(e,ke,l),M(Q,e,l),a(e,$e,l),a(e,x,l),a(e,Ae,l),M(F,e,l),a(e,Ze,l),a(e,E,l),a(e,ve,l),M(z,e,l),a(e,We,l),M(q,e,l),a(e,Ge,l),a(e,S,l),a(e,Xe,l),a(e,L,l),a(e,Ye,l),M(K,e,l),a(e,Re,l),a(e,P,l),a(e,Ve,l),M(D,e,l),a(e,He,l),M(w,e,l),a(e,Ne,l),a(e,O,l),a(e,Qe,l),M(ee,e,l),a(e,xe,l),M(le,e,l),a(e,Fe,l),a(e,te,l),a(e,Ee,l),M(ae,e,l),a(e,ze,l),a(e,se,l),qe=!0},p(e,[l]){const yl={};l&2&&(yl.$$scope={dirty:l,ctx:e}),w.$set(yl)},i(e){qe||(m(h.$$.fragment,e),m(f.$$.fragment,e),m(_.$$.fragment,e),m(C.$$.fragment,e),m($.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(w.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),qe=!0)},o(e){d(h.$$.fragment,e),d(f.$$.fragment,e),d(_.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(D.$$.fragment,e),d(w.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),qe=!1},d(e){e&&(t(J),t(T),t(ie),t(ce),t(b),t(oe),t(pe),t(U),t(Me),t(I),t(me),t(g),t(de),t(ye),t(B),t(ue),t(je),t(k),t(Je),t(we),t(A),t(Te),t(he),t(v),t(be),t(fe),t(G),t(Ue),t(Ie),t(ge),t(R),t(_e),t(V),t(Be),t(H),t(Ce),t(N),t(ke),t($e),t(x),t(Ae),t(Ze),t(E),t(ve),t(We),t(Ge),t(S),t(Xe),t(L),t(Ye),t(Re),t(P),t(Ve),t(He),t(Ne),t(O),t(Qe),t(xe),t(Fe),t(te),t(Ee),t(ze),t(se)),t(u),y(h,e),y(f,e),y(_,e),y(C,e),y($,e),y(Z,e),y(W,e),y(X,e),y(Y,e),y(Q,e),y(F,e),y(z,e),y(q,e),y(K,e),y(D,e),y(w,e),y(ee,e),y(le,e),y(ae,e)}}}const Cl='{"title":"Tracking","local":"tracking","sections":[{"title":"Integrated Trackers","local":"integrated-trackers","sections":[],"depth":2},{"title":"Implementing Custom Trackers","local":"implementing-custom-trackers","sections":[],"depth":2},{"title":"Accessing the internal tracker","local":"accessing-the-internal-tracker","sections":[],"depth":2},{"title":"When a wrapper cannot work","local":"when-a-wrapper-cannot-work","sections":[],"depth":2}],"depth":1}';function kl(re){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gl extends Tl{constructor(u){super(),hl(this,u,kl,Bl,Jl,{})}}export{Gl as component};
