import{s as Ke,o as Le,n as He}from"../chunks/scheduler.00bde567.js";import{S as De,i as Pe,g as p,s,r as M,A as qe,h as r,f as t,c as n,j as Fe,u as d,x as h,k as Ee,y as Oe,a,v as m,d as y,t as u,w,m as el,n as ll}from"../chunks/index.752e2ff6.js";import{T as ge}from"../chunks/Tip.6fda87e9.js";import{C as I}from"../chunks/CodeBlock.e62cd1dc.js";import{H as P}from"../chunks/Heading.476d3364.js";function tl(J){let c,o='In its current state, this code is not going to perform gradient accumulation efficiently due to a process called gradient synchronization. Read more about that in the <a href="../concept_guides/gradient_synchronization">Concepts tutorial</a>!';return{c(){c=p("p"),c.innerHTML=o},l(i){c=r(i,"P",{"data-svelte-h":!0}),h(c)!=="svelte-s0dec7"&&(c.innerHTML=o)},m(i,j){a(i,c,j)},p:He,d(i){i&&t(c)}}}function al(J){let c;return{c(){c=el(`Typically with gradient accumulation, you would need to adjust the number of steps to reflect the change in total batches you are 
training on. 🤗 Accelerate automagically does this for you by default. Behind the scenes we instantiate a GradientAccumulationPlugin configured to do this.`)},l(o){c=ll(o,`Typically with gradient accumulation, you would need to adjust the number of steps to reflect the change in total batches you are 
training on. 🤗 Accelerate automagically does this for you by default. Behind the scenes we instantiate a GradientAccumulationPlugin configured to do this.`)},m(o,i){a(o,c,i)},d(o){o&&t(c)}}}function sl(J){let c,o="It’s important that <strong>only one forward/backward</strong> should be done inside the context manager <code>with accelerator.accumulate(model)</code>.";return{c(){c=p("p"),c.innerHTML=o},l(i){c=r(i,"P",{"data-svelte-h":!0}),h(c)!=="svelte-1kw2co7"&&(c.innerHTML=o)},m(i,j){a(i,c,j)},p:He,d(i){i&&t(c)}}}function nl(J){let c,o,i,j,G,q,f,Ze=`Gradient accumulation is a technique where you can train on bigger batch sizes than
your machine would normally be able to fit into memory. This is done by accumulating gradients over
several batches, and only stepping the optimizer after a certain number of batches have been performed.`,O,C,We=`While technically standard gradient accumulation code would work fine in a distributed setup, it is not the most efficient
method for doing so and you may experience considerable slowdowns!`,ee,B,Xe=`In this tutorial you will see how to quickly setup gradient accumulation and perform it with the utilities provided in 🤗 Accelerate,
which can total to adding just one new line of code!`,le,g,Ve="This example will use a very simplistic PyTorch training loop that performs gradient accumulation every two batches:",te,Z,ae,W,se,X,Ae="First the code shown earlier will be converted to utilize 🤗 Accelerate without the special gradient accumulation helper:",ne,V,ce,T,ie,A,pe,Y,Ye=`All that is left now is to let 🤗 Accelerate handle the gradient accumulation for us. To do so you should pass in a <code>gradient_accumulation_steps</code> parameter to <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, dictating the number
of steps to perform before each call to <code>step()</code> and how to automatically adjust the loss during the call to <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a>:`,re,k,oe,v,ke=`Alternatively, you can pass in a <code>gradient_accumulation_plugin</code> parameter to the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object’s <code>__init__</code>, which will allow you to further customize the gradient accumulation behavior.
Read more about that in the <a href="../package_reference/accelerator#accelerate.utils.GradientAccumulationPlugin">GradientAccumulationPlugin</a> docs.`,Me,R,ve=`From here you can use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager from inside your training loop to automatically perform the gradient accumulation for you!
You just wrap it around the entire training part of our code:`,de,$,me,Q,Re="You can remove all the special checks for the step number and the loss adjustment:",ye,_,ue,z,$e='As you can see the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is able to keep track of the batch number you are on and it will automatically know whether to step through the prepared optimizer and how to adjust the loss.',we,b,he,N,Je,x,Qe="Below is the finished implementation for performing gradient accumulation with 🤗 Accelerate",je,S,Te,U,be,F,_e='To learn more about what magic this wraps around, read the <a href="../concept_guides/gradient_synchronization">Gradient Synchronization concept guide</a>',Ue,E,Ie,H,ze="Here is a self-contained example that you can run to see gradient accumulation in action with 🤗 Accelerate:",Ge,K,fe,L,Ce,D,Be;return G=new P({props:{title:"Performing gradient accumulation with 🤗 Accelerate",local:"performing-gradient-accumulation-with--accelerate",headingTag:"h1"}}),Z=new I({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAyJTBBJTBBZm9yJTIwaW5kZXglMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRyYWluaW5nX2RhdGFsb2FkZXIpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMGlmJTIwKGluZGV4JTIwJTJCJTIwMSklMjAlMjUlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

gradient_accumulation_steps = <span class="hljs-number">2</span>

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(training_dataloader):
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss = loss / gradient_accumulation_steps
    loss.backward()
    <span class="hljs-keyword">if</span> (index + <span class="hljs-number">1</span>) % gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),W=new P({props:{title:"Converting it to 🤗 Accelerate",local:"converting-it-to--accelerate",headingTag:"h2"}}),V=new I({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQS0lMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQS0lMjAlMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for index, batch in enumerate(training_dataloader):
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
      loss = loss / gradient_accumulation_steps
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      if (index+1) % gradient_accumulation_steps == 0:
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),T=new ge({props:{warning:!0,$$slots:{default:[tl]},$$scope:{ctx:J}}}),A=new P({props:{title:"Letting 🤗 Accelerate handle gradient accumulation",local:"letting--accelerate-handle-gradient-accumulation",headingTag:"h2"}}),k=new I({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQS0lMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMkIlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIp",highlighted:`  from accelerate import Accelerator
<span class="hljs-deletion">- accelerator = Accelerator()</span>
<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>`,wrap:!1}}),$=new I({props:{code:"LSUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyQiUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyk=",highlighted:`<span class="hljs-deletion">- for index, batch in enumerate(training_dataloader):</span>
<span class="hljs-addition">+ for batch in training_dataloader:</span>
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          inputs, targets = batch
          outputs = model(inputs)`,wrap:!1}}),_=new I({props:{code:"LSUyMGxvc3MlMjAlM0QlMjBsb3NzJTIwJTJGJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEEtJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-deletion">- loss = loss / gradient_accumulation_steps</span>
  accelerator.backward(loss)
<span class="hljs-deletion">- if (index+1) % gradient_accumulation_steps == 0:</span>
  optimizer.step()
  scheduler.step()
  optimizer.zero_grad()`,wrap:!1}}),b=new ge({props:{$$slots:{default:[al]},$$scope:{ctx:J}}}),N=new P({props:{title:"The finished code",local:"the-finished-code",headingTag:"h2"}}),S=new I({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEFtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUwQSklMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBhY2NlbGVyYXRvci5hY2N1bXVsYXRlKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs, targets = batch
        outputs = model(inputs)
        loss = loss_function(outputs, targets)
        accelerator.backward(loss)
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),U=new ge({props:{warning:!0,$$slots:{default:[sl]},$$scope:{ctx:J}}}),E=new P({props:{title:"Self-contained example",local:"self-contained-example",headingTag:"h2"}}),K=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> copy
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> TensorDataset, DataLoader

<span class="hljs-comment"># seed</span>
set_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># define toy inputs and labels</span>
x = torch.tensor([<span class="hljs-number">1.</span>, <span class="hljs-number">2.</span>, <span class="hljs-number">3.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">5.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">7.</span>, <span class="hljs-number">8.</span>])
y = torch.tensor([<span class="hljs-number">2.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">8.</span>, <span class="hljs-number">10.</span>, <span class="hljs-number">12.</span>, <span class="hljs-number">14.</span>, <span class="hljs-number">16.</span>])
gradient_accumulation_steps = <span class="hljs-number">4</span>
batch_size = <span class="hljs-built_in">len</span>(x) // gradient_accumulation_steps

<span class="hljs-comment"># define dataset and dataloader</span>
dataset = TensorDataset(x, y)
dataloader = DataLoader(dataset, batch_size=batch_size)

<span class="hljs-comment"># define model, optimizer and loss function</span>
model = torch.zeros((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), requires_grad=<span class="hljs-literal">True</span>)
model_clone = copy.deepcopy(model)
criterion = torch.nn.MSELoss()
model_optimizer = torch.optim.SGD([model], lr=<span class="hljs-number">0.02</span>)
accelerator = Accelerator(gradient_accumulation_steps=gradient_accumulation_steps)
model, model_optimizer, dataloader = accelerator.prepare(model, model_optimizer, dataloader)
model_clone_optimizer = torch.optim.SGD([model_clone], lr=<span class="hljs-number">0.02</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model_clone.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-keyword">for</span> i, (inputs, labels) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader):
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs = inputs.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        <span class="hljs-built_in">print</span>(i, inputs.flatten())
        labels = labels.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        outputs = inputs @ model
        loss = criterion(outputs, labels)
        accelerator.backward(loss)
        model_optimizer.step()
        model_optimizer.zero_grad()
loss = criterion(x.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) @ model_clone, y.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>))
model_clone_optimizer.zero_grad()
loss.backward()
model_clone_optimizer.step()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/ accumulation, the final model weight is <span class="hljs-subst">{model.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/o accumulation, the final model weight is <span class="hljs-subst">{model_clone.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)`,wrap:!1}}),L=new I({props:{code:"aW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBaW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBMCUyMHRlbnNvciglNUIxLiUyQyUyMDIuJTVEKSUwQTElMjB0ZW5zb3IoJTVCMy4lMkMlMjA0LiU1RCklMEEyJTIwdGVuc29yKCU1QjUuJTJDJTIwNi4lNUQpJTBBMyUyMHRlbnNvciglNUI3LiUyQyUyMDguJTVEKSUwQXclMkYlMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAwJTBBdyUyRm8lMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAw",highlighted:`<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">0</span> tensor([<span class="hljs-number">1</span>., <span class="hljs-number">2</span>.])
<span class="hljs-attribute">1</span> tensor([<span class="hljs-number">3</span>., <span class="hljs-number">4</span>.])
<span class="hljs-attribute">2</span> tensor([<span class="hljs-number">5</span>., <span class="hljs-number">6</span>.])
<span class="hljs-attribute">3</span> tensor([<span class="hljs-number">7</span>., <span class="hljs-number">8</span>.])
<span class="hljs-attribute">w</span>/ accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>
<span class="hljs-attribute">w</span>/o accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>`,wrap:!1}}),{c(){c=p("meta"),o=s(),i=p("p"),j=s(),M(G.$$.fragment),q=s(),f=p("p"),f.textContent=Ze,O=s(),C=p("p"),C.textContent=We,ee=s(),B=p("p"),B.textContent=Xe,le=s(),g=p("p"),g.textContent=Ve,te=s(),M(Z.$$.fragment),ae=s(),M(W.$$.fragment),se=s(),X=p("p"),X.textContent=Ae,ne=s(),M(V.$$.fragment),ce=s(),M(T.$$.fragment),ie=s(),M(A.$$.fragment),pe=s(),Y=p("p"),Y.innerHTML=Ye,re=s(),M(k.$$.fragment),oe=s(),v=p("p"),v.innerHTML=ke,Me=s(),R=p("p"),R.innerHTML=ve,de=s(),M($.$$.fragment),me=s(),Q=p("p"),Q.textContent=Re,ye=s(),M(_.$$.fragment),ue=s(),z=p("p"),z.innerHTML=$e,we=s(),M(b.$$.fragment),he=s(),M(N.$$.fragment),Je=s(),x=p("p"),x.textContent=Qe,je=s(),M(S.$$.fragment),Te=s(),M(U.$$.fragment),be=s(),F=p("p"),F.innerHTML=_e,Ue=s(),M(E.$$.fragment),Ie=s(),H=p("p"),H.textContent=ze,Ge=s(),M(K.$$.fragment),fe=s(),M(L.$$.fragment),Ce=s(),D=p("p"),this.h()},l(e){const l=qe("svelte-u9bgzb",document.head);c=r(l,"META",{name:!0,content:!0}),l.forEach(t),o=n(e),i=r(e,"P",{}),Fe(i).forEach(t),j=n(e),d(G.$$.fragment,e),q=n(e),f=r(e,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1762c2w"&&(f.textContent=Ze),O=n(e),C=r(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1u2vc4p"&&(C.textContent=We),ee=n(e),B=r(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-elnr4k"&&(B.textContent=Xe),le=n(e),g=r(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-n9bxrd"&&(g.textContent=Ve),te=n(e),d(Z.$$.fragment,e),ae=n(e),d(W.$$.fragment,e),se=n(e),X=r(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-41b2zq"&&(X.textContent=Ae),ne=n(e),d(V.$$.fragment,e),ce=n(e),d(T.$$.fragment,e),ie=n(e),d(A.$$.fragment,e),pe=n(e),Y=r(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-70ndtd"&&(Y.innerHTML=Ye),re=n(e),d(k.$$.fragment,e),oe=n(e),v=r(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-j5vx6o"&&(v.innerHTML=ke),Me=n(e),R=r(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1yxrf5e"&&(R.innerHTML=ve),de=n(e),d($.$$.fragment,e),me=n(e),Q=r(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1mcvl9w"&&(Q.textContent=Re),ye=n(e),d(_.$$.fragment,e),ue=n(e),z=r(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1g13ex2"&&(z.innerHTML=$e),we=n(e),d(b.$$.fragment,e),he=n(e),d(N.$$.fragment,e),Je=n(e),x=r(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-9alw5p"&&(x.textContent=Qe),je=n(e),d(S.$$.fragment,e),Te=n(e),d(U.$$.fragment,e),be=n(e),F=r(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-aw0h59"&&(F.innerHTML=_e),Ue=n(e),d(E.$$.fragment,e),Ie=n(e),H=r(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1wysb4w"&&(H.textContent=ze),Ge=n(e),d(K.$$.fragment,e),fe=n(e),d(L.$$.fragment,e),Ce=n(e),D=r(e,"P",{}),Fe(D).forEach(t),this.h()},h(){Ee(c,"name","hf:doc:metadata"),Ee(c,"content",cl)},m(e,l){Oe(document.head,c),a(e,o,l),a(e,i,l),a(e,j,l),m(G,e,l),a(e,q,l),a(e,f,l),a(e,O,l),a(e,C,l),a(e,ee,l),a(e,B,l),a(e,le,l),a(e,g,l),a(e,te,l),m(Z,e,l),a(e,ae,l),m(W,e,l),a(e,se,l),a(e,X,l),a(e,ne,l),m(V,e,l),a(e,ce,l),m(T,e,l),a(e,ie,l),m(A,e,l),a(e,pe,l),a(e,Y,l),a(e,re,l),m(k,e,l),a(e,oe,l),a(e,v,l),a(e,Me,l),a(e,R,l),a(e,de,l),m($,e,l),a(e,me,l),a(e,Q,l),a(e,ye,l),m(_,e,l),a(e,ue,l),a(e,z,l),a(e,we,l),m(b,e,l),a(e,he,l),m(N,e,l),a(e,Je,l),a(e,x,l),a(e,je,l),m(S,e,l),a(e,Te,l),m(U,e,l),a(e,be,l),a(e,F,l),a(e,Ue,l),m(E,e,l),a(e,Ie,l),a(e,H,l),a(e,Ge,l),m(K,e,l),a(e,fe,l),m(L,e,l),a(e,Ce,l),a(e,D,l),Be=!0},p(e,[l]){const Ne={};l&2&&(Ne.$$scope={dirty:l,ctx:e}),T.$set(Ne);const xe={};l&2&&(xe.$$scope={dirty:l,ctx:e}),b.$set(xe);const Se={};l&2&&(Se.$$scope={dirty:l,ctx:e}),U.$set(Se)},i(e){Be||(y(G.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(V.$$.fragment,e),y(T.$$.fragment,e),y(A.$$.fragment,e),y(k.$$.fragment,e),y($.$$.fragment,e),y(_.$$.fragment,e),y(b.$$.fragment,e),y(N.$$.fragment,e),y(S.$$.fragment,e),y(U.$$.fragment,e),y(E.$$.fragment,e),y(K.$$.fragment,e),y(L.$$.fragment,e),Be=!0)},o(e){u(G.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(V.$$.fragment,e),u(T.$$.fragment,e),u(A.$$.fragment,e),u(k.$$.fragment,e),u($.$$.fragment,e),u(_.$$.fragment,e),u(b.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(U.$$.fragment,e),u(E.$$.fragment,e),u(K.$$.fragment,e),u(L.$$.fragment,e),Be=!1},d(e){e&&(t(o),t(i),t(j),t(q),t(f),t(O),t(C),t(ee),t(B),t(le),t(g),t(te),t(ae),t(se),t(X),t(ne),t(ce),t(ie),t(pe),t(Y),t(re),t(oe),t(v),t(Me),t(R),t(de),t(me),t(Q),t(ye),t(ue),t(z),t(we),t(he),t(Je),t(x),t(je),t(Te),t(be),t(F),t(Ue),t(Ie),t(H),t(Ge),t(fe),t(Ce),t(D)),t(c),w(G,e),w(Z,e),w(W,e),w(V,e),w(T,e),w(A,e),w(k,e),w($,e),w(_,e),w(b,e),w(N,e),w(S,e),w(U,e),w(E,e),w(K,e),w(L,e)}}}const cl='{"title":"Performing gradient accumulation with 🤗 Accelerate","local":"performing-gradient-accumulation-with--accelerate","sections":[{"title":"Converting it to 🤗 Accelerate","local":"converting-it-to--accelerate","sections":[],"depth":2},{"title":"Letting 🤗 Accelerate handle gradient accumulation","local":"letting--accelerate-handle-gradient-accumulation","sections":[],"depth":2},{"title":"The finished code","local":"the-finished-code","sections":[],"depth":2},{"title":"Self-contained example","local":"self-contained-example","sections":[],"depth":2}],"depth":1}';function il(J){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends De{constructor(c){super(),Pe(this,c,il,nl,Ke,{})}}export{ml as component};
