import{s as Ce,n as $e,o as Ze}from"../chunks/scheduler.00bde567.js";import{S as Ge,i as Ne,g as i,s as l,r as o,A as ke,h as c,f as s,c as n,j as ge,u as h,x as r,k as ve,y as xe,a,v as m,d as u,t as M,w as y}from"../chunks/index.752e2ff6.js";import{C as z}from"../chunks/CodeBlock.e62cd1dc.js";import{H as oe}from"../chunks/Heading.476d3364.js";function _e(he){let p,E,F,S,d,B,b,me='When running scripts in a distributed fashion, often functions such as <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.gather">Accelerator.gather()</a> and <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.reduce">Accelerator.reduce()</a> (and others) are neccessary to grab tensors across devices and perform certain operations on them. However, if the tensors which are being grabbed are not the proper shapes then this will result in your code hanging forever. The only sign that exists of this truly happening is hitting a timeout exception from <code>torch.distributed</code>, but this can get quite costly as usually the timeout is 10 minutes.',A,j,ue="Accelerate now has a <code>debug</code> mode which adds a neglible amount of time to each operation, but allows it to verify that the inputs you are bringing in can <em>actually</em> perform the operation you want <strong>without</strong> hitting this timeout problem!",H,U,R,f,Me="To have a tangible example of this issue, let’s take the following setup (on 2 GPUs):",Y,w,L,J,ye='We’ve created a single tensor on each device, with two radically different shapes. With this setup if we want to perform an operation such as <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.broadcast">utils.broadcast()</a>, we would forever hit a timeout because <code>torch.distributed</code> requires that these operations have the <strong>exact same shape</strong> across all processes for it to work.',X,T,de="If you run this yourself, you will find that <code>broadcast_tensor</code> can be printed on the main process, but its results won’t quite be right, and then it will just hang never printing it on any of the other processes:",P,g,D,v,q,C,be="By enabling Accelerate’s operational debug mode, Accelerate will properly find and catch errors such as this and provide a very clear traceback immediatly:",K,$,O,Z,je="This explains that the shapes across our devices were <em>not</em> the same, and that we should ensure that they match properly to be compatible. Typically this means that there is either an extra dimension, or certain dimensions are incompatible with the operation.",ee,G,Ue="To enable this please do one of the following:",te,N,fe="Enable it through the questionarre during <code>accelerate config</code> (recommended)",se,k,we="From the CLI:",ae,x,le,_,Je="As an environmental variable (which avoids the need for <code>accelerate launch</code>):",ne,I,ie,W,Te="Manually changing the <code>config.yaml</code> file:",ce,Q,re,V,pe;return d=new oe({props:{title:"Debugging Distributed Operations",local:"debugging-distributed-operations",headingTag:"h1"}}),U=new oe({props:{title:"Visualizing the problem",local:"visualizing-the-problem",headingTag:"h2"}}),w=new z({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBaWYlMjBzdGF0ZS5wcm9jZXNzX2luZGV4JTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMHRlbnNvciUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUIwLjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTVEJTVEKS50byhzdGF0ZS5kZXZpY2UpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHRlbnNvciUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUIlNUIwLjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCUyQyUyMDklNUQlNUQlNUQpLnRvKHN0YXRlLmRldmljZSklMEElMEFicm9hZGNhc3RfdGVuc29yJTIwJTNEJTIwYnJvYWRjYXN0KHRlbnNvciklMEFwcmludChicm9hZGNhc3RfdGVuc29yKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState

state = PartialState()
<span class="hljs-keyword">if</span> state.process_index == <span class="hljs-number">0</span>:
    tensor = torch.tensor([[<span class="hljs-number">0.0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]).to(state.device)
<span class="hljs-keyword">else</span>:
    tensor = torch.tensor([[[<span class="hljs-number">0.0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>], [<span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]]]).to(state.device)

broadcast_tensor = broadcast(tensor)
<span class="hljs-built_in">print</span>(broadcast_tensor)`,wrap:!1}}),g=new z({props:{code:"dGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTVEJTVEJTJDJTIwZGV2aWNlJTNEJ2N1ZGElM0EwJyk=",highlighted:'&gt;&gt;&gt; tensor(<span class="hljs-string">[[0, 1, 2, 3, 4]]</span>, device=<span class="hljs-string">&#x27;cuda:0&#x27;</span>)',wrap:!1}}),v=new oe({props:{title:"The solution",local:"the-solution",headingTag:"h2"}}),$=new z({props:{code:"VHJhY2ViYWNrJTIwKG1vc3QlMjByZWNlbnQlMjBjYWxsJTIwbGFzdCklM0ElMEElMjAlMjBGaWxlJTIwJTIyJTJGaG9tZSUyRnphY2hfbXVlbGxlcl9odWdnaW5nZmFjZV9jbyUyRnRlc3QucHklMjIlMkMlMjBsaW5lJTIwMTglMkMlMjBpbiUyMCUzQ21vZHVsZSUzRSUwQSUyMCUyMCUyMCUyMG1haW4oKSUwQSUyMCUyMEZpbGUlMjAlMjIlMkZob21lJTJGemFjaF9tdWVsbGVyX2h1Z2dpbmdmYWNlX2NvJTJGdGVzdC5weSUyMiUyQyUyMGxpbmUlMjAxNSUyQyUyMGluJTIwbWFpbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1haW4oKWJyb2FkY2FzdF90ZW5zb3IlMjAlM0QlMjBicm9hZGNhc3QodGVuc29yKSUwQSUyMCUyMEZpbGUlMjAlMjIlMkZob21lJTJGemFjaF9tdWVsbGVyX2h1Z2dpbmdmYWNlX2NvJTJGYWNjZWxlcmF0ZSUyRnNyYyUyRmFjY2VsZXJhdGUlMkZ1dGlscyUyRm9wZXJhdGlvbnMucHklMjIlMkMlMjBsaW5lJTIwMzAzJTJDJTIwaW4lMjB3cmFwcGVyJTBBJTIwJTIwJTIwJTIwYnJvYWRjYXN0X3RlbnNvciUyMCUzRCUyMGJyb2FkY2FzdCh0ZW5zb3IpJTBBYWNjZWxlcmF0ZS51dGlscy5vcGVyYXRpb25zLkRpc3RyaWJ1dGVkT3BlcmF0aW9uRXhjZXB0aW9uJTNBJTIwQ2Fubm90JTIwYXBwbHklMjBkZXNpcmVkJTIwb3BlcmF0aW9uJTIwZHVlJTIwdG8lMjBzaGFwZSUyMG1pc21hdGNoZXMuJTIwQWxsJTIwc2hhcGVzJTIwYWNyb3NzJTIwZGV2aWNlcyUyMG11c3QlMjBiZSUyMHZhbGlkLiUwQSUwQU9wZXJhdGlvbiUzQSUyMCU2MGFjY2VsZXJhdGUudXRpbHMub3BlcmF0aW9ucy5icm9hZGNhc3QlNjAlMEFJbnB1dCUyMHNoYXBlcyUzQSUwQSUyMCUyMC0lMjBQcm9jZXNzJTIwMCUzQSUyMCU1QjElMkMlMjA1JTVEJTBBJTIwJTIwLSUyMFByb2Nlc3MlMjAxJTNBJTIwJTVCMSUyQyUyMDIlMkMlMjA1JTVE",highlighted:`Traceback (most recent call last):
  File <span class="hljs-string">&quot;/home/zach_mueller_huggingface_co/test.py&quot;</span>, line <span class="hljs-number">18</span>, <span class="hljs-keyword">in</span> &lt;module&gt;
    <span class="hljs-selector-tag">main</span>()
  File <span class="hljs-string">&quot;/home/zach_mueller_huggingface_co/test.py&quot;</span>, line <span class="hljs-number">15</span>, <span class="hljs-keyword">in</span> <span class="hljs-selector-tag">main</span>
        <span class="hljs-selector-tag">main</span>()broadcast_tensor = <span class="hljs-built_in">broadcast</span>(tensor)
  File <span class="hljs-string">&quot;/home/zach_mueller_huggingface_co/accelerate/src/accelerate/utils/operations.py&quot;</span>, line <span class="hljs-number">303</span>, <span class="hljs-keyword">in</span> wrapper
    broadcast_tensor = <span class="hljs-built_in">broadcast</span>(tensor)
accelerate<span class="hljs-selector-class">.utils</span><span class="hljs-selector-class">.operations</span><span class="hljs-selector-class">.DistributedOperationException</span>: Cannot apply desired operation due to shape mismatches. All shapes across devices must be valid.

Operation: \`accelerate<span class="hljs-selector-class">.utils</span><span class="hljs-selector-class">.operations</span>.broadcast\`
Input shapes:
  - Process <span class="hljs-number">0</span>: <span class="hljs-selector-attr">[1, 5]</span>
  - Process <span class="hljs-number">1</span>: <span class="hljs-selector-attr">[1, 2, 5]</span>`,wrap:!1}}),x=new z({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tZGVidWclMjAlN0JteV9zY3JpcHQucHklN0QlMjAtLWFyZzElMjAtLWFyZzI=",highlighted:'<span class="hljs-comment">accelerate launch</span> <span class="hljs-literal">--</span><span class="hljs-comment">debug {my_script</span><span class="hljs-string">.</span><span class="hljs-comment">py}</span> <span class="hljs-literal">--</span><span class="hljs-comment">arg1</span> <span class="hljs-literal">--</span><span class="hljs-comment">arg2</span>',wrap:!1}}),I=new z({props:{code:"QUNDRUxFUkFURV9ERUJVR19NT0RFJTNEJTIyMSUyMiUyMGFjY2VsZXJhdGUlMjBsYXVuY2glMjAlN0JteV9zY3JpcHQucHklN0QlMjAtLWFyZzElMjAtLWFyZzI=",highlighted:'ACCELERATE_DEBUG_MODE=<span class="hljs-string">&quot;1&quot;</span> accelerate <span class="hljs-built_in">launch</span> {my_script.py} <span class="hljs-comment">--arg1 --arg2</span>',wrap:!1}}),Q=new z({props:{code:"JTIwY29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEElMkJkZWJ1ZyUzQSUyMHRydWU=",highlighted:` compute_environment: LOCAL_MACHINE
<span class="hljs-addition">+debug: true</span>`,wrap:!1}}),{c(){p=i("meta"),E=l(),F=i("p"),S=l(),o(d.$$.fragment),B=l(),b=i("p"),b.innerHTML=me,A=l(),j=i("p"),j.innerHTML=ue,H=l(),o(U.$$.fragment),R=l(),f=i("p"),f.textContent=Me,Y=l(),o(w.$$.fragment),L=l(),J=i("p"),J.innerHTML=ye,X=l(),T=i("p"),T.innerHTML=de,P=l(),o(g.$$.fragment),D=l(),o(v.$$.fragment),q=l(),C=i("p"),C.textContent=be,K=l(),o($.$$.fragment),O=l(),Z=i("p"),Z.innerHTML=je,ee=l(),G=i("p"),G.textContent=Ue,te=l(),N=i("p"),N.innerHTML=fe,se=l(),k=i("p"),k.textContent=we,ae=l(),o(x.$$.fragment),le=l(),_=i("p"),_.innerHTML=Je,ne=l(),o(I.$$.fragment),ie=l(),W=i("p"),W.innerHTML=Te,ce=l(),o(Q.$$.fragment),re=l(),V=i("p"),this.h()},l(e){const t=ke("svelte-u9bgzb",document.head);p=c(t,"META",{name:!0,content:!0}),t.forEach(s),E=n(e),F=c(e,"P",{}),ge(F).forEach(s),S=n(e),h(d.$$.fragment,e),B=n(e),b=c(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1d1ce2t"&&(b.innerHTML=me),A=n(e),j=c(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-mq3h5o"&&(j.innerHTML=ue),H=n(e),h(U.$$.fragment,e),R=n(e),f=c(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1k3x71u"&&(f.textContent=Me),Y=n(e),h(w.$$.fragment,e),L=n(e),J=c(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-q2oe9t"&&(J.innerHTML=ye),X=n(e),T=c(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-xp75q2"&&(T.innerHTML=de),P=n(e),h(g.$$.fragment,e),D=n(e),h(v.$$.fragment,e),q=n(e),C=c(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1gx18x0"&&(C.textContent=be),K=n(e),h($.$$.fragment,e),O=n(e),Z=c(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1zoq07"&&(Z.innerHTML=je),ee=n(e),G=c(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-161v7q2"&&(G.textContent=Ue),te=n(e),N=c(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1oml3n7"&&(N.innerHTML=fe),se=n(e),k=c(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1wczss9"&&(k.textContent=we),ae=n(e),h(x.$$.fragment,e),le=n(e),_=c(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-15izvyq"&&(_.innerHTML=Je),ne=n(e),h(I.$$.fragment,e),ie=n(e),W=c(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-wougyt"&&(W.innerHTML=Te),ce=n(e),h(Q.$$.fragment,e),re=n(e),V=c(e,"P",{}),ge(V).forEach(s),this.h()},h(){ve(p,"name","hf:doc:metadata"),ve(p,"content",Ie)},m(e,t){xe(document.head,p),a(e,E,t),a(e,F,t),a(e,S,t),m(d,e,t),a(e,B,t),a(e,b,t),a(e,A,t),a(e,j,t),a(e,H,t),m(U,e,t),a(e,R,t),a(e,f,t),a(e,Y,t),m(w,e,t),a(e,L,t),a(e,J,t),a(e,X,t),a(e,T,t),a(e,P,t),m(g,e,t),a(e,D,t),m(v,e,t),a(e,q,t),a(e,C,t),a(e,K,t),m($,e,t),a(e,O,t),a(e,Z,t),a(e,ee,t),a(e,G,t),a(e,te,t),a(e,N,t),a(e,se,t),a(e,k,t),a(e,ae,t),m(x,e,t),a(e,le,t),a(e,_,t),a(e,ne,t),m(I,e,t),a(e,ie,t),a(e,W,t),a(e,ce,t),m(Q,e,t),a(e,re,t),a(e,V,t),pe=!0},p:$e,i(e){pe||(u(d.$$.fragment,e),u(U.$$.fragment,e),u(w.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u($.$$.fragment,e),u(x.$$.fragment,e),u(I.$$.fragment,e),u(Q.$$.fragment,e),pe=!0)},o(e){M(d.$$.fragment,e),M(U.$$.fragment,e),M(w.$$.fragment,e),M(g.$$.fragment,e),M(v.$$.fragment,e),M($.$$.fragment,e),M(x.$$.fragment,e),M(I.$$.fragment,e),M(Q.$$.fragment,e),pe=!1},d(e){e&&(s(E),s(F),s(S),s(B),s(b),s(A),s(j),s(H),s(R),s(f),s(Y),s(L),s(J),s(X),s(T),s(P),s(D),s(q),s(C),s(K),s(O),s(Z),s(ee),s(G),s(te),s(N),s(se),s(k),s(ae),s(le),s(_),s(ne),s(ie),s(W),s(ce),s(re),s(V)),s(p),y(d,e),y(U,e),y(w,e),y(g,e),y(v,e),y($,e),y(x,e),y(I,e),y(Q,e)}}}const Ie='{"title":"Debugging Distributed Operations","local":"debugging-distributed-operations","sections":[{"title":"Visualizing the problem","local":"visualizing-the-problem","sections":[],"depth":2},{"title":"The solution","local":"the-solution","sections":[],"depth":2}],"depth":1}';function We(he){return Ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends Ge{constructor(p){super(),Ne(this,p,We,_e,Ce,{})}}export{Ee as component};
