import{s as io,o as lo,n as ro}from"../chunks/scheduler.9bc65507.js";import{S as co,i as po,g as r,s as a,r as c,A as mo,h as i,f as o,c as s,j as M,u as p,x as g,k as b,y as l,a as n,v as m,d as u,t as h,w as f}from"../chunks/index.707bf1b6.js";import{T as so}from"../chunks/Tip.c2ecdbf4.js";import{D as J}from"../chunks/Docstring.17db21ae.js";import{C as xe}from"../chunks/CodeBlock.54a9f38d.js";import{H as B}from"../chunks/Heading.342b1fa6.js";function uo(Te){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=T},l(_){d=i(_,"P",{"data-svelte-h":!0}),g(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(_,G){n(_,d,G)},p:ro,d(_){_&&o(d)}}}function ho(Te){let d,T=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>. For an overview of generation
strategies and code examples, check out the <a href="./generation_strategies">following guide</a>.`;return{c(){d=r("p"),d.innerHTML=T},l(_){d=i(_,"P",{"data-svelte-h":!0}),g(d)!=="svelte-mxjg2r"&&(d.innerHTML=T)},m(_,G){n(_,d,G)},p:ro,d(_){_&&o(d)}}}function fo(Te){let d,T,_,G,W,Fe,I,Ft='<a href="https://huggingface.co/spaces/sweetcocoa/pop2piano"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',Xe,V,Be,R,Xt='The Pop2Piano model was proposed in <a href="https://arxiv.org/abs/2211.00895" rel="nofollow">Pop2Piano : Pop Audio-based Piano Cover Generation</a> by Jongho Choi and Kyogu Lee.',We,q,Bt=`Piano covers of pop music are widely enjoyed, but generating them from music is not a trivial task. It requires great
expertise with playing piano as well as knowing different characteristics and melodies of a song. With Pop2Piano you
can directly generate a cover from a song’s audio waveform. It is the first model to directly generate a piano cover
from pop audio without melody and chord extraction modules.`,Ve,N,Wt=`Pop2Piano is an encoder-decoder Transformer model based on <a href="https://arxiv.org/pdf/1910.10683.pdf" rel="nofollow">T5</a>. The input audio
is transformed to its waveform and passed to the encoder, which transforms it to a latent representation. The decoder
uses these latent representations to generate token ids in an autoregressive way. Each token id corresponds to one of four
different token types: time, velocity, note and ‘special’. The token ids are then decoded to their equivalent MIDI file.`,Re,H,Vt="The abstract from the paper is the following:",qe,E,Rt=`<em>Piano covers of pop music are enjoyed by many people. However, the
task of automatically generating piano covers of pop music is still
understudied. This is partly due to the lack of synchronized
{Pop, Piano Cover} data pairs, which made it challenging to apply
the latest data-intensive deep learning-based methods. To leverage
the power of the data-driven approach, we make a large amount of
paired and synchronized {Pop, Piano Cover} data using an automated
pipeline. In this paper, we present Pop2Piano, a Transformer network
that generates piano covers given waveforms of pop music. To the best
of our knowledge, this is the first model to generate a piano cover
directly from pop audio without using melody and chord extraction
modules. We show that Pop2Piano, trained with our dataset, is capable
of producing plausible piano covers.</em>`,Ne,Q,qt="Tips:",He,S,Nt="<li>To use Pop2Piano, you will need to install the 🤗 Transformers library, as well as the following third party modules:</li>",Ee,Y,Qe,L,Ht=`Please note that you may need to restart your runtime after installation.
2. Pop2Piano is an Encoder-Decoder based model like T5.
3. Pop2Piano can be used to generate midi-audio files for a given audio sequence.
4. Choosing different composers in <code>Pop2PianoForConditionalGeneration.generate()</code> can lead to variety of different results.
5. Setting the sampling rate to 44.1 kHz when loading the audio file can give good performance.
6. Though Pop2Piano was mainly trained on Korean Pop music, it also does pretty well on other Western Pop or Hip Hop songs.`,Se,D,Et=`This model was contributed by <a href="https://huggingface.co/susnato" rel="nofollow">Susnato Dhar</a>.
The original code can be found <a href="https://github.com/sweetcocoa/pop2piano" rel="nofollow">here</a>.`,Ye,A,Le,O,Qt="<li>Example using HuggingFace Dataset:</li>",De,K,Ae,ee,St="<li>Example using your own audio file:</li>",Oe,te,Ke,oe,Yt="<li>Example of processing multiple audio files in batch:</li>",et,ne,tt,ae,Lt="<li>Example of processing multiple audio files in batch (Using <code>Pop2PianoFeatureExtractor</code> and <code>Pop2PianoTokenizer</code>):</li>",ot,se,nt,re,at,v,ie,Mt,we,Dt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a>. It is used
to instantiate a Pop2PianoForConditionalGeneration model according to the specified arguments, defining the model
architecture. Instantiating a configuration with the defaults will yield a similar configuration to that of the
Pop2Piano <a href="https://huggingface.co/sweetcocoa/pop2piano" rel="nofollow">sweetcocoa/pop2piano</a> architecture.`,vt,Pe,At=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,st,le,rt,k,de,Tt,z,ce,wt,je,Ot="Call self as a function.",it,pe,lt,y,me,Pt,Je,Kt=`Pop2Piano Model with a <code>language modeling</code> head on top.
This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jt,ke,eo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jt,w,ue,kt,Ue,to='The <a href="/docs/transformers/v4.35.2/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Ut,Z,Ct,P,he,$t,Ce,oo="Generates token ids for midi outputs.",Gt,x,dt,fe,ct,U,ge,It,F,_e,zt,$e,no="Call self as a function.",pt,ye,mt,C,be,Zt,X,Me,xt,Ge,ao="Call self as a function.",ut,Ze,ht;return W=new B({props:{title:"Pop2Piano",local:"pop2piano",headingTag:"h1"}}),V=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new xe({props:{code:"cGlwJTIwaW5zdGFsbCUyMHByZXR0eS1taWRpJTNEJTNEMC4yLjklMjBlc3NlbnRpYSUzRCUzRDIuMWI2LmRldjEwMzQlMjBsaWJyb3NhJTIwc2NpcHk=",highlighted:'pip install pretty-midi==<span class="hljs-number">0.2</span><span class="hljs-number">.9</span> essentia==<span class="hljs-number">2.1b6</span>.dev1034 librosa scipy',wrap:!1}}),A=new B({props:{title:"Examples",local:"examples",headingTag:"h2"}}),K=new xe({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBvcDJQaWFub0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMFBvcDJQaWFub1Byb2Nlc3NvciUwQSUwQW1vZGVsJTIwJTNEJTIwUG9wMlBpYW5vRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFBvcDJQaWFub1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3dlZXRjb2NvYSUyRnBvcDJwaWFubyUyMiklMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vX2NpJTIyJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRGRzJTVCJTIyYXVkaW8lMjIlNUQlNUIwJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEZHMlNUIlMjJhdWRpbyUyMiU1RCU1QjAlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEFtb2RlbF9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9mZWF0dXJlcyUzRGlucHV0cyU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTJDJTIwY29tcG9zZXIlM0QlMjJjb21wb3NlcjElMjIpJTBBdG9rZW5pemVyX291dHB1dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwdG9rZW5faWRzJTNEbW9kZWxfb3V0cHV0JTJDJTIwZmVhdHVyZV9leHRyYWN0b3Jfb3V0cHV0JTNEaW5wdXRzJTBBKSU1QiUyMnByZXR0eV9taWRpX29iamVjdHMlMjIlNUQlNUIwJTVEJTBBdG9rZW5pemVyX291dHB1dC53cml0ZSglMjIuJTJGT3V0cHV0cyUyRm1pZGlfb3V0cHV0Lm1pZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Pop2PianoProcessor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;sweetcocoa/pop2piano_ci&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=ds[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=ds[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>], composer=<span class="hljs-string">&quot;composer1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = processor.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output.write(<span class="hljs-string">&quot;./Outputs/midi_output.mid&quot;</span>)`,wrap:!1}}),te=new xe({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBQb3AyUGlhbm9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBQb3AyUGlhbm9Qcm9jZXNzb3IlMEElMEFhdWRpbyUyQyUyMHNyJTIwJTNEJTIwbGlicm9zYS5sb2FkKCUyMiUzQ3lvdXJfYXVkaW9fZmlsZV9oZXJlJTNFJTIyJTJDJTIwc3IlM0Q0NDEwMCklMjAlMjAlMjMlMjBmZWVsJTIwZnJlZSUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwc3IlMjB0byUyMGElMjBzdWl0YWJsZSUyMHZhbHVlLiUwQW1vZGVsJTIwJTNEJTIwUG9wMlBpYW5vRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFBvcDJQaWFub1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3dlZXRjb2NvYSUyRnBvcDJwaWFubyUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoYXVkaW8lM0RhdWRpbyUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzciUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBbW9kZWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfZmVhdHVyZXMlM0RpbnB1dHMlNUIlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUyMGNvbXBvc2VyJTNEJTIyY29tcG9zZXIxJTIyKSUwQXRva2VuaXplcl9vdXRwdXQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMHRva2VuX2lkcyUzRG1vZGVsX291dHB1dCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yX291dHB1dCUzRGlucHV0cyUwQSklNUIlMjJwcmV0dHlfbWlkaV9vYmplY3RzJTIyJTVEJTVCMCU1RCUwQXRva2VuaXplcl9vdXRwdXQud3JpdGUoJTIyLiUyRk91dHB1dHMlMkZtaWRpX291dHB1dC5taWQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> librosa
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>audio, sr = librosa.load(<span class="hljs-string">&quot;&lt;your_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)  <span class="hljs-comment"># feel free to change the sr to a suitable value.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Pop2PianoProcessor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=audio, sampling_rate=sr, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>], composer=<span class="hljs-string">&quot;composer1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = processor.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output.write(<span class="hljs-string">&quot;./Outputs/midi_output.mid&quot;</span>)`,wrap:!1}}),ne=new xe({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBQb3AyUGlhbm9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBQb3AyUGlhbm9Qcm9jZXNzb3IlMEElMEElMjMlMjBmZWVsJTIwZnJlZSUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwc3IlMjB0byUyMGElMjBzdWl0YWJsZSUyMHZhbHVlLiUwQWF1ZGlvMSUyQyUyMHNyMSUyMCUzRCUyMGxpYnJvc2EubG9hZCglMjIlM0N5b3VyX2ZpcnN0X2F1ZGlvX2ZpbGVfaGVyZSUzRSUyMiUyQyUyMHNyJTNENDQxMDApJTIwJTIwJTBBYXVkaW8yJTJDJTIwc3IyJTIwJTNEJTIwbGlicm9zYS5sb2FkKCUyMiUzQ3lvdXJfc2Vjb25kX2F1ZGlvX2ZpbGVfaGVyZSUzRSUyMiUyQyUyMHNyJTNENDQxMDApJTBBbW9kZWwlMjAlM0QlMjBQb3AyUGlhbm9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN3ZWV0Y29jb2ElMkZwb3AycGlhbm8lMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwUG9wMlBpYW5vUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihhdWRpbyUzRCU1QmF1ZGlvMSUyQyUyMGF1ZGlvMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0QlNUJzcjElMkMlMjBzcjIlNUQlMkMlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjMlMjBTaW5jZSUyMHdlJTIwbm93JTIwZ2VuZXJhdGluZyUyMGluJTIwYmF0Y2goMiUyMGF1ZGlvcyklMjB3ZSUyMG11c3QlMjBwYXNzJTIwdGhlJTIwYXR0ZW50aW9uX21hc2slMEFtb2RlbF9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9mZWF0dXJlcyUzRGlucHV0cyU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGNvbXBvc2VyJTNEJTIyY29tcG9zZXIxJTIyJTJDJTBBKSUwQXRva2VuaXplcl9vdXRwdXQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMHRva2VuX2lkcyUzRG1vZGVsX291dHB1dCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yX291dHB1dCUzRGlucHV0cyUwQSklNUIlMjJwcmV0dHlfbWlkaV9vYmplY3RzJTIyJTVEJTBBJTBBJTIzJTIwU2luY2UlMjB3ZSUyMG5vdyUyMGhhdmUlMjAyJTIwZ2VuZXJhdGVkJTIwTUlESSUyMGZpbGVzJTBBdG9rZW5pemVyX291dHB1dCU1QjAlNUQud3JpdGUoJTIyLiUyRk91dHB1dHMlMkZtaWRpX291dHB1dDEubWlkJTIyKSUwQXRva2VuaXplcl9vdXRwdXQlNUIxJTVELndyaXRlKCUyMi4lMkZPdXRwdXRzJTJGbWlkaV9vdXRwdXQyLm1pZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> librosa
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the sr to a suitable value.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio1, sr1 = librosa.load(<span class="hljs-string">&quot;&lt;your_first_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>audio2, sr2 = librosa.load(<span class="hljs-string">&quot;&lt;your_second_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Pop2PianoProcessor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=[audio1, audio2], sampling_rate=[sr1, sr2], return_attention_mask=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now generating in batch(2 audios) we must pass the attention_mask</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(
<span class="hljs-meta">... </span>    input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    composer=<span class="hljs-string">&quot;composer1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = processor.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now have 2 generated MIDI files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">0</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output1.mid&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">1</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output2.mid&quot;</span>)`,wrap:!1}}),se=new xe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> librosa
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoFeatureExtractor, Pop2PianoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the sr to a suitable value.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio1, sr1 = librosa.load(<span class="hljs-string">&quot;&lt;your_first_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>audio2, sr2 = librosa.load(<span class="hljs-string">&quot;&lt;your_second_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = Pop2PianoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = Pop2PianoTokenizer.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    audio=[audio1, audio2], 
<span class="hljs-meta">... </span>    sampling_rate=[sr1, sr2], 
<span class="hljs-meta">... </span>    return_attention_mask=<span class="hljs-literal">True</span>, 
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now generating in batch(2 audios) we must pass the attention_mask</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(
<span class="hljs-meta">... </span>    input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    composer=<span class="hljs-string">&quot;composer1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = tokenizer.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now have 2 generated MIDI files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">0</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output1.mid&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">1</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output2.mid&quot;</span>)`,wrap:!1}}),re=new B({props:{title:"Pop2PianoConfig",local:"transformers.Pop2PianoConfig",headingTag:"h2"}}),ie=new J({props:{name:"class transformers.Pop2PianoConfig",anchor:"transformers.Pop2PianoConfig",parameters:[{name:"vocab_size",val:" = 2400"},{name:"composer_vocab_size",val:" = 21"},{name:"d_model",val:" = 512"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 2048"},{name:"num_layers",val:" = 6"},{name:"num_decoder_layers",val:" = None"},{name:"num_heads",val:" = 8"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"initializer_factor",val:" = 1.0"},{name:"feed_forward_proj",val:" = 'gated-gelu'"},{name:"is_encoder_decoder",val:" = True"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"dense_act_fn",val:" = 'relu'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Pop2PianoConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2400) &#x2014;
Vocabulary size of the <code>Pop2PianoForConditionalGeneration</code> model. Defines the number of different tokens
that can be represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.35.2/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a>.`,name:"vocab_size"},{anchor:"transformers.Pop2PianoConfig.composer_vocab_size",description:`<strong>composer_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 21) &#x2014;
Denotes the number of composers.`,name:"composer_vocab_size"},{anchor:"transformers.Pop2PianoConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.Pop2PianoConfig.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. The <code>inner_dim</code> of the projection layer will
be defined as <code>num_heads * d_kv</code>.`,name:"d_kv"},{anchor:"transformers.Pop2PianoConfig.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Size of the intermediate feed forward layer in each <code>Pop2PianoBlock</code>.`,name:"d_ff"},{anchor:"transformers.Pop2PianoConfig.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_layers"},{anchor:"transformers.Pop2PianoConfig.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.Pop2PianoConfig.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.Pop2PianoConfig.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.Pop2PianoConfig.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.Pop2PianoConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.Pop2PianoConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.Pop2PianoConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1.0, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.Pop2PianoConfig.feed_forward_proj",description:`<strong>feed_forward_proj</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;gated-gelu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>.`,name:"feed_forward_proj"},{anchor:"transformers.Pop2PianoConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.Pop2PianoConfig.dense_act_fn",description:`<strong>dense_act_fn</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Type of Activation Function to be used in <code>Pop2PianoDenseActDense</code> and in <code>Pop2PianoDenseGatedActDense</code>.`,name:"dense_act_fn"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/pop2piano/configuration_pop2piano.py#L29"}}),le=new B({props:{title:"Pop2PianoFeatureExtractor",local:"transformers.Pop2PianoFeatureExtractor",headingTag:"h2"}}),de=new J({props:{name:"class transformers.Pop2PianoFeatureExtractor",anchor:"transformers.Pop2PianoFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/utils/dummy_essentia_and_librosa_and_pretty_midi_and_scipy_and_torch_objects.py#L5"}}),ce=new J({props:{name:"__call__",anchor:"transformers.Pop2PianoFeatureExtractor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),pe=new B({props:{title:"Pop2PianoForConditionalGeneration",local:"transformers.Pop2PianoForConditionalGeneration",headingTag:"h2"}}),me=new J({props:{name:"class transformers.Pop2PianoForConditionalGeneration",anchor:"transformers.Pop2PianoForConditionalGeneration",parameters:[{name:"config",val:": Pop2PianoConfig"}],parametersDescription:[{anchor:"transformers.Pop2PianoForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/pop2piano#transformers.Pop2PianoConfig">Pop2PianoConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/pop2piano/modeling_pop2piano.py#L1010"}}),ue=new J({props:{name:"forward",anchor:"transformers.Pop2PianoForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Pop2Piano is a model with relative position embeddings
so you should be able to pad the inputs on both the right and the left. Indices can be obtained using
<a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.
<a href="../glossary#input-ids">What are input IDs?</a> To know more on how to prepare <code>input_ids</code> for pretraining
take a look a <a href="./Pop2Piano#training">Pop2Pianp Training</a>.`,name:"input_ids"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary. Indices can be obtained using
<a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.
<a href="../glossary#decoder-input-ids">What are decoder input IDs?</a> Pop2Piano uses the <code>pad_token_id</code> as the
starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code> is used, optionally only the last
<code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>). To know more on how to prepare`,name:"decoder_input_ids"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Does the same task as <code>inputs_embeds</code>. If <code>inputs_embeds</code> is not present but <code>input_features</code> is present
then <code>input_features</code> will be considered as <code>inputs_embeds</code>.`,name:"input_features"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix. If
<code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value of
<code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/pop2piano/modeling_pop2piano.py#L1109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/pop2piano#transformers.Pop2PianoConfig"
>Pop2PianoConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new so({props:{$$slots:{default:[uo]},$$scope:{ctx:Te}}}),he=new J({props:{name:"generate",anchor:"transformers.Pop2PianoForConditionalGeneration.generate",parameters:[{name:"input_features",val:""},{name:"attention_mask",val:" = None"},{name:"composer",val:" = 'composer1'"},{name:"generation_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
This is the featurized version of audio generated by <code>Pop2PianoFeatureExtractor</code>.
attention_mask &#x2014;
For batched generation <code>input_features</code> are padded to have the same shape across all examples.
<code>attention_mask</code> helps to determine which areas were padded and which were not.<ul>
<li>1 for tokens that are <strong>not padded</strong>,</li>
<li>0 for tokens that are <strong>padded</strong>.</li>
</ul>`,name:"input_features"},{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.composer",description:`<strong>composer</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;composer1&quot;</code>) &#x2014;
This value is passed to <code>Pop2PianoConcatEmbeddingToMel</code> to generate different embeddings for each
<code>&quot;composer&quot;</code>. Please make sure that the composet value is present in <code>composer_to_feature_token</code> in
<code>generation_config</code>. For an example please see
<a href="https://huggingface.co/sweetcocoa/pop2piano/blob/main/generation_config.json" rel="nofollow">https://huggingface.co/sweetcocoa/pop2piano/blob/main/generation_config.json</a> .`,name:"composer"},{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.35.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"generation_config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/pop2piano/modeling_pop2piano.py#L1217",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.
Since Pop2Piano is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.35.2/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.35.2/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.35.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.35.2/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),x=new so({props:{warning:!0,$$slots:{default:[ho]},$$scope:{ctx:Te}}}),fe=new B({props:{title:"Pop2PianoTokenizer",local:"transformers.Pop2PianoTokenizer",headingTag:"h2"}}),ge=new J({props:{name:"class transformers.Pop2PianoTokenizer",anchor:"transformers.Pop2PianoTokenizer",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/utils/dummy_essentia_and_librosa_and_pretty_midi_and_scipy_and_torch_objects.py#L12"}}),_e=new J({props:{name:"__call__",anchor:"transformers.Pop2PianoTokenizer.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),ye=new B({props:{title:"Pop2PianoProcessor",local:"transformers.Pop2PianoProcessor",headingTag:"h2"}}),be=new J({props:{name:"class transformers.Pop2PianoProcessor",anchor:"transformers.Pop2PianoProcessor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/utils/dummy_essentia_and_librosa_and_pretty_midi_and_scipy_and_torch_objects.py#L19"}}),Me=new J({props:{name:"__call__",anchor:"transformers.Pop2PianoProcessor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),{c(){d=r("meta"),T=a(),_=r("p"),G=a(),c(W.$$.fragment),Fe=a(),I=r("div"),I.innerHTML=Ft,Xe=a(),c(V.$$.fragment),Be=a(),R=r("p"),R.innerHTML=Xt,We=a(),q=r("p"),q.textContent=Bt,Ve=a(),N=r("p"),N.innerHTML=Wt,Re=a(),H=r("p"),H.textContent=Vt,qe=a(),E=r("p"),E.innerHTML=Rt,Ne=a(),Q=r("p"),Q.textContent=qt,He=a(),S=r("ol"),S.innerHTML=Nt,Ee=a(),c(Y.$$.fragment),Qe=a(),L=r("p"),L.innerHTML=Ht,Se=a(),D=r("p"),D.innerHTML=Et,Ye=a(),c(A.$$.fragment),Le=a(),O=r("ul"),O.innerHTML=Qt,De=a(),c(K.$$.fragment),Ae=a(),ee=r("ul"),ee.innerHTML=St,Oe=a(),c(te.$$.fragment),Ke=a(),oe=r("ul"),oe.innerHTML=Yt,et=a(),c(ne.$$.fragment),tt=a(),ae=r("ul"),ae.innerHTML=Lt,ot=a(),c(se.$$.fragment),nt=a(),c(re.$$.fragment),at=a(),v=r("div"),c(ie.$$.fragment),Mt=a(),we=r("p"),we.innerHTML=Dt,vt=a(),Pe=r("p"),Pe.innerHTML=At,st=a(),c(le.$$.fragment),rt=a(),k=r("div"),c(de.$$.fragment),Tt=a(),z=r("div"),c(ce.$$.fragment),wt=a(),je=r("p"),je.textContent=Ot,it=a(),c(pe.$$.fragment),lt=a(),y=r("div"),c(me.$$.fragment),Pt=a(),Je=r("p"),Je.innerHTML=Kt,jt=a(),ke=r("p"),ke.innerHTML=eo,Jt=a(),w=r("div"),c(ue.$$.fragment),kt=a(),Ue=r("p"),Ue.innerHTML=to,Ut=a(),c(Z.$$.fragment),Ct=a(),P=r("div"),c(he.$$.fragment),$t=a(),Ce=r("p"),Ce.textContent=oo,Gt=a(),c(x.$$.fragment),dt=a(),c(fe.$$.fragment),ct=a(),U=r("div"),c(ge.$$.fragment),It=a(),F=r("div"),c(_e.$$.fragment),zt=a(),$e=r("p"),$e.textContent=no,pt=a(),c(ye.$$.fragment),mt=a(),C=r("div"),c(be.$$.fragment),Zt=a(),X=r("div"),c(Me.$$.fragment),xt=a(),Ge=r("p"),Ge.textContent=ao,ut=a(),Ze=r("p"),this.h()},l(e){const t=mo("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(o),T=s(e),_=i(e,"P",{}),M(_).forEach(o),G=s(e),p(W.$$.fragment,e),Fe=s(e),I=i(e,"DIV",{class:!0,"data-svelte-h":!0}),g(I)!=="svelte-pz3lm5"&&(I.innerHTML=Ft),Xe=s(e),p(V.$$.fragment,e),Be=s(e),R=i(e,"P",{"data-svelte-h":!0}),g(R)!=="svelte-1hnpp4y"&&(R.innerHTML=Xt),We=s(e),q=i(e,"P",{"data-svelte-h":!0}),g(q)!=="svelte-ni45zt"&&(q.textContent=Bt),Ve=s(e),N=i(e,"P",{"data-svelte-h":!0}),g(N)!=="svelte-qqdyhn"&&(N.innerHTML=Wt),Re=s(e),H=i(e,"P",{"data-svelte-h":!0}),g(H)!=="svelte-vfdo9a"&&(H.textContent=Vt),qe=s(e),E=i(e,"P",{"data-svelte-h":!0}),g(E)!=="svelte-nbagib"&&(E.innerHTML=Rt),Ne=s(e),Q=i(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-axv494"&&(Q.textContent=qt),He=s(e),S=i(e,"OL",{"data-svelte-h":!0}),g(S)!=="svelte-1raht03"&&(S.innerHTML=Nt),Ee=s(e),p(Y.$$.fragment,e),Qe=s(e),L=i(e,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1co0fex"&&(L.innerHTML=Ht),Se=s(e),D=i(e,"P",{"data-svelte-h":!0}),g(D)!=="svelte-1g8fp7r"&&(D.innerHTML=Et),Ye=s(e),p(A.$$.fragment,e),Le=s(e),O=i(e,"UL",{"data-svelte-h":!0}),g(O)!=="svelte-1kx0lud"&&(O.innerHTML=Qt),De=s(e),p(K.$$.fragment,e),Ae=s(e),ee=i(e,"UL",{"data-svelte-h":!0}),g(ee)!=="svelte-v9o7u6"&&(ee.innerHTML=St),Oe=s(e),p(te.$$.fragment,e),Ke=s(e),oe=i(e,"UL",{"data-svelte-h":!0}),g(oe)!=="svelte-q0f5tb"&&(oe.innerHTML=Yt),et=s(e),p(ne.$$.fragment,e),tt=s(e),ae=i(e,"UL",{"data-svelte-h":!0}),g(ae)!=="svelte-1awpm4y"&&(ae.innerHTML=Lt),ot=s(e),p(se.$$.fragment,e),nt=s(e),p(re.$$.fragment,e),at=s(e),v=i(e,"DIV",{class:!0});var $=M(v);p(ie.$$.fragment,$),Mt=s($),we=i($,"P",{"data-svelte-h":!0}),g(we)!=="svelte-1ppufqj"&&(we.innerHTML=Dt),vt=s($),Pe=i($,"P",{"data-svelte-h":!0}),g(Pe)!=="svelte-1g275hz"&&(Pe.innerHTML=At),$.forEach(o),st=s(e),p(le.$$.fragment,e),rt=s(e),k=i(e,"DIV",{class:!0});var ve=M(k);p(de.$$.fragment,ve),Tt=s(ve),z=i(ve,"DIV",{class:!0});var ft=M(z);p(ce.$$.fragment,ft),wt=s(ft),je=i(ft,"P",{"data-svelte-h":!0}),g(je)!=="svelte-1eed40t"&&(je.textContent=Ot),ft.forEach(o),ve.forEach(o),it=s(e),p(pe.$$.fragment,e),lt=s(e),y=i(e,"DIV",{class:!0});var j=M(y);p(me.$$.fragment,j),Pt=s(j),Je=i(j,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-n2zbvh"&&(Je.innerHTML=Kt),jt=s(j),ke=i(j,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-hswkmf"&&(ke.innerHTML=eo),Jt=s(j),w=i(j,"DIV",{class:!0});var Ie=M(w);p(ue.$$.fragment,Ie),kt=s(Ie),Ue=i(Ie,"P",{"data-svelte-h":!0}),g(Ue)!=="svelte-1x9eou8"&&(Ue.innerHTML=to),Ut=s(Ie),p(Z.$$.fragment,Ie),Ie.forEach(o),Ct=s(j),P=i(j,"DIV",{class:!0});var ze=M(P);p(he.$$.fragment,ze),$t=s(ze),Ce=i(ze,"P",{"data-svelte-h":!0}),g(Ce)!=="svelte-roqoi3"&&(Ce.textContent=oo),Gt=s(ze),p(x.$$.fragment,ze),ze.forEach(o),j.forEach(o),dt=s(e),p(fe.$$.fragment,e),ct=s(e),U=i(e,"DIV",{class:!0});var gt=M(U);p(ge.$$.fragment,gt),It=s(gt),F=i(gt,"DIV",{class:!0});var _t=M(F);p(_e.$$.fragment,_t),zt=s(_t),$e=i(_t,"P",{"data-svelte-h":!0}),g($e)!=="svelte-1eed40t"&&($e.textContent=no),_t.forEach(o),gt.forEach(o),pt=s(e),p(ye.$$.fragment,e),mt=s(e),C=i(e,"DIV",{class:!0});var yt=M(C);p(be.$$.fragment,yt),Zt=s(yt),X=i(yt,"DIV",{class:!0});var bt=M(X);p(Me.$$.fragment,bt),xt=s(bt),Ge=i(bt,"P",{"data-svelte-h":!0}),g(Ge)!=="svelte-1eed40t"&&(Ge.textContent=ao),bt.forEach(o),yt.forEach(o),ut=s(e),Ze=i(e,"P",{}),M(Ze).forEach(o),this.h()},h(){b(d,"name","hf:doc:metadata"),b(d,"content",go),b(I,"class","flex flex-wrap space-x-1"),b(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,d),n(e,T,t),n(e,_,t),n(e,G,t),m(W,e,t),n(e,Fe,t),n(e,I,t),n(e,Xe,t),m(V,e,t),n(e,Be,t),n(e,R,t),n(e,We,t),n(e,q,t),n(e,Ve,t),n(e,N,t),n(e,Re,t),n(e,H,t),n(e,qe,t),n(e,E,t),n(e,Ne,t),n(e,Q,t),n(e,He,t),n(e,S,t),n(e,Ee,t),m(Y,e,t),n(e,Qe,t),n(e,L,t),n(e,Se,t),n(e,D,t),n(e,Ye,t),m(A,e,t),n(e,Le,t),n(e,O,t),n(e,De,t),m(K,e,t),n(e,Ae,t),n(e,ee,t),n(e,Oe,t),m(te,e,t),n(e,Ke,t),n(e,oe,t),n(e,et,t),m(ne,e,t),n(e,tt,t),n(e,ae,t),n(e,ot,t),m(se,e,t),n(e,nt,t),m(re,e,t),n(e,at,t),n(e,v,t),m(ie,v,null),l(v,Mt),l(v,we),l(v,vt),l(v,Pe),n(e,st,t),m(le,e,t),n(e,rt,t),n(e,k,t),m(de,k,null),l(k,Tt),l(k,z),m(ce,z,null),l(z,wt),l(z,je),n(e,it,t),m(pe,e,t),n(e,lt,t),n(e,y,t),m(me,y,null),l(y,Pt),l(y,Je),l(y,jt),l(y,ke),l(y,Jt),l(y,w),m(ue,w,null),l(w,kt),l(w,Ue),l(w,Ut),m(Z,w,null),l(y,Ct),l(y,P),m(he,P,null),l(P,$t),l(P,Ce),l(P,Gt),m(x,P,null),n(e,dt,t),m(fe,e,t),n(e,ct,t),n(e,U,t),m(ge,U,null),l(U,It),l(U,F),m(_e,F,null),l(F,zt),l(F,$e),n(e,pt,t),m(ye,e,t),n(e,mt,t),n(e,C,t),m(be,C,null),l(C,Zt),l(C,X),m(Me,X,null),l(X,xt),l(X,Ge),n(e,ut,t),n(e,Ze,t),ht=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),Z.$set($);const ve={};t&2&&(ve.$$scope={dirty:t,ctx:e}),x.$set(ve)},i(e){ht||(u(W.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(Z.$$.fragment,e),u(he.$$.fragment,e),u(x.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),ht=!0)},o(e){h(W.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(Z.$$.fragment,e),h(he.$$.fragment,e),h(x.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),ht=!1},d(e){e&&(o(T),o(_),o(G),o(Fe),o(I),o(Xe),o(Be),o(R),o(We),o(q),o(Ve),o(N),o(Re),o(H),o(qe),o(E),o(Ne),o(Q),o(He),o(S),o(Ee),o(Qe),o(L),o(Se),o(D),o(Ye),o(Le),o(O),o(De),o(Ae),o(ee),o(Oe),o(Ke),o(oe),o(et),o(tt),o(ae),o(ot),o(nt),o(at),o(v),o(st),o(rt),o(k),o(it),o(lt),o(y),o(dt),o(ct),o(U),o(pt),o(mt),o(C),o(ut),o(Ze)),o(d),f(W,e),f(V,e),f(Y,e),f(A,e),f(K,e),f(te,e),f(ne,e),f(se,e),f(re,e),f(ie),f(le,e),f(de),f(ce),f(pe,e),f(me),f(ue),f(Z),f(he),f(x),f(fe,e),f(ge),f(_e),f(ye,e),f(be),f(Me)}}}const go='{"title":"Pop2Piano","local":"pop2piano","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Examples","local":"examples","sections":[],"depth":2},{"title":"Pop2PianoConfig","local":"transformers.Pop2PianoConfig","sections":[],"depth":2},{"title":"Pop2PianoFeatureExtractor","local":"transformers.Pop2PianoFeatureExtractor","sections":[],"depth":2},{"title":"Pop2PianoForConditionalGeneration","local":"transformers.Pop2PianoForConditionalGeneration","sections":[],"depth":2},{"title":"Pop2PianoTokenizer","local":"transformers.Pop2PianoTokenizer","sections":[],"depth":2},{"title":"Pop2PianoProcessor","local":"transformers.Pop2PianoProcessor","sections":[],"depth":2}],"depth":1}';function _o(Te){return lo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Po extends co{constructor(d){super(),po(this,d,_o,fo,io,{})}}export{Po as component};
