# Advanced MCP Development: Building Custom Workflow Servers for Claude Code

Welcome to Unit 3! In this unit, we'll build a practical MCP server that enhances Claude Code with custom development workflows while learning all three MCP primitives.

If you'd like to hear from the creators of MCP, here's a video they made:

<Youtube id="CQywdSdi5iA" />

In this video Theo Chu, David Soria Parra and Alex Albert dive into the Model Context Protocol (MCP), the standard that's changing how AI applications connect with external data and tools.

## What You'll Build

**PR Agent Workflow Server** - An MCP server that demonstrates how to make Claude Code team-aware and workflow-intelligent:

- **Smart PR Management**: Automatic PR template selection based on code changes using MCP Tools
- **CI/CD Monitoring**: Track GitHub Actions with Cloudflare Tunnel and standardized Prompts
- **Team Communication**: Slack notifications demonstrating all MCP primitives working together

## Real-World Case Study

We'll implement a practical scenario every development team faces:

**Before**: Developer manually creates PRs, waits for Actions to complete, manually checks results, remembers to notify team members

**After**: Claude Code connected to your workflow server can intelligently:
- Suggest the right PR template based on changed files
- Monitor GitHub Actions runs and provide formatted summaries
- Automatically notify team via Slack when deployments succeed/fail
- Guide developers through team-specific review processes based on Actions results

## Key Learning Outcomes

1. **Core MCP Primitives**: Master Tools and Prompts through practical examples
2. **MCP Server Development**: Build a functional server with proper structure and error handling
3. **GitHub Actions Integration**: Use Cloudflare Tunnel to receive webhooks and process CI/CD events
4. **Hugging Face Hub Workflows**: Create specialized workflows for LLM development teams
5. **Multi-System Integration**: Connect GitHub, Slack, and Hugging Face Hub through MCP
6. **Claude Code Enhancement**: Make Claude understand your team's specific workflows

## MCP Primitives in Action

This unit provides hands-on experience with the core MCP primitives:

- **Tools** (Module 1): Functions Claude can call to analyze files and suggest templates
- **Prompts** (Module 2): Standardized workflows for consistent team processes
- **Integration** (Module 3): All primitives working together for complex automation

## Module Structure

1. **Module 1: Build MCP Server** - Create a basic server with Tools for PR template suggestions
2. **Module 2: GitHub Actions Integration** - Monitor CI/CD with Cloudflare Tunnel and Prompts
3. **Module 3: Slack Notification** - Team communication integrating all MCP primitives

## Prerequisites

Before starting this unit, ensure you have:

- Completion of Units 1 and 2 
- Basic familiarity with GitHub Actions and webhook concepts
- Access to a GitHub repository for testing (can be a personal test repo)
- A Slack workspace where you can create webhook integrations

### Claude Code Installation and Setup

This unit requires Claude Code to test your MCP server integration.

> [!TIP]
> **Installation Required:** This unit requires Claude Code for testing MCP server integration with AI workflows.

**Quick Setup:**

Follow the [official installation guide](https://docs.anthropic.com/en/docs/claude-code/getting-started) to install Claude Code and complete authentication. The key steps are installing via npm, navigating to your project directory, and running `claude` to authenticate through console.anthropic.com.

Once installed, you'll use Claude Code throughout this unit to test your MCP server and interact with the workflow automation you build.

> [!WARNING]
> **New to Claude Code?** If you encounter any setup issues, the [troubleshooting guide](https://docs.anthropic.com/en/docs/claude-code/troubleshooting) covers common installation and authentication problems.

By the end of this unit, you'll have built a complete MCP server that demonstrates how to transform Claude Code into a powerful team development assistant, with hands-on experience using all three MCP primitives.



<EditOnGithub source="https://github.com/huggingface/mcp-course/blob/main/units/en/unit3/introduction.mdx" />