import os
import json

img_dir = 'data/AMBER/image'
ann_path = '/mnt/petrelfs/wangweiyun/workspace_wwy/InternVL-RL-DPO/internvl_chat_dev/data/AMBER/query_discriminative.json'
gt_path = '/mnt/petrelfs/wangweiyun/workspace_wwy/InternVL-RL-DPO/internvl_chat_dev/data/AMBER/annotations.json'
save_path = '/mnt/petrelfs/wangweiyun/workspace_wwy/InternVL-RL-DPO/internvl_chat_dev/data/AMBER/query_discriminative.jsonl'

prompt = 'Answer the question using a single word or phrase.'

with open(ann_path) as file:
    items = json.load(file)

with open(gt_path) as file:
    truths = json.load(file)

id2trurh = {}
for truth in truths:
    id2trurh[truth['id']] = truth['truth']

data_list = []
for item in items:
    item_id = item['id']
    image = item['image']
    question = item['query']
    label = id2trurh[item_id]

    assert label in ['yes', 'no']

    data_list.append({
        'question_id': item_id,
        'image': image,
        'text': f'{question}\n{prompt}',
        'label': label,
        'category': 'AMBER',
    })

with open(save_path, 'w') as file:
    for data in data_list:
        file.write(json.dumps(data) + '\n')
